/*
 * Decompiled with CFR 0.152.
 */
package com.ifractal.ifponto;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;

public enum IFPONTO_config {
    OK(0, "ok"),
    PARAMETRO_INVALIDO(100, "parametro_invalido"),
    NOME_INVALIDO(101, "Nome invalido"),
    CRACHA_INVALIDO(102, "Cracha invalido"),
    PIS_INVALIDO(103, "PIS invalido"),
    CPF_INVALIDO(104, "CPF invalido"),
    TAMANHO_PARAMETRO_INVALIDO(110, "Tamanho de parametro invalido"),
    TAMANHO_NOME_INVALIDO(111, "Tamanho de nome invalido"),
    TAMANHO_CRACHA_INVALIDO(112, "Tamanho de cracha invalido"),
    TAMANHO_PIS_INVALIDO(113, "Tamanho de PIS invalido"),
    PARAMETRO_REPETIDO(120, "Parametro repetido na lista"),
    PIS_REPETIDO(121, "PIS repetido na lista"),
    CRACHA_REPETIDO(122, "Cracha repetido na lista"),
    FALTA_PARAMETRO(130, "Falta parametro"),
    FALTA_PARAMETRO_NOME(131, "Falta parametro 'Nome'"),
    FALTA_PARAMETRO_CRACHA(132, "Falta parametro 'Cracha'"),
    FALTA_PARAMETRO_PIS(133, "Falta parametro 'PIS'"),
    FALTA_PARAMETRO_BIO(134, "Falta parametro da biometria (dedo1, dedo2, vendor ou template)"),
    ERRO_LOGIN_SENHA(135, "login / senha invalidos"),
    COMANDO_INVALIDO(140, "Comando invalido"),
    LIMITE_ATINGIDO(200, "Limite de cadastros atingido"),
    LIMITE_USUARIOS_ATINGIDO(201, "Limite de cadastro de usuarios atingido"),
    LIMITE_BIO_ATINGIDO(202, "Limite de cadastro de biometrias atingido"),
    NAO_ENCONTRADO(300, "Cadastro nao encontrado"),
    USUARIO_NAO_ENCONTRADO(301, "Usuario nao encontrado"),
    BIO_NAO_ENCONTRADA(302, "Biometria nao encontrada"),
    FACE_NAO_ENCONTRADA(303, "Foto nao encontrada"),
    BIO_INCOMPATIVEL(400, "Biometria incompativel"),
    ERRO_COMUNICACAO(500, "Erro comunicacao"),
    ERRO_INSERT(600, "Falha ao tentar inserir"),
    ERRO_INSERT_CRACHA(601, "Falha ao tentar cadastrar cracha"),
    ERRO_INSERT_NOME(602, "Falha ao tentar cadastrar nome"),
    ERRO_INSERT_PIS(603, "Falha ao tentar cadastrar pis"),
    ERRO_INSERT_BIO(604, "Falha ao tentar inserir biometria"),
    ERRO_INSERT_USER(605, "Falha ao tentar inserir usuario"),
    ERRO_INSERT_REGRAS_ACESSO(606, "Falha ao tentar inserir regras de acesso"),
    ERRO_INSERT_FACE(607, "Falha ao tentar inserir face"),
    ERRO_INSERT_CPF(608, "Falha ao tentar cadastrar cpf"),
    ERRO_DELETE(700, "Falha ao tentar excluir"),
    JSON_INVALIDO(800, "Json invalido"),
    RELOGIO_NAO_SUSPENSO(900, "O equipamento precisa estar suspenso para executar esse comando"),
    ERRO_COLETA(1000, "Erro ao tentar coletar"),
    ERRO_COLETA_EVENTOS(1100, "Erro ao tentar coletar eventos"),
    ERRO_GET_USERS(1200, "Erro ao tentar coletar usuarios"),
    ERRO_GET_BIO(1300, "Erro ao tentar coletar biometrias"),
    EM_PROCESSAMENTO(1400, "Dados em processamento"),
    ERRO_INTERNO(1500, "Erro interno"),
    ERRO_JAVA_INIT(1600, "Falha ao tentar iniciar JAVA"),
    MODULO_HABILITADO(1700, "Modulo habilitado"),
    MODULO_NAO_HABILITADO(1701, "Modulo nao habilitado"),
    CONEXAO_FECHADA(1800, "Conex\u00e3o fechada"),
    REP_SEM_EMPREGADOR(1900, "REP sem empregador"),
    REP_SEM_CPF(1901, "CPF do REP n\u00e3o cadastrado");

    public int codigo;
    public String msg;
    public static String filename;
    public static final String[] IDs;

    private IFPONTO_config(int codigo, String msg) {
        this.codigo = codigo;
        this.msg = msg;
    }

    public static void show() {
        for (IFPONTO_config result : IFPONTO_config.values()) {
            System.err.println(result.name() + " " + result.codigo + " " + result.msg);
        }
    }

    public static String getMsg(int codigo) {
        for (IFPONTO_config result : IFPONTO_config.values()) {
            if (result.codigo != codigo) continue;
            return result.msg;
        }
        return "Erro";
    }

    public static void generateCsResult() {
        String fileName = "./src/main/csharp/RESULT_config.cs";
        String content = "namespace ifponto {\n\tpublic class Result {";
        for (IFPONTO_config result : IFPONTO_config.values()) {
            content = content + "\n\t\tpublic const int " + result.name() + " = " + result.codigo + ";";
        }
        content = content + "\n\n\t\tpublic static string[] IDs = new string[]{";
        for (int i = 0; i < IDs.length; ++i) {
            if (i == IDs.length - 1) {
                content = content + "\"" + IDs[i] + "\"};";
                break;
            }
            content = content + "\"" + IDs[i] + "\", ";
        }
        content = content + "\n\n\t\tpublic static string GetMsg(int res) {\n\t\t\tswitch(res) { ";
        for (IFPONTO_config result : IFPONTO_config.values()) {
            content = content + "\n\t\t\t\tcase " + result.name() + ": return(\"" + result.msg + "\");";
        }
        content = content + "\n\t\t\t}\n\t\t\treturn(\"Erro\");\n\t\t}\n\t}\n}";
        try {
            FileWriter fw = new FileWriter(fileName);
            BufferedWriter bw = new BufferedWriter(fw);
            bw.write(content);
            bw.close();
        }
        catch (IOException ioe) {
            System.err.println(ioe.getMessage());
        }
    }

    public static HashMap<String, String> getParams() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("VERBOSITY", "4");
        params.put("ATIVO", "1");
        params.put("MODO", "0");
        params.put("SYNCTIME", "1");
        params.put("QTD_SEND_USERS", "30");
        params.put("QTD_OFF_FILES", "50");
        params.put("CLIENTID", "");
        params.put("CHAVE", "");
        params.put("READERS", "");
        params.put("CENTRALIZADORES", "");
        params.put("TIMEDIFF", "");
        params.put("ID", "");
        params.put("VERBOSITY", "4");
        params.put("VERBOSITY_PORT", "9001");
        params.put("WEBHOST", "ifractal.srv.br");
        params.put("WEBPORT", "443");
        params.put("HTTP_PORT", "0");
        params.put("SIIN_PATH", "siin_equipamentos.php");
        params.put("ONLINE", "online.php");
        params.put("LOOP", "50");
        params.put("WS", "http://127.0.0.1:9010/ws");
        params.put("PATH_LOG", "log");
        params.put("PATH_OFF", "offs");
        params.put("HAMSTER_LIB", "ib");
        params.put("PASS", "0");
        params.put("OPTIONS", "0");
        params.put("PIS_DEFAULT", "");
        params.put("STACK", "1");
        params.put("LIBRARY_PATH", "bin");
        params.put("CLASSPATH", ".");
        params.put("library", "ifdevice4j");
        params.put("tunnel_host", "74.50.60.155");
        params.put("tunnel_port", "10999");
        params.put("local_port", "10999");
        params.put("DB", "conf/ifponto.db");
        params.put("DBM", "SQLITE");
        return params;
    }

    public static native void initC(String[] var0);

    public static void main(String[] args) {
        IFPONTO_config.generateCsResult();
    }

    static {
        filename = "conf/ifponto.ini";
        IDs = new String[]{"id", "pis", "cracha", "matricula", "codigo", "code"};
    }
}

