/*
 * Decompiled with CFR 0.152.
 */
package com.ifractal.ifponto;

import com.ifractal.ifponto.DeviceExtended;
import com.ifractal.ifponto.IFPONTO_config;
import com.ifractal.ifponto.VetronicContext;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class Vetronic
extends DeviceExtended<VetronicContext> {
    public static final String NUM_SERVER = "99";
    public static final String CMD_HELLO = "1";
    public static final String CMD_FORMAT_ALL = "49";
    public static final String CMD_BYE = "50";
    public static final String CMD_QTY_OFF_UNREAD = "11;1";
    public static final String CMD_QTY_OFF_ALL = "11;4";
    public static final String CMD_GET_OFF_UNREAD = "12;1";
    public static final String CMD_GET_OFF_ALL = "12;4";
    public static final String CMD_SET_DATE = "14";
    public static final String CMD_GET_DATE = "15";
    public static final String CMD_RECV_CONFIG = "4";
    public static final String CMD_SEND_CONFIG = "3";
    public static final String CMD_SEND_ID_TAB = "7";
    public static final String CMD_SEND_TIME_TAB = "8";
    public static final String CMD_SEND_MSG_TAB = "9";
    public static final String CMD_SEND_SIGN_TAB = "10";

    public Vetronic(JSONObject c) {
        super(c);
    }

    @Override
    public VetronicContext openContext() {
        VetronicContext ctx = null;
        try {
            ctx = new VetronicContext(this.ip, this.port);
            ctx.open();
        }
        catch (IOException ioe) {
            this.sendMessage(2, ioe.getMessage());
        }
        catch (InterruptedException ie) {
            this.sendMessage(2, ie.getMessage());
        }
        return ctx;
    }

    @Override
    public void closeContext(VetronicContext ctx) {
        try {
            ctx.close();
        }
        catch (IOException ioe) {
            this.sendMessage(2, ioe.getMessage());
        }
    }

    @Override
    public int updateUser(VetronicContext ctx, JSONObject user) {
        String cracha = user.get((Object)"cracha").toString();
        String pack = String.format("%s;%d;%s;0;0;0;0;0;0;0;0;0;0;0;0;0;1/1/5;0;1/1/5;0;0;0;1/1;0;1/1;1;\r", CMD_SEND_ID_TAB, 0, cracha);
        try {
            ctx.sendRecv(pack);
        }
        catch (IOException ioe) {
            return IFPONTO_config.valueOf((String)"ERRO_COMUNICACAO").codigo;
        }
        catch (InterruptedException ioe) {
            return IFPONTO_config.valueOf((String)"ERRO_INTERNO").codigo;
        }
        return 0;
    }

    @Override
    public int deleteUser(VetronicContext ctx, JSONObject user) {
        return 0;
    }

    @Override
    public int sendUserBio(VetronicContext ctx, JSONObject user) {
        return 0;
    }

    @Override
    public int deleteUserBio(VetronicContext ctx, JSONObject user) {
        return 0;
    }

    @Override
    public int getUserBio(VetronicContext ctx, JSONObject user) {
        return 0;
    }

    @Override
    public void getInfo(JSONObject config) {
        try {
            VetronicContext ctx = this.openContext();
            ctx.close();
        }
        catch (IOException ioe) {
            return;
        }
    }

    @Override
    public Date getTime() {
        Date dt = null;
        try {
            VetronicContext ctx = this.openContext();
            String res = ctx.sendRecv(CMD_GET_DATE);
            String[] tk = res.split(";");
            SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yy HH:mm:ss");
            if (tk.length > 3) {
                dt = sdf.parse(tk[3]);
            } else {
                this.sendMessage(2, "getTime - resposta invalida: " + res);
            }
            ctx.close();
        }
        catch (IOException ioe) {
            this.sendMessage(2, ioe.getMessage());
            return null;
        }
        catch (InterruptedException ie) {
            return null;
        }
        catch (ParseException pe) {
            this.sendMessage(2, pe.getMessage());
            return null;
        }
        return dt;
    }

    @Override
    public boolean setTime(int diff) {
        Date ref = new Date();
        long unix = ref.getTime();
        SimpleDateFormat sdt = new SimpleDateFormat("dd/MM/yy HH:mm:ss");
        ref.setTime(unix += (long)(diff * 3600 * 1000));
        try {
            VetronicContext ctx = this.openContext();
            String msg = "14;" + sdt.format(ref);
            ctx.sendRecv(msg);
            ctx.close();
        }
        catch (IOException ioe) {
            this.sendMessage(2, ioe.getMessage());
            return false;
        }
        catch (InterruptedException ie) {
            return false;
        }
        return true;
    }

    @Override
    public JSONArray getUsers() {
        try {
            VetronicContext ctx = this.openContext();
            ctx.close();
        }
        catch (IOException ioe) {
            this.sendMessage(2, ioe.getMessage());
            return null;
        }
        return null;
    }

    @Override
    public int getEvents(JSONArray offs) {
        int qty = 0;
        try {
            VetronicContext ctx = this.openContext();
            String res = ctx.sendRecv(CMD_QTY_OFF_UNREAD);
            String[] tk = res.split(";");
            qty = tk.length > 4 ? Integer.parseInt(tk[4]) : -1;
            if (qty > 0) {
                String line;
                while ((tk = (line = ctx.sendRecv(CMD_GET_OFF_UNREAD)).split(";")).length >= 4 && Integer.parseInt(tk[4]) != 2) {
                    if (tk.length < 11) {
                        this.sendMessage(3, "Falha na coleta...\n");
                        break;
                    }
                    JSONObject evt = new JSONObject();
                    offs.add((Object)evt);
                    evt.put((Object)"nro_cartao", (Object)Integer.parseInt(tk[5]));
                    evt.put((Object)"canal", (Object)tk[9]);
                    evt.put((Object)"sentido", (Object)tk[10]);
                    String datahora = String.format("20%c%c-%c%c-%c%c %s:00", Character.valueOf(tk[6].charAt(6)), Character.valueOf(tk[6].charAt(7)), Character.valueOf(tk[6].charAt(3)), Character.valueOf(tk[6].charAt(4)), Character.valueOf(tk[6].charAt(0)), Character.valueOf(tk[6].charAt(1)), tk[7]);
                    evt.put((Object)"datahora", (Object)datahora);
                }
            }
            ctx.close();
        }
        catch (IOException ioe) {
            this.sendMessage(2, ioe.getMessage());
            return -1;
        }
        catch (InterruptedException ie) {
            return -2;
        }
        return 0;
    }
}

