/*
 * Decompiled with CFR 0.152.
 */
package com.ifractal.utils;

import android.content.Context;
import android.database.SQLException;
import android.database.sqlite.SQLiteConstraintException;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.database.sqlite.SQLiteStatement;
import com.ifractal.utils.ConnectDB;
import com.ifractal.utils.ConsumerDB;
import com.ifractal.utils.DBAndroid;
import com.ifractal.utils.Observer;
import com.ifractal.utils.SessionDB;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class ConnectDBAndroid
extends SQLiteOpenHelper
implements ConnectDB {
    protected ConsumerDB consumer = null;
    protected String dbname = null;
    protected int revision = 0;

    public ConnectDBAndroid(Context ctx, String db, int rev, ConsumerDB cons) {
        super(ctx, db, null, rev);
        this.dbname = db;
        this.revision = rev;
        this.consumer = cons;
    }

    public void onCreate(SQLiteDatabase db) {
        String sql = this.consumer.getSQLSchema();
        String[] array = sql.split(";");
        for (int i = 0; i < array.length - 1; ++i) {
            int n = i;
            array[n] = array[n] + ";";
            db.execSQL(array[i]);
        }
    }

    public void onDowngrade(SQLiteDatabase db, int n, int o) {
    }

    public void onUpgrade(SQLiteDatabase db, int n, int o) {
        String[] sql = this.consumer.getSQLChangeSchema(o);
        if (sql == null) {
            return;
        }
        for (String ch : sql) {
            db.execSQL(ch);
        }
    }

    @Override
    public SessionDB getNewSession(ConsumerDB consumer, Observer obs) {
        SessionAndroid sess = new SessionAndroid(consumer, this, obs);
        return sess;
    }

    private class SessionAndroid
    extends SessionDB {
        ConnectDBAndroid ca;
        ConsumerDB cons;
        SQLiteDatabase dbw;
        String[] stmtkeys;
        SQLiteStatement[] pstmts;

        public SessionAndroid(ConsumerDB consumer, ConnectDBAndroid c, Observer obs) {
            super(obs);
            this.ca = null;
            this.cons = null;
            this.dbw = null;
            this.stmtkeys = null;
            this.pstmts = null;
            this.ca = c;
            this.cons = consumer;
        }

        @Override
        public boolean open() {
            if (this.dbw != null && this.dbw.isOpen()) {
                return true;
            }
            this.dbw = this.ca.getWritableDatabase();
            if (this.pstmts != null) {
                return true;
            }
            String[] stmts = this.cons.getStatements();
            this.pstmts = new SQLiteStatement[stmts.length / 2];
            this.stmtkeys = new String[this.pstmts.length];
            int i = 0;
            int k = 0;
            while (i + 1 < stmts.length) {
                this.stmtkeys[k] = stmts[i + 0];
                this.pstmts[k] = this.dbw.compileStatement(stmts[i + 1]);
                i += 2;
                ++k;
            }
            return true;
        }

        @Override
        public void close() {
            this.dbw.close();
        }

        @Override
        public synchronized JSONArray execute(String stmtKey, String[] fields, String iStmtKey, String[] iFields) {
            int error = 0;
            JSONArray res = new JSONArray();
            JSONObject ret = new JSONObject();
            if (!this.open()) {
                return res;
            }
            if (stmtKey.startsWith("Select")) {
                res = this.executeQuery(stmtKey, fields);
                return res;
            }
            if (iStmtKey != null && iFields != null) {
                error = this.executeUpsert(stmtKey, iStmtKey, fields, iFields);
            } else if (stmtKey.startsWith("Update") || stmtKey.startsWith("Insert") || stmtKey.startsWith("Delete")) {
                error = this.executeUpdate(stmtKey, fields);
            }
            ret.put((Object)"error", (Object)error);
            res.add((Object)ret);
            return res;
        }

        @Override
        public int executeUpsert(String uStmtKey, String iStmtKey, String[] uFields, String[] iFields) {
            block8: {
                SQLiteStatement iStmt;
                boolean update;
                block7: {
                    update = false;
                    SQLiteStatement uStmt = this.getStatement(uStmtKey);
                    iStmt = this.getStatement(iStmtKey);
                    if (uStmt == null || iStmt == null) {
                        return -1;
                    }
                    try {
                        update = DBAndroid.executeUpdate(this, uStmt, uFields);
                        if (update) {
                            return 0;
                        }
                    }
                    catch (SQLException se) {
                        this.sendMessage(5, se.getMessage());
                        if (!(se instanceof SQLiteConstraintException)) break block7;
                        return 0;
                    }
                }
                try {
                    update = DBAndroid.executeInsert(this, iStmt, iFields);
                    if (update) {
                        return 0;
                    }
                }
                catch (SQLException se) {
                    this.sendMessage(5, se.getMessage());
                    if (!(se instanceof SQLiteConstraintException)) break block8;
                    return 0;
                }
            }
            return -1;
        }

        @Override
        public int executeUpdate(String stmtKey, String[] fields) {
            block6: {
                SQLiteStatement stmt = this.getStatement(stmtKey);
                if (stmt == null) {
                    return -1;
                }
                try {
                    boolean update = false;
                    if (stmtKey.startsWith("i") || stmtKey.startsWith("I")) {
                        update = DBAndroid.executeInsert(this, stmt, fields);
                        if (update) {
                            return 0;
                        }
                        return -1;
                    }
                    update = DBAndroid.executeUpdate(this, stmt, fields);
                    if (update) {
                        return 0;
                    }
                }
                catch (SQLException se) {
                    this.sendMessage(1, se.getMessage());
                    if (!(se instanceof SQLiteConstraintException)) break block6;
                    return 0;
                }
            }
            return -1;
        }

        @Override
        public JSONArray executeQuery(String stmtKey, String[] fields) {
            SQLiteStatement stmt = this.getStatement(stmtKey);
            if (stmt == null) {
                return null;
            }
            return DBAndroid.executeQuery(this, this.dbw, stmt, fields);
        }

        protected SQLiteStatement getStatement(String key) {
            for (int i = 0; i < this.stmtkeys.length; ++i) {
                if (!this.stmtkeys[i].equals(key)) continue;
                return this.pstmts[i];
            }
            return null;
        }
    }
}

