/*
 * Decompiled with CFR 0.152.
 */
package com.ifractal.ifponto;

import android.content.Context;
import com.ifractal.ifponto.Device;
import com.ifractal.ifponto.IFPONTO_config;
import com.ifractal.ifponto.Version;
import com.ifractal.utils.ConnectDB;
import com.ifractal.utils.ConnectDBAndroid;
import com.ifractal.utils.ConnectJDBC;
import com.ifractal.utils.ConsumerDB;
import com.ifractal.utils.Getopts;
import com.ifractal.utils.IfaceJSONIter;
import com.ifractal.utils.Observer;
import com.ifractal.utils.Producer;
import com.ifractal.utils.SessionDB;
import com.ifractal.utils.Util;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.HashMap;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class IfpontoDB
extends Producer
implements ConsumerDB,
Cloneable {
    public static final String INIFILE = IFPONTO_config.filename.replace("/", File.separator);
    public static HashMap<String, String> config = null;
    private final SQLChange[] changeTable = new SQLChange[]{new SQLChange(2709, new String[]{"ALTER TABLE equipamento ADD COLUMN ativo BOOLEAN NOT NULL DEFAULT true;", "ALTER TABLE equipamento ADD COLUMN timediff INTEGER NOT NULL DEFAULT 0;"}), new SQLChange(2712, new String[]{"ALTER TABLE biometria ADD COLUMN sincronizado BOOLEAN NOT NULL DEFAULT 'FALSE';"}), new SQLChange(2733, new String[]{"ALTER TABLE equipamento ADD COLUMN siin_nsr INTEGER NOT NULL DEFAULT 0;"}), new SQLChange(2849, new String[]{"ALTER TABLE evento ADD COLUMN codigo INTEGER NULL;"})};
    protected ConnectDB cdb = null;
    protected String dbname = null;
    protected SessionDB sess = null;
    protected static final String Insert_equipamento = "INSERT INTO equipamento(codigo_ifponto,numero,modelo,nome,ip,porta,login,senha,config) VALUES(?,?,?,?,?,?,?,?,?);";
    protected static final String Update_equipamento = "UPDATE equipamento SET ativo = 1, dtupdated = CURRENT_TIMESTAMP, modelo = ?, nome = ?, ip = ?, porta = ?, login = ?, senha = ?, config = ?, timediff = ? WHERE codigo_ifponto = ?;";
    protected static final String Update_inativa_equipamentos = "UPDATE equipamento SET ativo = 0;";
    protected static final String Update_equipamento_nsr = "UPDATE equipamento SET nsr = ? WHERE codigo_ifponto = ?";
    protected static final String Update_equipamento_siin_nsr = "UPDATE equipamento SET siin_nsr = ? WHERE codigo_ifponto = ?";
    protected static final String Update_equipamento_status = "UPDATE equipamento SET status = ? WHERE codigo_ifponto = ?";
    protected static final String Insert_pessoa = "INSERT INTO pessoa(codigo_ifponto,nome,pis,id_ifponto,verificar_biometria) VALUES (?,?,?,?,?);";
    protected static final String Update_pessoa = "UPDATE pessoa SET dtupdated = CURRENT_TIMESTAMP, nome = ?, pis = ?, id_ifponto = ?, verificar_biometria = ? WHERE codigo_ifponto = ?;";
    protected static final String Insert_pessoa_equipamento = "INSERT INTO pessoa_equipamento(equipamento_id,pessoa_id, codigo_ifponto, operacao) SELECT e.id, p.id, ?, ? FROM equipamento e, pessoa p WHERE e.codigo_ifponto = ? AND p.codigo_ifponto = ?;";
    protected static final String Update_pessoa_equipamento = "UPDATE pessoa_equipamento SET dtupdated = CURRENT_TIMESTAMP, situacao = 1, sincronizado = 0, descricao = '', codigo_ifponto = ?, operacao = ? WHERE equipamento_id IN (SELECT id FROM equipamento WHERE codigo_ifponto = ?) AND pessoa_id IN (SELECT id FROM pessoa WHERE codigo_ifponto = ?);";
    protected static final String Delete_cartao = "DELETE FROM cartao WHERE numero = ?;";
    protected static final String Insert_cartao = "INSERT INTO cartao(pessoa_id,numero,tipo,tecnologia,hrinicio,hrfim,liberador,ativo) SELECT p.id,?,?,?,?,?,?,? FROM pessoa p WHERE p.codigo_ifponto = ?;";
    protected static final String Update_cartao = "UPDATE cartao SET dtupdated = CURRENT_TIMESTAMP, tipo = ?, tecnologia = ?, hrinicio = ?, hrfim = ?, liberador = ?, ativo = ? WHERE numero = ?;";
    protected static final String Delete_bio = "DELETE FROM biometria WHERE pessoa_id IN (SELECT id FROM pessoa WHERE codigo_ifponto = ?);";
    protected static final String Insert_bio = "INSERT INTO biometria(pessoa_id,sincronizado,template,vendor,encode) SELECT p.id,?,?,?,? FROM pessoa p WHERE p.codigo_ifponto = ?;";
    protected static final String Select_devices = "SELECT codigo_ifponto as codigo, numero as nro, nsr, modelo, nome, ip, porta, login as user, senha as pass, status, timediff, ativo, config FROM equipamento;";
    protected static final String Select_device_nro = "SELECT codigo_ifponto as codigo, numero as nro, nsr, siin_nsr, modelo, nome, ip, porta, login as user, senha as pass, status, timediff FROM equipamento e WHERE e.numero = ?;";
    protected static final String Select_device_cod = "SELECT codigo_ifponto as codigo, numero as nro, nsr, siin_nsr, modelo, nome, ip, porta, login as user, senha as pass, status, timediff FROM equipamento e WHERE e.codigo_ifponto = ?;";
    protected static final String Select_pessoas = "SELECT p.id_ifponto, p.pis, p.nome, p.verificar_biometria, p.dtupdated FROM pessoa p, pessoa_equipamento pe, equipamento e WHERE pe.pessoa_id = p.id AND pe.equipamento_id = e.id AND e.numero = ?;";
    protected static final String Select_pessoa_nome = "SELECT id_ifponto, pis, nome, verificar_biometria, dtupdated FROM pessoa WHERE nome LIKE '%'||?||'%';";
    protected static final String Select_pessoa_pis = "SELECT p.id_ifponto, p.pis, p.nome, p.verificar_biometria, p.dtupdated FROM pessoa p WHERE p.pis LIKE '%'||?||'%';";
    protected static final String Select_pendentes = "SELECT pe.pessoa_id, pe.equipamento_id, pe.codigo_ifponto as cod, p.codigo_ifponto as codigo, p.nome, p.pis, p.verificar_biometria, pe.operacao as tipo FROM pessoa p, pessoa_equipamento pe, equipamento e WHERE pe.pessoa_id = p.id AND pe.equipamento_id = e.id AND pe.situacao = 1 AND e.codigo_ifponto = ?;";
    protected static final String Select_pendentes_processando = "SELECT pe.pessoa_id, pe.equipamento_id, pe.codigo_ifponto as cod, p.codigo_ifponto as codigo, p.nome, p.pis, p.verificar_biometria, pe.operacao as tipo FROM pessoa p, pessoa_equipamento pe, equipamento e WHERE pe.pessoa_id = p.id AND pe.equipamento_id = e.id AND pe.situacao = 2 AND e.codigo_ifponto = ?;";
    protected static final String Select_descricao_pendente = "SELECT descricao FROM pessoa_equipamento WHERE codigo_ifponto = ?;";
    protected static final String Update_pendentes = "UPDATE pessoa_equipamento SET dtupdated = CURRENT_TIMESTAMP, situacao = ?, sincronizado = ?, descricao = ? WHERE codigo_ifponto = ?;";
    protected static final String Select_cartoes = "SELECT c.numero as nro, c.tipo, c.hrinicio, c.hrfim, c.liberador, c.json, c.id FROM cartao c WHERE c.ativo = 1 AND c.pessoa_id = ?;";
    protected static final String Select_bios = "SELECT b.vendor, b.encode, b.template, b.json FROM biometria b, pessoa p WHERE b.pessoa_id = p.id AND p.id = ?;";
    protected static final String Insert_evento = "INSERT INTO evento (pessoa_id,equipamento_id, nsr, afd, tipo_afd, datahora, descricao, codigo) SELECT p.id, e.id, ?, ?, ?, ?, ?, ? FROM pessoa p, equipamento e WHERE ((p.pis != ? AND p.pis = ?) OR (p.id_ifponto != ? AND p.id_ifponto = ?)) AND e.codigo_ifponto = ?;";
    protected static final String Insert_evento_anonimo = "INSERT INTO evento (equipamento_id, nsr, afd, tipo_afd, datahora, descricao, codigo) SELECT e.id, ?, ?, ?, ?, ?, ? FROM equipamento e WHERE e.codigo_ifponto = ?;";
    protected static final String Insert_evento_pis = "INSERT INTO evento (pessoa_id,equipamento_id) SELECT p.id, e.id FROM pessoa p, equipamento e WHERE p.pis = ? AND e.numero = ?;";
    protected static final String Insert_evento_login = "INSERT INTO evento (pessoa_id,equipamento_id) SELECT p.id, e.id FROM pessoa p, equipamento e WHERE p.login = ? AND p.senha = ? AND e.numero = ?;";
    protected static final String Select_evento_nsr = "SELECT strftime('%Y-%m-%d %H:%M:%S', datahora) as datahora, e.nsr, e.id as evento_id, tipo_afd as tipo_registro, afd, sincronizado FROM evento e, equipamento eq WHERE e.equipamento_id = eq.id AND eq.codigo_ifponto = ? AND e.nsr = ?";
    protected static final String Select_ultimo_evento = "SELECT strftime('%Y-%m-%d %H:%M:%S', datahora) as datahora, e.id as nsr, printf('%09d%d%s%012d', e.id, tipo_afd, strftime('%d%m%Y%H%M',datahora), p.pis) as afd, p.nome, p.pis FROM evento e, pessoa p WHERE e.id = last_insert_rowid() AND e.pessoa_id = p.id;";
    protected static final String Select_ultimos_eventos = "SELECT strftime('%Y-%m-%d %H:%M:%S', datahora) as datahora, e.nsr, printf('%09d%d%s%012d', e.id, tipo_afd, strftime('%d%m%Y%H%M',datahora), p.pis) as afd, p.nome, p.pis FROM evento e, pessoa p, equipamento eq WHERE e.pessoa_id = p.id AND e.equipamento_id = eq.id AND eq.numero = ? limit ?;";
    protected static final String Select_no_sync_events = "SELECT strftime('%Y-%m-%d %H:%M:%S', datahora) as datahora, e.nsr, e.id as evento_id, tipo_afd as tipo_registro, codigo FROM evento e, equipamento eq WHERE e.equipamento_id = eq.id AND eq.numero = ? AND NOT e.sincronizado ORDER BY datahora limit ?";
    protected static final String Select_no_sync_events_afd = "SELECT strftime('%Y-%m-%d %H:%M:%S', datahora) as datahora, e.nsr, e.id as evento_id, tipo_afd as tipo_registro, afd, codigo FROM evento e, equipamento eq WHERE e.equipamento_id = eq.id AND eq.numero = ? AND NOT e.sincronizado ORDER BY datahora limit ?";
    protected static final String Select_no_sync_results = "SELECT pe.dtupdated as datahora, pe.codigo_ifponto as cod, p.nome, p.codigo_ifponto as codigo, pe.descricao as status, CASE situacao WHEN '3' THEN '0' WHEN '4' THEN '1' END as cod_error FROM pessoa_equipamento pe, pessoa p, equipamento eq WHERE pe.pessoa_id = p.id AND pe.equipamento_id = eq.id AND eq.numero = ? AND NOT pe.sincronizado AND (situacao = '3' OR situacao = '4') ORDER BY datahora limit ?";
    protected static final String Select_no_sync_bios = "SELECT p.codigo_ifponto as codigo, p.pis, b.template, b.vendor, b.encode, b.id as bio_id FROM pessoa p, biometria b WHERE p.id = b.pessoa_id AND NOT b.sincronizado limit ?";
    protected static final String Update_sync_evento = "UPDATE evento SET sincronizado = 1 WHERE id = ?;";
    protected static final String Update_rollback_evento = "UPDATE evento SET sincronizado = 0 WHERE id = ?;";
    protected static final String Update_sync_result = "UPDATE pessoa_equipamento SET sincronizado = 1 WHERE codigo_ifponto = ?;";
    protected static final String Update_rollback_result = "UPDATE pessoa_equipamento SET sincronizado = 0 WHERE codigo_ifponto = ?;";
    protected static final String Update_sync_bio = "UPDATE biometria SET sincronizado = 1 WHERE id = ?;";

    public IfpontoDB(String[] args, Observer obs) {
        super(obs);
    }

    protected void init(String[] params, Observer obs) {
        config = IFPONTO_config.getParams();
        Getopts.parseIniFile(config, INIFILE);
        Getopts.parseStringArray(config, params);
        JSONObject jo = new JSONObject();
        jo.putAll(config);
        try {
            Class.forName("android.database.sqlite.SQLiteOpenHelper");
            this.dbname = config.get("DB").replace("/", File.separator);
            this.cdb = new ConnectDBAndroid((Context)Producer.androidContext, this.dbname, Version.getRevision(), this);
        }
        catch (ClassNotFoundException cnfe) {
            this.dbname = "jdbc:sqlite:" + config.get("DB").replace("/", File.separator);
            this.cdb = new ConnectJDBC(this.dbname, Version.getRevision(), this, obs);
        }
    }

    @Override
    public String getSQLSchema() {
        this.sendMessage(4, "Inicializa Banco de Dados.");
        InputStream is = this.getClass().getResourceAsStream("/com/ifractal/ifponto/rep.sql");
        String content = Util.getContent(is);
        return content;
    }

    @Override
    public String[] getStatements() {
        String[] sts = new String[]{"Insert_equipamento", Insert_equipamento, "Update_equipamento", Update_equipamento, "Update_inativa_equipamentos", Update_inativa_equipamentos, "Update_equipamento_nsr", Update_equipamento_nsr, "Update_equipamento_siin_nsr", Update_equipamento_siin_nsr, "Update_equipamento_status", Update_equipamento_status, "Insert_pessoa", Insert_pessoa, "Update_pessoa", Update_pessoa, "Insert_pessoa_equipamento", Insert_pessoa_equipamento, "Update_pessoa_equipamento", Update_pessoa_equipamento, "Delete_cartao", Delete_cartao, "Insert_cartao", Insert_cartao, "Update_cartao", Update_cartao, "Delete_bio", Delete_bio, "Insert_bio", Insert_bio, "Select_devices", Select_devices, "Select_device_nro", Select_device_nro, "Select_device_cod", Select_device_cod, "Select_pessoas", Select_pessoas, "Select_pessoa_nome", Select_pessoa_nome, "Select_pessoa_pis", Select_pessoa_pis, "Select_pendentes", Select_pendentes, "Select_pendentes_processando", Select_pendentes_processando, "Select_descricao_pendente", Select_descricao_pendente, "Update_pendentes", Update_pendentes, "Select_cartoes", Select_cartoes, "Select_bios", Select_bios, "Select_evento_nsr", Select_evento_nsr, "Select_ultimo_evento", Select_ultimo_evento, "Select_ultimos_eventos", Select_ultimos_eventos, "Select_no_sync_events", Select_no_sync_events, "Select_no_sync_events_afd", Select_no_sync_events_afd, "Select_no_sync_results", Select_no_sync_results, "Select_no_sync_bios", Select_no_sync_bios, "Update_sync_evento", Update_sync_evento, "Update_rollback_evento", Update_rollback_evento, "Update_sync_result", Update_sync_result, "Update_rollback_result", Update_rollback_result, "Update_sync_bio", Update_sync_bio, "Insert_evento", Insert_evento, "Insert_evento_anonimo", Insert_evento_anonimo, "Insert_evento_pis", Insert_evento_pis, "Insert_evento_login", Insert_evento_login};
        return sts;
    }

    @Override
    public String[] getSQLChangeSchema(int lastVersion) {
        this.sendMessage(4, "Atualiza versao do banco de dados.");
        int len = 0;
        for (SQLChange ch : this.changeTable) {
            if (ch.version <= lastVersion) continue;
            len += ch.changes.length;
        }
        if (len < 1) {
            return null;
        }
        int i = 0;
        String[] changes = new String[len];
        for (SQLChange ch : this.changeTable) {
            if (ch.version < lastVersion) continue;
            for (String s : ch.changes) {
                changes[i++] = s;
            }
        }
        return changes;
    }

    public boolean open(Object ctx, Observer obs) {
        this.setAndroidContext(ctx);
        return this.open(obs);
    }

    public boolean open(Observer obs) {
        this.sess = this.cdb.getNewSession(this, obs);
        if (this.sess == null) {
            this.sendMessage(2, "Falha ao tentar inicializar banco de dados: " + this.dbname);
            return false;
        }
        return true;
    }

    public void close() {
    }

    public void updateStatus(String codigo, JSONObject config) {
        String[] values = new String[]{config.toString(), codigo};
        this.sess.execute("Update_equipamento_status", values, null, null);
    }

    public void updateNsr(String codigo, String nsr) {
        String[] values = new String[]{nsr, codigo};
        this.sess.execute("Update_equipamento_nsr", values, null, null);
    }

    public int getSiinNsr(String codigo) {
        String[] values = new String[]{codigo};
        JSONArray jdevice = this.sess.execute("Select_device_cod", values, null, null);
        if (jdevice == null || jdevice.size() < 1 || !((JSONObject)jdevice.get(0)).containsKey((Object)"siin_nsr")) {
            return -1;
        }
        if (((JSONObject)jdevice.get(0)).get((Object)"siin_nsr") == null) {
            return -1;
        }
        return Integer.parseInt(((JSONObject)jdevice.get(0)).get((Object)"siin_nsr").toString());
    }

    public int getNsr(String codigo) {
        String[] values = new String[]{codigo};
        JSONArray jdevice = this.sess.execute("Select_device_cod", values, null, null);
        if (jdevice == null || jdevice.size() < 1 || !((JSONObject)jdevice.get(0)).containsKey((Object)"nsr")) {
            return 1;
        }
        if (((JSONObject)jdevice.get(0)).get((Object)"nsr") == null) {
            return 1;
        }
        return Integer.parseInt(((JSONObject)jdevice.get(0)).get((Object)"nsr").toString());
    }

    public void updateOffs(final String codigo, JSONArray offs) {
        String[] values;
        IfaceJSONIter iter = new IfaceJSONIter(){

            @Override
            public int perform(JSONObject off, Object[] pars, int[] count) {
                boolean done = false;
                String tipo_registro = "3";
                String datahora = "";
                String descricao = off.toString();
                count[1] = count[1] + 1;
                int nsr_default = count[1];
                if (off.containsKey((Object)"data") && off.containsKey((Object)"hora")) {
                    String year = off.get((Object)"data").toString().substring(4, 8);
                    String month = off.get((Object)"data").toString().substring(2, 4);
                    String day = off.get((Object)"data").toString().substring(0, 2);
                    String hour = off.get((Object)"hora").toString().substring(0, 2);
                    String min = off.get((Object)"hora").toString().substring(2, 4);
                    datahora = String.format("%s-%s-%s %s:%s:00", year, month, day, hour, min);
                } else if (off.containsKey((Object)"afd")) {
                    String afd = off.get((Object)"afd").toString();
                    String year = afd.substring(14, 18);
                    String month = afd.substring(12, 14);
                    String day = afd.substring(10, 12);
                    String hour = afd.substring(18, 20);
                    String min = afd.substring(20, 22);
                    datahora = String.format("%s-%s-%s %s:%s:00", year, month, day, hour, min);
                }
                String[] defaults = new String[]{"nsr", Integer.toString(nsr_default), "afd", "", "tipo_registro", tipo_registro, "datahora", datahora, "pis", "", "empty", "", "nro_cartao", "", "codigo_ifponto", codigo, "descricao", descricao, "codigo", null};
                Util.fillObject(off, defaults);
                String[] keys = new String[]{"nsr", "afd", "tipo_registro", "datahora", "descricao", "codigo", "empty", "pis", "empty", "nro_cartao", "codigo_ifponto"};
                String[] out = Util.fillStringArray(off, keys, null);
                String[] out2 = new String[]{out[0], out[1], out[2], out[3], descricao, out[5], out[10]};
                while (out[6].length() >= 1 && out[6].charAt(0) == '0') {
                    out[6] = out[6].substring(1);
                }
                JSONArray ret = IfpontoDB.this.sess.execute("Insert_evento", out, null, null);
                if (ret != null && ((JSONObject)ret.get(0)).containsKey((Object)"error") && ((JSONObject)ret.get(0)).get((Object)"error").toString().equals("0")) {
                    done = true;
                }
                if (!done) {
                    ret = IfpontoDB.this.sess.execute("Insert_evento_anonimo", out2, null, null);
                }
                if (ret != null && ((JSONObject)ret.get(0)).containsKey((Object)"error") && ((JSONObject)ret.get(0)).get((Object)"error").toString().equals("0")) {
                    done = true;
                }
                if (!done) {
                    return 0;
                }
                int last_nsr = Integer.parseInt(out[0]);
                if (last_nsr > count[0]) {
                    count[0] = last_nsr;
                }
                return 0;
            }
        };
        int nsr_default = this.getNsr(codigo);
        int[] count = new int[]{0, nsr_default};
        Util.jsonIter(offs, iter, null, count);
        String nsr = count[0] + "";
        int siin_nsr = this.getSiinNsr(codigo);
        if (count[0] < 1 && siin_nsr <= 0) {
            return;
        }
        if (siin_nsr > 0) {
            nsr = siin_nsr + "";
            values = new String[]{"0", codigo};
            this.sess.execute("Update_equipamento_siin_nsr", values, null, null);
        }
        values = new String[]{nsr, codigo};
        this.sess.execute("Update_equipamento_nsr", values, null, null);
    }

    public JSONArray insertEventLogin(String login, String pass, int nro) {
        String[] values = new String[]{login, pass, "" + nro};
        JSONArray ret = this.sess.execute("Insert_evento_login", values, null, null);
        if (ret == null || !((JSONObject)ret.get(0)).containsKey((Object)"error") || !((JSONObject)ret.get(0)).get((Object)"error").toString().equals("0")) {
            return null;
        }
        JSONArray event = this.sess.execute("Select_ultimo_evento", null, null, null);
        return event;
    }

    public JSONArray insertEventPIS(String pis, int nro) {
        String[] values = new String[]{pis, "" + nro};
        JSONArray ret = this.sess.execute("Insert_evento_pis", values, null, null);
        if (ret == null || !((JSONObject)ret.get(0)).containsKey((Object)"error") || !((JSONObject)ret.get(0)).get((Object)"error").toString().equals("0")) {
            return null;
        }
        JSONArray event = this.sess.execute("Select_ultimo_evento", null, null, null);
        return event;
    }

    public JSONArray getLastEvents(String nro, int limit) {
        String[] values = new String[]{nro, "" + limit};
        JSONArray res = this.sess.execute("Select_ultimos_eventos", values, null, null);
        return res;
    }

    public JSONArray getDevices() {
        IfaceJSONIter iter = new IfaceJSONIter(){

            @Override
            public int perform(JSONObject jdev, Object[] pars, int[] count) {
                JSONParser parser = new JSONParser();
                String status = jdev.get((Object)"status").toString();
                if (status.equals("")) {
                    JSONObject jstat = new JSONObject();
                    long unixtime = 0L;
                    jstat.put((Object)"unixtime", (Object)unixtime);
                    jstat.put((Object)"msg", (Object)"Sem comunica\u00e7\u00e3o.");
                    jstat.put((Object)"notificacoes", jstat.get((Object)"msg"));
                    status = jstat.toString();
                }
                try {
                    JSONObject jstatus = (JSONObject)parser.parse(status);
                    jdev.put((Object)"status", (Object)jstatus);
                }
                catch (ClassCastException cce) {
                    IfpontoDB.this.sendMessage(3, "Device status - JSONObject invalido: " + status);
                }
                catch (ParseException pe) {
                    IfpontoDB.this.sendMessage(3, "Device status - JSON invalido: " + status);
                }
                String conf = jdev.get((Object)"config").toString();
                if (conf.equals("")) {
                    return 0;
                }
                try {
                    JSONObject jconf = (JSONObject)parser.parse(conf);
                    for (Object key : jconf.keySet()) {
                        jdev.put(key, jconf.get(key));
                    }
                    jdev.remove((Object)"config");
                }
                catch (ClassCastException cce) {
                    IfpontoDB.this.sendMessage(3, "Device config - JSONObject invalido: " + conf);
                }
                catch (ParseException pe) {
                    IfpontoDB.this.sendMessage(3, "Device config - JSON invalido: " + conf);
                }
                return 0;
            }
        };
        JSONArray jdevs = this.sess.execute("Select_devices", null, null, null);
        if (jdevs == null) {
            return jdevs;
        }
        Util.jsonIter(jdevs, iter, null, null);
        return jdevs;
    }

    public JSONArray getDeviceByNro(int nro) {
        String[] values = new String[]{"" + nro};
        JSONArray res = this.sess.execute("Select_device_nro", values, null, null);
        return res;
    }

    public JSONArray getDeviceByCod(int codigo) {
        String[] values = new String[]{"" + codigo};
        JSONArray res = this.sess.execute("Select_device_cod", values, null, null);
        return res;
    }

    public JSONArray getDeviceUsers(String nro) {
        String[] values = new String[]{"" + nro};
        JSONArray res = this.sess.execute("Select_pessoas", values, null, null);
        return res;
    }

    public JSONArray getUserByName(String nome) {
        String[] values = new String[]{nome};
        JSONArray res = this.sess.execute("Select_pessoa_nome", values, null, null);
        return res;
    }

    public JSONArray getUserByPis(String pis) {
        String[] values = new String[]{pis};
        JSONArray res = this.sess.execute("Select_pessoa_pis", values, null, null);
        return res;
    }

    public JSONArray getBio(JSONArray jusers) {
        IfaceJSONIter iter = new IfaceJSONIter(){

            @Override
            public int perform(JSONObject user, Object[] pars, int[] count) {
                String pessoa_id = user.get((Object)"codigo").toString();
                count[0] = count[0] + 1;
                String[] values = new String[]{pessoa_id};
                JSONArray bios = IfpontoDB.this.sess.execute("Select_bios", values, null, null);
                user.put((Object)"templates", (Object)bios);
                return 0;
            }
        };
        int[] count = new int[]{0};
        Util.jsonIter(jusers, iter, null, count);
        return jusers;
    }

    public JSONArray getNotSyncResults(int nro, int limit) {
        if (limit > 200) {
            this.sendMessage(4, "Limite para a quantidade de offs ultrapassado. (" + limit + "/200)");
            return null;
        }
        String[] values = new String[]{"" + nro, "" + limit};
        JSONArray res = this.sess.execute("Select_no_sync_results", values, null, null);
        return res;
    }

    public int updateSyncResults(JSONArray results) {
        IfaceJSONIter iter = new IfaceJSONIter(){

            @Override
            public int perform(JSONObject res, Object[] pars, int[] count) {
                String codigo_ifponto = res.get((Object)"cod").toString();
                String[] values = new String[]{codigo_ifponto};
                JSONArray ret = IfpontoDB.this.sess.execute("Update_sync_result", values, null, null);
                if (ret == null || !((JSONObject)ret.get(0)).containsKey((Object)"error") || !((JSONObject)ret.get(0)).get((Object)"error").toString().equals("0")) {
                    return 0;
                }
                count[0] = count[0] + 1;
                return 0;
            }
        };
        int[] count = new int[]{0};
        Util.jsonIter(results, iter, null, count);
        return count[0];
    }

    public int rollbackSyncResults(JSONArray results) {
        IfaceJSONIter iter = new IfaceJSONIter(){

            @Override
            public int perform(JSONObject res, Object[] pars, int[] count) {
                String codigo_ifponto = res.get((Object)"cod").toString();
                String[] values = new String[]{codigo_ifponto};
                JSONArray ret = IfpontoDB.this.sess.execute("Update_rollback_result", values, null, null);
                if (ret == null || !((JSONObject)ret.get(0)).containsKey((Object)"error") || !((JSONObject)ret.get(0)).get((Object)"error").toString().equals("0")) {
                    return 0;
                }
                count[0] = count[0] + 1;
                return 0;
            }
        };
        int[] count = new int[]{0};
        Util.jsonIter(results, iter, null, count);
        return count[0];
    }

    public JSONArray getNotSyncEvents(int nro, int limit) {
        String[] values = new String[]{"" + nro, "" + limit};
        JSONArray res = this.sess.execute("Select_no_sync_events", values, null, null);
        return res;
    }

    public JSONArray getNotSyncEventsAfd(int nro, int limit) {
        String[] values = new String[]{"" + nro, "" + limit};
        JSONArray res = this.sess.execute("Select_no_sync_events_afd", values, null, null);
        return res;
    }

    public int updateSyncEvents(JSONArray events) {
        IfaceJSONIter iter = new IfaceJSONIter(){

            @Override
            public int perform(JSONObject event, Object[] pars, int[] count) {
                String evento_id = event.get((Object)"evento_id").toString();
                String[] values = new String[]{evento_id};
                JSONArray ret = IfpontoDB.this.sess.execute("Update_sync_evento", values, null, null);
                if (ret == null || !((JSONObject)ret.get(0)).containsKey((Object)"error") || !((JSONObject)ret.get(0)).get((Object)"error").toString().equals("0")) {
                    return 0;
                }
                count[0] = count[0] + 1;
                return 0;
            }
        };
        int[] count = new int[]{0};
        Util.jsonIter(events, iter, null, count);
        return count[0];
    }

    public int rollbackSyncEvents(JSONArray events) {
        IfaceJSONIter iter = new IfaceJSONIter(){

            @Override
            public int perform(JSONObject event, Object[] pars, int[] count) {
                String evento_id = event.get((Object)"evento_id").toString();
                count[0] = count[0] + 1;
                String[] values = new String[]{evento_id};
                IfpontoDB.this.sess.execute("Update_rollback_evento", values, null, null);
                return 0;
            }
        };
        int[] count = new int[]{0};
        Util.jsonIter(events, iter, null, count);
        return count[0];
    }

    public JSONArray getNotSyncBios(int limit) {
        IfaceJSONIter iter = new IfaceJSONIter(){

            @Override
            public int perform(JSONObject user, Object[] pars, int[] count) {
                JSONObject template = new JSONObject();
                JSONArray templates = new JSONArray();
                template.put((Object)"template", (Object)user.get((Object)"template").toString());
                template.put((Object)"vendor", (Object)user.get((Object)"vendor").toString());
                template.put((Object)"encode", (Object)user.get((Object)"encode").toString());
                template.put((Object)"bio_id", (Object)user.get((Object)"bio_id").toString());
                templates.add((Object)template);
                user.remove((Object)"template");
                user.remove((Object)"vendor");
                user.remove((Object)"encode");
                user.remove((Object)"bio_id");
                user.put((Object)"templates", (Object)templates);
                return 0;
            }
        };
        String[] values = new String[]{"" + limit};
        JSONArray list = this.sess.execute("Select_no_sync_bios", values, null, null);
        Util.jsonIter(list, iter, null, null);
        return list;
    }

    public int updateSyncBios(JSONArray templates) {
        final IfaceJSONIter iterTemps = new IfaceJSONIter(){

            @Override
            public int perform(JSONObject temp, Object[] pars, int[] count) {
                String bio_id = temp.get((Object)"bio_id").toString();
                String[] values = new String[]{bio_id};
                JSONArray ret = IfpontoDB.this.sess.execute("Update_sync_bio", values, null, null);
                if (ret == null || !((JSONObject)ret.get(0)).containsKey((Object)"error") || !((JSONObject)ret.get(0)).get((Object)"error").toString().equals("0")) {
                    return 0;
                }
                count[0] = count[0] + 1;
                return 0;
            }
        };
        IfaceJSONIter iter = new IfaceJSONIter(){

            @Override
            public int perform(JSONObject template, Object[] pars, int[] count) {
                JSONArray temps = (JSONArray)template.get((Object)"templates");
                Util.jsonIter(temps, iterTemps, null, count);
                return 0;
            }
        };
        int[] count = new int[]{0};
        Util.jsonIter(templates, iter, null, count);
        return count[0];
    }

    public JSONArray getProcessingUsers(String codigo_ifponto_device) {
        String[] vals = new String[]{codigo_ifponto_device};
        JSONArray list = this.sess.execute("Select_pendentes_processando", vals, null, null);
        return list;
    }

    public JSONArray getPendingUsers(String codigo_ifponto_device) {
        this.sendMessage(4, "entra get Pendentes.");
        IfaceJSONIter iter = new IfaceJSONIter(){

            @Override
            public int perform(JSONObject user, Object[] pars, int[] count) {
                String codigo_ifponto = user.get((Object)"cod").toString();
                String pessoa_id = user.get((Object)"pessoa_id").toString();
                String[] values = new String[]{pessoa_id};
                JSONArray cards = IfpontoDB.this.sess.execute("Select_cartoes", values, null, null);
                user.put((Object)"nro_cartao", (Object)cards);
                JSONArray bios = IfpontoDB.this.sess.execute("Select_bios", values, null, null);
                user.put((Object)"templates", (Object)bios);
                String situacao = "2";
                String sincronizado = "0";
                String descricao = "";
                values = new String[]{situacao, sincronizado, descricao, codigo_ifponto};
                IfpontoDB.this.sess.execute("Update_pendentes", values, null, null);
                return 0;
            }
        };
        String[] vals = new String[]{codigo_ifponto_device};
        JSONArray list = this.sess.execute("Select_pendentes", vals, null, null);
        Util.jsonIter(list, iter, null, null);
        return list;
    }

    public int updatePendingUsers(String codigo, JSONArray result) {
        this.sendMessage(4, "entra update Pendentes.");
        IfaceJSONIter iter = new IfaceJSONIter(){

            @Override
            public int perform(JSONObject user, Object[] pars, int[] count) {
                String[] defaults = new String[]{"status", "", "cod", "0", "cod_error", "0"};
                Util.fillObject(user, defaults);
                String codigo_ifponto = user.get((Object)"cod").toString();
                String[] values = new String[]{codigo_ifponto};
                JSONArray jdesc = IfpontoDB.this.sess.execute("Select_descricao_pendente", values, null, null);
                String desc = "";
                if (jdesc.size() > 0) {
                    desc = ((JSONObject)jdesc.get(0)).get((Object)"descricao").toString();
                }
                if (!desc.isEmpty()) {
                    desc = desc + " | ";
                }
                String situacao = "3";
                String sincronizado = "0";
                String descricao = desc + user.get((Object)"status").toString();
                String cod_error = user.get((Object)"cod_error").toString();
                if (!cod_error.equals("0")) {
                    situacao = "4";
                }
                String[] values2 = new String[]{situacao, sincronizado, descricao, codigo_ifponto};
                IfpontoDB.this.sendMessage(4, "Antes update Pendentes.");
                IfpontoDB.this.sess.execute("Update_pendentes", values2, null, null);
                IfpontoDB.this.sendMessage(4, "P\u00f3s update Pendentes.");
                return 0;
            }
        };
        Util.jsonIter(result, iter, null, null);
        return 0;
    }

    public int rollbackPendingUsers(JSONArray list) {
        IfaceJSONIter iter = new IfaceJSONIter(){

            @Override
            public int perform(JSONObject user, Object[] pars, int[] count) {
                String codigo_ifponto = user.get((Object)"cod").toString();
                count[0] = count[0] + 1;
                String situacao = "1";
                String sincronizado = "0";
                String erro = "";
                String[] values = new String[]{situacao, sincronizado, erro, codigo_ifponto};
                IfpontoDB.this.sess.execute("Update_pendentes", values, null, null);
                return 0;
            }
        };
        int[] count = new int[]{0};
        Util.jsonIter(list, iter, null, count);
        return count[0];
    }

    public int updateBio(JSONObject user, boolean sync) {
        JSONArray temps = (JSONArray)user.get((Object)"templates");
        if (temps == null) {
            return 0;
        }
        IfaceJSONIter iter = new IfaceJSONIter(){

            @Override
            public int perform(JSONObject temp, Object[] pars, int[] count) {
                String codigo_pessoa = (String)pars[1];
                String sincronizado = (String)pars[2];
                count[0] = count[0] + 1;
                String[] defaults = new String[]{"vendor", "unknown", "encode", "b64", "sincronizado", sincronizado};
                Util.fillObject(temp, defaults);
                String[] keys = new String[]{"sincronizado", "template", "vendor", "encode", null};
                String[] values = new String[]{codigo_pessoa};
                String[] out = Util.fillStringArray(temp, keys, values);
                if (out != null) {
                    IfpontoDB.this.sess.execute("Insert_bio", out, null, null);
                }
                return 0;
            }
        };
        String codigo_ifponto = user.get((Object)"codigo").toString();
        if (temps.size() > 0) {
            this.sess.execute("Delete_bio", new String[]{codigo_ifponto}, null, null);
        }
        int[] count = new int[]{0};
        String sincronizado = "0";
        if (sync) {
            sincronizado = "1";
        }
        Util.jsonIter(temps, iter, new Object[]{null, codigo_ifponto, sincronizado}, count);
        return count[0];
    }

    public int updateCartoes(JSONObject user) {
        JSONArray cards = (JSONArray)user.get((Object)"nro_cartao");
        if (cards == null) {
            return 0;
        }
        IfaceJSONIter iter = new IfaceJSONIter(){

            @Override
            public int perform(JSONObject card, Object[] pars, int[] count) {
                String codigo_pessoa = (String)pars[1];
                if (card.containsKey((Object)"devolucao") && card.get((Object)"devolucao").equals("t") && card.containsKey((Object)"nro")) {
                    IfpontoDB.this.sess.execute("Delete_cartao", new String[]{card.get((Object)"nro").toString()}, null, null);
                    return 0;
                }
                count[0] = count[0] + 1;
                String[] defaults = new String[]{"tipo", "Funcion\u00e1rio", "tecnologia", "Proximidade", "hrinicio", "", "hrfim", "", "liberador", "0", "ativo", "1"};
                Util.fillObject(card, defaults);
                String[] uKeys = new String[]{"tipo", "tecnologia", "hrinicio", "hrfim", "liberador", "ativo", "nro"};
                String[] iKeys = new String[]{"nro", "tipo", "tecnologia", "hrinicio", "hrfim", "liberador", "ativo", null};
                String[] values = new String[]{codigo_pessoa};
                String[] uFields = Util.fillStringArray(card, uKeys, null);
                String[] iFields = Util.fillStringArray(card, iKeys, values);
                if (uFields != null && iFields != null) {
                    IfpontoDB.this.sess.execute("Update_cartao", uFields, "Insert_cartao", iFields);
                }
                return 0;
            }
        };
        int[] count = new int[]{0};
        String codigo_ifponto = user.get((Object)"codigo").toString();
        Util.jsonIter(cards, iter, new Object[]{null, codigo_ifponto}, count);
        return count[0];
    }

    public int updateUserList(JSONObject dev) {
        JSONArray users = (JSONArray)dev.get((Object)"pessoas");
        if (users == null) {
            return 0;
        }
        IfaceJSONIter iter = new IfaceJSONIter(){

            @Override
            public int perform(JSONObject user, Object[] pars, int[] count) {
                String codigo_equipamento = (String)pars[1];
                count[0] = count[0] + 1;
                String[] defaults = new String[]{"verificar_biometria", "1"};
                Util.fillObject(user, defaults);
                String id_ifponto_key = Device.getID(user);
                String pis_key = "pis";
                if (!user.containsKey((Object)"pis")) {
                    pis_key = id_ifponto_key;
                }
                String[] uKeys = new String[]{"nome", pis_key, id_ifponto_key, "verificar_biometria", "codigo"};
                String[] uFields = Util.fillStringArray(user, uKeys, null);
                String[] iKeys = new String[]{"codigo", "nome", pis_key, id_ifponto_key, "verificar_biometria"};
                String[] iFields = Util.fillStringArray(user, iKeys, null);
                if (uFields == null || iFields == null) {
                    return 0;
                }
                while (uFields[1].length() >= 1 && uFields[1].charAt(0) == '0') {
                    uFields[1] = uFields[1].substring(1);
                }
                while (iFields[2].length() >= 1 && iFields[2].charAt(0) == '0') {
                    iFields[2] = iFields[2].substring(1);
                }
                IfpontoDB.this.sess.execute("Update_pessoa", uFields, "Insert_pessoa", iFields);
                defaults = new String[]{"cod", "0", "codigo", "0", "tipo", "incluir"};
                Util.fillObject(user, defaults);
                String operacao = user.get((Object)"tipo").toString();
                uFields = new String[]{user.get((Object)"cod").toString(), operacao, codigo_equipamento, user.get((Object)"codigo").toString()};
                iFields = new String[]{user.get((Object)"cod").toString(), operacao, codigo_equipamento, user.get((Object)"codigo").toString()};
                JSONArray ret = IfpontoDB.this.sess.execute("Update_pessoa_equipamento", uFields, "Insert_pessoa_equipamento", iFields);
                if (ret == null || !((JSONObject)ret.get(0)).containsKey((Object)"error") || !((JSONObject)ret.get(0)).get((Object)"error").toString().equals("0")) {
                    return 0;
                }
                IfpontoDB.this.updateCartoes(user);
                IfpontoDB.this.updateBio(user, true);
                return 0;
            }
        };
        int[] count = new int[]{0};
        String codigo_ifponto = dev.get((Object)"codigo").toString();
        Util.jsonIter(users, iter, new Object[]{null, codigo_ifponto}, count);
        return count[0];
    }

    public int updateUserList(JSONArray jpessoas, int codigo_ifponto_device) {
        JSONObject dev = new JSONObject();
        dev.put((Object)"pessoas", (Object)jpessoas);
        dev.put((Object)"codigo", (Object)codigo_ifponto_device);
        int r = this.updateUserList(dev);
        return r;
    }

    public int updateDevices(JSONArray devs) {
        IfaceJSONIter iter = new IfaceJSONIter(){

            @Override
            public int perform(JSONObject dev, Object[] pars, int[] count) {
                String[] defaults = new String[]{"user", "", "pass", "", "json_config", "", "diferenca_horario", "0"};
                Util.fillObject(dev, defaults);
                String[] uKeys = new String[]{"modelo", "nome", "ip", "porta", "user", "pass", "json_config", "diferenca_horario", "codigo"};
                String[] uFields = Util.fillStringArray(dev, uKeys, null);
                String[] iKeys = new String[]{"codigo", "nro", "modelo", "nome", "ip", "porta", "user", "pass", "json_config"};
                String[] iFields = Util.fillStringArray(dev, iKeys, null);
                if (iFields == null || uFields == null) {
                    return 0;
                }
                JSONArray ret = IfpontoDB.this.sess.execute("Update_equipamento", uFields, "Insert_equipamento", iFields);
                if (ret == null || !((JSONObject)ret.get(0)).containsKey((Object)"error") || !((JSONObject)ret.get(0)).get((Object)"error").toString().equals("0")) {
                    return 0;
                }
                if (dev.containsKey((Object)"nsr_modificar") && dev.get((Object)"nsr_modificar") != null) {
                    String[] values = new String[]{dev.get((Object)"nsr_modificar").toString(), iFields[0]};
                    IfpontoDB.this.sess.execute("Update_equipamento_siin_nsr", values, null, null);
                }
                count[0] = count[0] + 1;
                if (dev.containsKey((Object)"pessoas")) {
                    IfpontoDB.this.updateUserList(dev);
                }
                return 0;
            }
        };
        int[] count = new int[]{0};
        Util.jsonIter(devs, iter, new Object[0], count);
        return count[0];
    }

    public boolean disableDevices() {
        JSONArray ret = this.sess.execute("Update_inativa_equipamentos", null, null, null);
        return ret != null && ret.size() >= 1 && ((JSONObject)ret.get(0)).containsKey((Object)"error") && ((JSONObject)ret.get(0)).get((Object)"error").toString().equals("0");
    }

    public IfpontoDB clone() {
        try {
            IfpontoDB db = (IfpontoDB)super.clone();
            db.sess = null;
            return db;
        }
        catch (CloneNotSupportedException cnse) {
            cnse.printStackTrace();
            return null;
        }
    }

    public static final void main(String[] args) throws IOException {
        Method[] meths = IfpontoDB.class.getMethods();
        if (args.length < 2) {
            System.err.println("iFractal - DB Test");
            System.err.println("\nUso:");
            System.err.println("\tshell$ java com.ifractal.ifponto.IfpontoDB <SQLITE> <METHOD> <TYPE> <VALUE> ... <TYPE N> <VALUE N>");
            System.err.println("\nOnde <CMD>:");
            for (Method m : meths) {
                String nm = m.getName();
                if (!nm.startsWith("get") && !nm.startsWith("insert") && !nm.startsWith("disable") && !nm.startsWith("update") && !nm.startsWith("roll")) continue;
                System.err.print("\t" + nm + "(");
                Type[] tps = m.getGenericParameterTypes();
                for (int k = 0; k < tps.length; ++k) {
                    if (k > 0) {
                        System.err.print(", ");
                    }
                    System.err.print(tps[k].toString());
                }
                System.err.println(")");
            }
            System.err.println("\nExemplos:");
            System.err.println("\tshell$ java com.ifractal.ifponto.Ifponto - getDevices");
            System.err.println("\tshell$ java com.ifractal.ifponto.Ifponto - updateDevices JSONArray list.json");
            System.err.println("\tshell$ java com.ifractal.ifponto.Ifponto - getDeviceByNro int 10");
            System.err.println();
            System.exit(1);
        }
        Observer obs = new Observer(){

            @Override
            public void onMessage(Producer prod, int level, String msg, int code) {
                System.out.println(prod.getClass() + "|" + code + "|" + msg);
            }

            @Override
            public void onMessage(Producer prod, int verbosityLevel, String msg) {
                this.onMessage(prod, verbosityLevel, msg, 0);
            }
        };
        String dbfile = "./conf/ifponto.db";
        if (!args[0].equals("-")) {
            dbfile = args[0];
        }
        String cmd = args[1];
        int k = 2;
        while (k + 1 < args.length) {
            if (args[k].startsWith("JSON")) {
                args[k + 1] = new String(Files.readAllBytes(Paths.get(args[k + 1], new String[0])));
            }
            ++k;
        }
        IfpontoDB idb = new IfpontoDB(null, null);
        idb.init(new String[]{"DB", dbfile}, null);
        if (!idb.open(obs)) {
            System.err.println("Falha ao tentar inicializar banco de dados: " + dbfile);
            return;
        }
        args[0] = "method";
        String ret = null;
        try {
            ret = idb.callStringMethod(args);
        }
        catch (NoSuchMethodException nsme) {
            System.err.println(nsme.getMessage());
        }
        idb.close();
        if (ret == null) {
            System.err.println("Retorna void ou Falha ao tentar executar: " + cmd);
        } else {
            System.out.println(ret);
        }
    }

    private class SQLChange {
        public final int version;
        public final String[] changes;

        public SQLChange(int v, String[] c) {
            this.version = v;
            this.changes = c;
        }
    }
}

