/*
 * Decompiled with CFR 0.152.
 */
package com.ifractal.desktop;

import com.ifractal.desktop.Scanner;
import com.ifractal.desktop.ScannerListener;
import com.ifractal.desktop.ScannerPanel;
import com.ifractal.utils.Producer;
import com.ifractal.utils.Util;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;

public class ScannerUI
extends JFrame
implements ScannerListener<ScannerPanel>,
ActionListener {
    JComboBox<String[]> comboScanner;
    JButton bttest;
    JButton btenroll;
    JButton btver;
    Scanner<ScannerPanel> scanner = null;
    ScannerPanel sPanel = new ScannerPanel();
    byte[] template = null;

    @Override
    public int onTemplate(Scanner<ScannerPanel> scan, String vendor, String id, byte[] templ, byte quality, ScannerPanel panel) {
        this.template = templ;
        panel.updateMessage(id + "  -  Quality: " + quality);
        this.btver.setEnabled(true);
        return 0;
    }

    @Override
    public int onImage(Scanner<ScannerPanel> scan, byte[] imageBuf, int width, int height, ScannerPanel panel) {
        if (imageBuf == null) {
            return 0;
        }
        BufferedImage image = new BufferedImage(width, height, 10);
        byte[] pixels = ((DataBufferByte)image.getRaster().getDataBuffer()).getData();
        for (int i = 0; i < pixels.length; ++i) {
            pixels[i] = imageBuf[i];
        }
        panel.updateImage(image, width, height);
        return 0;
    }

    @Override
    public int onMessage(Scanner<ScannerPanel> scan, String msg, ScannerPanel panel) {
        System.err.println(msg);
        panel.updateMessage(msg);
        return 0;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int r = 0;
        byte[] quality = new byte[1];
        String[] item = (String[])this.comboScanner.getSelectedItem();
        this.openScanner(item);
        if (e.getSource() == this.bttest) {
            r = this.scanner.captureImage(10, this.sPanel);
        } else if (e.getSource() == this.btenroll) {
            r = this.scanner.enroll(3, "test", quality, this.sPanel);
        } else if (e.getSource() == this.btver) {
            r = this.scanner.verify(this.template, this.sPanel);
            this.sPanel.updateMessage(Scanner.getErrorMessage(r));
        } else {
            System.err.println("sem a\u00e7\u00e3o...");
        }
        if (r != 0) {
            System.err.println("erro scanner: " + r);
        }
    }

    public void initScannerListbox() {
        ListCellRenderer<String[]> lcr = new ListCellRenderer<String[]>(){

            @Override
            public Component getListCellRendererComponent(JList<? extends String[]> lst, String[] value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel lbl = new JLabel(value[0]);
                return lbl;
            }
        };
        String[][] scanners = Scanner.getScanners();
        this.comboScanner = new JComboBox((E[])scanners);
        this.comboScanner.setRenderer(lcr);
    }

    public void open(String title) {
        this.setTitle(title);
        this.setDefaultCloseOperation(3);
        JPanel mainPanel = new JPanel();
        JPanel secPanel = new JPanel();
        BoxLayout bl = new BoxLayout(mainPanel, 1);
        BoxLayout bl2 = new BoxLayout(secPanel, 0);
        mainPanel.setLayout(bl);
        secPanel.setLayout(bl2);
        mainPanel.add(secPanel);
        mainPanel.add(this.sPanel);
        this.add(mainPanel);
        this.initScannerListbox();
        this.bttest = new JButton();
        this.bttest.add(new JLabel("Test"));
        this.bttest.addActionListener(this);
        this.btenroll = new JButton();
        this.btenroll.add(new JLabel("Enroll"));
        this.btenroll.addActionListener(this);
        this.btver = new JButton();
        this.btver.add(new JLabel("Verify"));
        this.btver.addActionListener(this);
        this.btver.setEnabled(false);
        secPanel.add(this.comboScanner);
        secPanel.add(this.bttest);
        secPanel.add(this.btenroll);
        secPanel.add(this.btver);
        this.setSize(new Dimension(500, 500));
        this.setLocationRelativeTo(null);
        this.pack();
        this.setVisible(true);
    }

    protected Scanner<ScannerPanel> openScanner(String[] s) {
        try {
            Object obj = Producer.newObject(null, new String[]{"class", s[1]});
            if (obj == null || !(obj instanceof Scanner)) {
                System.err.println("Falha ao tentar instanciar: " + s[1]);
                return null;
            }
            this.scanner = (Scanner)obj;
        }
        catch (ClassCastException e) {
            System.err.println(e.getMessage());
            return null;
        }
        this.scanner.setListener(this);
        String[] devs = this.scanner.enumerate(s[2]);
        if (devs == null) {
            System.err.println("Falha enumerate");
            return null;
        }
        int r = this.scanner.init(0);
        if (r != 0) {
            System.err.println("Falha init");
            return null;
        }
        String[] info = this.scanner.getInfo();
        if (info == null) {
            System.err.println("Falha getInfo");
            return null;
        }
        int i = 0;
        while (i + 1 < info.length) {
            System.out.println(info[i] + ": " + info[i + 1]);
            i += 2;
        }
        int width = Util.getIntFromArgs(info, "width");
        int height = Util.getIntFromArgs(info, "height");
        this.sPanel.setPreferredSize(new Dimension(width, height));
        return null;
    }

    public static final void main(String[] args) throws InterruptedException {
        if (args.length < 1) {
            System.err.println("Uso:");
            System.err.println("\t$ java Scanner class <CLASS> <PARAMS> ...\n");
            System.err.println("Exemplo:");
            System.err.println("\t$ java Scanner class com.ifractal.desktop.ScannerNative vendor dummy verbosity 5\n");
            System.exit(1);
        }
        ScannerUI ui = new ScannerUI();
        ui.open("Teste Scanner");
    }
}

