/*
 * Decompiled with CFR 0.152.
 */
package com.machinezoo.sourceafis;

import com.machinezoo.sourceafis.BooleanMatrix;
import com.machinezoo.sourceafis.DoubleAngle;
import com.machinezoo.sourceafis.FingerprintTransparency;
import com.machinezoo.sourceafis.IntPoint;
import com.machinezoo.sourceafis.Integers;
import com.machinezoo.sourceafis.Parameters;
import com.machinezoo.sourceafis.SkeletonMinutia;
import com.machinezoo.sourceafis.SkeletonRidge;
import com.machinezoo.sourceafis.SkeletonType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;

class Skeleton {
    final SkeletonType type;
    final IntPoint size;
    final List<SkeletonMinutia> minutiae = new ArrayList<SkeletonMinutia>();

    Skeleton(BooleanMatrix binary, SkeletonType type) {
        this.type = type;
        FingerprintTransparency.current().log(type.prefix + "binarized-skeleton", binary);
        this.size = binary.size();
        BooleanMatrix thinned = this.thin(binary);
        List<IntPoint> minutiaPoints = this.findMinutiae(thinned);
        Map<IntPoint, List<IntPoint>> linking = Skeleton.linkNeighboringMinutiae(minutiaPoints);
        Map<IntPoint, SkeletonMinutia> minutiaMap = this.minutiaCenters(linking);
        this.traceRidges(thinned, minutiaMap);
        this.fixLinkingGaps();
        FingerprintTransparency.current().logSkeleton("traced-skeleton", this);
        this.filter();
    }

    private BooleanMatrix thin(BooleanMatrix input) {
        NeighborhoodType[] neighborhoodTypes = Skeleton.neighborhoodTypes();
        BooleanMatrix partial = new BooleanMatrix(this.size);
        for (int y = 1; y < this.size.y - 1; ++y) {
            for (int x = 1; x < this.size.x - 1; ++x) {
                partial.set(x, y, input.get(x, y));
            }
        }
        BooleanMatrix thinned = new BooleanMatrix(this.size);
        boolean removedAnything = true;
        for (int i = 0; i < 26 && removedAnything; ++i) {
            removedAnything = false;
            for (int evenY = 0; evenY < 2; ++evenY) {
                for (int evenX = 0; evenX < 2; ++evenX) {
                    for (int y = 1 + evenY; y < this.size.y - 1; y += 2) {
                        for (int x = 1 + evenX; x < this.size.x - 1; x += 2) {
                            if (!partial.get(x, y) || thinned.get(x, y) || partial.get(x, y - 1) && partial.get(x, y + 1) && partial.get(x - 1, y) && partial.get(x + 1, y)) continue;
                            int neighbors = (partial.get(x + 1, y + 1) ? 128 : 0) | (partial.get(x, y + 1) ? 64 : 0) | (partial.get(x - 1, y + 1) ? 32 : 0) | (partial.get(x + 1, y) ? 16 : 0) | (partial.get(x - 1, y) ? 8 : 0) | (partial.get(x + 1, y - 1) ? 4 : 0) | (partial.get(x, y - 1) ? 2 : 0) | (partial.get(x - 1, y - 1) ? 1 : 0);
                            if (neighborhoodTypes[neighbors] == NeighborhoodType.REMOVABLE || neighborhoodTypes[neighbors] == NeighborhoodType.ENDING && Skeleton.isFalseEnding(partial, new IntPoint(x, y))) {
                                removedAnything = true;
                                partial.set(x, y, false);
                                continue;
                            }
                            thinned.set(x, y, true);
                        }
                    }
                }
            }
        }
        FingerprintTransparency.current().log(this.type.prefix + "thinned-skeleton", thinned);
        return thinned;
    }

    private static NeighborhoodType[] neighborhoodTypes() {
        NeighborhoodType[] types = new NeighborhoodType[256];
        for (int mask = 0; mask < 256; ++mask) {
            boolean end;
            boolean TL = (mask & 1) != 0;
            boolean TC = (mask & 2) != 0;
            boolean TR = (mask & 4) != 0;
            boolean CL = (mask & 8) != 0;
            boolean CR = (mask & 0x10) != 0;
            boolean BL = (mask & 0x20) != 0;
            boolean BC = (mask & 0x40) != 0;
            boolean BR = (mask & 0x80) != 0;
            int count = Integer.bitCount(mask);
            boolean diagonal = !TC && !CL && TL || !CL && !BC && BL || !BC && !CR && BR || !CR && !TC && TR;
            boolean horizontal = !(TC || BC || !TR && !CR && !BR || !TL && !CL && !BL);
            boolean vertical = !(CL || CR || !TL && !TC && !TR || !BL && !BC && !BR);
            boolean bl = end = count == 1;
            types[mask] = end ? NeighborhoodType.ENDING : (!diagonal && !horizontal && !vertical ? NeighborhoodType.REMOVABLE : NeighborhoodType.SKELETON);
        }
        return types;
    }

    private static boolean isFalseEnding(BooleanMatrix binary, IntPoint ending) {
        for (IntPoint relativeNeighbor : IntPoint.CORNER_NEIGHBORS) {
            IntPoint neighbor = ending.plus(relativeNeighbor);
            if (!binary.get(neighbor)) continue;
            int count = 0;
            for (IntPoint relative2 : IntPoint.CORNER_NEIGHBORS) {
                if (!binary.get(neighbor.plus(relative2), false)) continue;
                ++count;
            }
            return count > 2;
        }
        return false;
    }

    private List<IntPoint> findMinutiae(BooleanMatrix thinned) {
        ArrayList<IntPoint> result = new ArrayList<IntPoint>();
        for (IntPoint at : this.size) {
            if (!thinned.get(at)) continue;
            int count = 0;
            for (IntPoint relative : IntPoint.CORNER_NEIGHBORS) {
                if (!thinned.get(at.plus(relative), false)) continue;
                ++count;
            }
            if (count != 1 && count <= 2) continue;
            result.add(at);
        }
        return result;
    }

    private static Map<IntPoint, List<IntPoint>> linkNeighboringMinutiae(List<IntPoint> minutiae) {
        HashMap<IntPoint, List<IntPoint>> linking = new HashMap<IntPoint, List<IntPoint>>();
        for (IntPoint minutiaPos : minutiae) {
            List ownLinks = null;
            for (IntPoint neighborRelative : IntPoint.CORNER_NEIGHBORS) {
                List neighborLinks;
                IntPoint neighborPos = minutiaPos.plus(neighborRelative);
                if (!linking.containsKey(neighborPos) || (neighborLinks = (List)linking.get(neighborPos)) == ownLinks) continue;
                if (ownLinks != null) {
                    neighborLinks.addAll(ownLinks);
                    for (IntPoint mergedPos : ownLinks) {
                        linking.put(mergedPos, neighborLinks);
                    }
                }
                ownLinks = neighborLinks;
            }
            if (ownLinks == null) {
                ownLinks = new ArrayList<IntPoint>();
            }
            ownLinks.add(minutiaPos);
            linking.put(minutiaPos, ownLinks);
        }
        return linking;
    }

    private Map<IntPoint, SkeletonMinutia> minutiaCenters(Map<IntPoint, List<IntPoint>> linking) {
        HashMap<IntPoint, SkeletonMinutia> centers = new HashMap<IntPoint, SkeletonMinutia>();
        for (IntPoint currentPos : linking.keySet()) {
            List<IntPoint> linkedMinutiae = linking.get(currentPos);
            IntPoint primaryPos = linkedMinutiae.get(0);
            if (!centers.containsKey(primaryPos)) {
                IntPoint sum = IntPoint.ZERO;
                for (IntPoint linkedPos : linkedMinutiae) {
                    sum = sum.plus(linkedPos);
                }
                IntPoint center = new IntPoint(sum.x / linkedMinutiae.size(), sum.y / linkedMinutiae.size());
                SkeletonMinutia minutia = new SkeletonMinutia(center);
                this.addMinutia(minutia);
                centers.put(primaryPos, minutia);
            }
            centers.put(currentPos, (SkeletonMinutia)centers.get(primaryPos));
        }
        return centers;
    }

    private void traceRidges(BooleanMatrix thinned, Map<IntPoint, SkeletonMinutia> minutiaePoints) {
        HashMap<IntPoint, SkeletonRidge> leads = new HashMap<IntPoint, SkeletonRidge>();
        for (IntPoint minutiaPoint : minutiaePoints.keySet()) {
            for (IntPoint startRelative : IntPoint.CORNER_NEIGHBORS) {
                IntPoint start = minutiaPoint.plus(startRelative);
                if (!thinned.get(start, false) || minutiaePoints.containsKey(start) || leads.containsKey(start)) continue;
                SkeletonRidge ridge = new SkeletonRidge();
                ridge.points.add(minutiaPoint);
                ridge.points.add(start);
                IntPoint previous = minutiaPoint;
                IntPoint current = start;
                do {
                    IntPoint nextRelative;
                    IntPoint next = IntPoint.ZERO;
                    IntPoint[] intPointArray = IntPoint.CORNER_NEIGHBORS;
                    int n = intPointArray.length;
                    for (int i = 0; i < n && (!thinned.get(next = current.plus(nextRelative = intPointArray[i]), false) || next.equals(previous)); ++i) {
                    }
                    previous = current;
                    current = next;
                    ridge.points.add(current);
                } while (!minutiaePoints.containsKey(current));
                IntPoint end = current;
                ridge.start(minutiaePoints.get(minutiaPoint));
                ridge.end(minutiaePoints.get(end));
                leads.put(ridge.points.get(1), ridge);
                leads.put(ridge.reversed.points.get(1), ridge);
            }
        }
    }

    private void fixLinkingGaps() {
        for (SkeletonMinutia minutia : this.minutiae) {
            for (SkeletonRidge ridge : minutia.ridges) {
                if (ridge.points.get(0).equals(minutia.position)) continue;
                IntPoint[] filling = ridge.points.get(0).lineTo(minutia.position);
                for (int i = 1; i < filling.length; ++i) {
                    ridge.reversed.points.add(filling[i]);
                }
            }
        }
    }

    private void filter() {
        this.removeDots();
        FingerprintTransparency.current().logSkeleton("removed-dots", this);
        this.removePores();
        this.removeGaps();
        this.removeTails();
        this.removeFragments();
    }

    private void removeDots() {
        ArrayList<SkeletonMinutia> removed = new ArrayList<SkeletonMinutia>();
        for (SkeletonMinutia minutia : this.minutiae) {
            if (!minutia.ridges.isEmpty()) continue;
            removed.add(minutia);
        }
        for (SkeletonMinutia minutia : removed) {
            this.removeMinutia(minutia);
        }
    }

    private void removePores() {
        block0: for (SkeletonMinutia minutia : this.minutiae) {
            if (minutia.ridges.size() != 3) continue;
            for (int exit = 0; exit < 3; ++exit) {
                SkeletonRidge exitRidge = minutia.ridges.get(exit);
                SkeletonRidge arm1 = minutia.ridges.get((exit + 1) % 3);
                SkeletonRidge arm2 = minutia.ridges.get((exit + 2) % 3);
                if (arm1.end() != arm2.end() || exitRidge.end() == arm1.end() || arm1.end() == minutia || exitRidge.end() == minutia) continue;
                SkeletonMinutia end = arm1.end();
                if (end.ridges.size() != 3 || arm1.points.size() > 41 || arm2.points.size() > 41) continue block0;
                arm1.detach();
                arm2.detach();
                SkeletonRidge merged = new SkeletonRidge();
                merged.start(minutia);
                merged.end(end);
                for (IntPoint point : minutia.position.lineTo(end.position)) {
                    merged.points.add(point);
                }
                continue block0;
            }
        }
        this.removeKnots();
        FingerprintTransparency.current().logSkeleton("removed-pores", this);
    }

    private void removeGaps() {
        PriorityQueue<Gap> queue = new PriorityQueue<Gap>();
        for (SkeletonMinutia end1 : this.minutiae) {
            if (end1.ridges.size() != 1 || end1.ridges.get((int)0).points.size() < 7) continue;
            for (SkeletonMinutia end2 : this.minutiae) {
                if (end2 == end1 || end2.ridges.size() != 1 || end1.ridges.get(0).end() == end2 || end2.ridges.get((int)0).points.size() < 7 || !this.isWithinGapLimits(end1, end2)) continue;
                Gap gap = new Gap();
                gap.distance = end1.position.minus(end2.position).lengthSq();
                gap.end1 = end1;
                gap.end2 = end2;
                queue.add(gap);
            }
        }
        BooleanMatrix shadow = this.shadow();
        while (!queue.isEmpty()) {
            IntPoint[] line;
            Gap gap = (Gap)queue.remove();
            if (gap.end1.ridges.size() != 1 || gap.end2.ridges.size() != 1 || this.isRidgeOverlapping(line = gap.end1.position.lineTo(gap.end2.position), shadow)) continue;
            Skeleton.addGapRidge(shadow, gap, line);
        }
        this.removeKnots();
        FingerprintTransparency.current().logSkeleton("removed-gaps", this);
    }

    private boolean isWithinGapLimits(SkeletonMinutia end1, SkeletonMinutia end2) {
        int distanceSq = end1.position.minus(end2.position).lengthSq();
        if (distanceSq <= Integers.sq(5)) {
            return true;
        }
        if (distanceSq > Integers.sq(20)) {
            return false;
        }
        double gapDirection = DoubleAngle.atan(end1.position, end2.position);
        double direction1 = DoubleAngle.atan(end1.position, this.angleSampleForGapRemoval(end1));
        if (DoubleAngle.distance(direction1, DoubleAngle.opposite(gapDirection)) > Parameters.MAX_GAP_ANGLE) {
            return false;
        }
        double direction2 = DoubleAngle.atan(end2.position, this.angleSampleForGapRemoval(end2));
        return !(DoubleAngle.distance(direction2, gapDirection) > Parameters.MAX_GAP_ANGLE);
    }

    private IntPoint angleSampleForGapRemoval(SkeletonMinutia minutia) {
        SkeletonRidge ridge = minutia.ridges.get(0);
        if (22 < ridge.points.size()) {
            return ridge.points.get(22);
        }
        return ridge.end().position;
    }

    private boolean isRidgeOverlapping(IntPoint[] line, BooleanMatrix shadow) {
        for (int i = 2; i < line.length - 2; ++i) {
            if (!shadow.get(line[i])) continue;
            return true;
        }
        return false;
    }

    private static void addGapRidge(BooleanMatrix shadow, Gap gap, IntPoint[] line) {
        SkeletonRidge ridge = new SkeletonRidge();
        for (IntPoint point : line) {
            ridge.points.add(point);
        }
        ridge.start(gap.end1);
        ridge.end(gap.end2);
        for (IntPoint point : line) {
            shadow.set(point, true);
        }
    }

    private void removeTails() {
        for (SkeletonMinutia minutia : this.minutiae) {
            if (minutia.ridges.size() != 1 || minutia.ridges.get((int)0).end().ridges.size() < 3 || minutia.ridges.get((int)0).points.size() >= 21) continue;
            minutia.ridges.get(0).detach();
        }
        this.removeDots();
        this.removeKnots();
        FingerprintTransparency.current().logSkeleton("removed-tails", this);
    }

    private void removeFragments() {
        for (SkeletonMinutia minutia : this.minutiae) {
            if (minutia.ridges.size() != 1) continue;
            SkeletonRidge ridge = minutia.ridges.get(0);
            if (ridge.end().ridges.size() != 1 || ridge.points.size() >= 22) continue;
            ridge.detach();
        }
        this.removeDots();
        FingerprintTransparency.current().logSkeleton("removed-fragments", this);
    }

    private void removeKnots() {
        for (SkeletonMinutia minutia : this.minutiae) {
            if (minutia.ridges.size() != 2 || minutia.ridges.get((int)0).reversed == minutia.ridges.get(1)) continue;
            SkeletonRidge extended = minutia.ridges.get((int)0).reversed;
            SkeletonRidge removed = minutia.ridges.get(1);
            if (extended.points.size() < removed.points.size()) {
                SkeletonRidge tmp = extended;
                extended = removed;
                removed = tmp;
                extended = extended.reversed;
                removed = removed.reversed;
            }
            extended.points.remove(extended.points.size() - 1);
            for (IntPoint point : removed.points) {
                extended.points.add(point);
            }
            extended.end(removed.end());
            removed.detach();
        }
        this.removeDots();
    }

    private void addMinutia(SkeletonMinutia minutia) {
        this.minutiae.add(minutia);
    }

    private void removeMinutia(SkeletonMinutia minutia) {
        this.minutiae.remove(minutia);
    }

    private BooleanMatrix shadow() {
        BooleanMatrix shadow = new BooleanMatrix(this.size);
        for (SkeletonMinutia minutia : this.minutiae) {
            shadow.set(minutia.position, true);
            for (SkeletonRidge ridge : minutia.ridges) {
                if (ridge.start().position.y > ridge.end().position.y) continue;
                for (IntPoint point : ridge.points) {
                    shadow.set(point, true);
                }
            }
        }
        return shadow;
    }

    private static class Gap
    implements Comparable<Gap> {
        int distance;
        SkeletonMinutia end1;
        SkeletonMinutia end2;

        private Gap() {
        }

        @Override
        public int compareTo(Gap other) {
            return Integer.compare(this.distance, other.distance);
        }
    }

    private static enum NeighborhoodType {
        SKELETON,
        ENDING,
        REMOVABLE;

    }
}

