/*
 * Decompiled with CFR 0.152.
 */
package com.machinezoo.sourceafis;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Objects;

class ReversedList<T>
implements List<T> {
    private final List<T> inner;

    ReversedList(List<T> inner) {
        this.inner = inner;
    }

    @Override
    public boolean add(T item) {
        this.inner.add(0, item);
        return true;
    }

    @Override
    public void add(int index, T item) {
        this.inner.add(this.size() - index, item);
    }

    @Override
    public boolean addAll(Collection<? extends T> collection) {
        return this.inner.addAll(0, new ReversedList<T>(new ArrayList<T>(collection)));
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> collection) {
        return this.inner.addAll(this.size() - index, new ReversedList<T>(new ArrayList<T>(collection)));
    }

    @Override
    public void clear() {
        this.inner.clear();
    }

    @Override
    public boolean contains(Object item) {
        return this.inner.contains(item);
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        return this.inner.containsAll(collection);
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof List)) {
            return false;
        }
        List other = (List)obj;
        if (this.size() != other.size()) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            if (Objects.equals(this.get(i), other.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public T get(int index) {
        return this.inner.get(this.size() - index - 1);
    }

    @Override
    public int hashCode() {
        return this.inner.hashCode();
    }

    @Override
    public int indexOf(Object item) {
        int index = this.inner.lastIndexOf(item);
        return index >= 0 ? this.size() - index - 1 : -1;
    }

    @Override
    public boolean isEmpty() {
        return this.inner.isEmpty();
    }

    @Override
    public Iterator<T> iterator() {
        return new ReversedIterator();
    }

    @Override
    public int lastIndexOf(Object item) {
        int index = this.inner.indexOf(item);
        return index >= 0 ? this.size() - index - 1 : -1;
    }

    @Override
    public ListIterator<T> listIterator() {
        return new ReversedIterator();
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        if (index < 0 || index > this.size()) {
            throw new IndexOutOfBoundsException();
        }
        ReversedIterator iterator = new ReversedIterator();
        iterator.index = index;
        return iterator;
    }

    @Override
    public T remove(int index) {
        return this.inner.remove(this.size() - index - 1);
    }

    @Override
    public boolean remove(Object item) {
        int index = this.indexOf(item);
        if (index >= 0) {
            this.remove(index);
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        return this.inner.removeAll(collection);
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        return this.inner.retainAll(collection);
    }

    @Override
    public T set(int index, T item) {
        return this.inner.set(this.size() - index - 1, item);
    }

    @Override
    public int size() {
        return this.inner.size();
    }

    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        return new ReversedList<T>(this.inner.subList(this.size() - toIndex, this.size() - fromIndex));
    }

    @Override
    public Object[] toArray() {
        Object[] array = new Object[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            array[i] = this.get(i);
        }
        return array;
    }

    @Override
    public <U> U[] toArray(U[] array) {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("[");
        for (int i = 0; i < this.size(); ++i) {
            if (i > 0) {
                s.append(", ");
            }
            s.append(Objects.toString(this.get(i)));
        }
        s.append("]");
        return s.toString();
    }

    private class ReversedIterator
    implements ListIterator<T> {
        int index = 0;

        private ReversedIterator() {
        }

        @Override
        public void add(T e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            return this.index < ReversedList.this.size();
        }

        @Override
        public T next() {
            if (this.index >= ReversedList.this.size()) {
                throw new NoSuchElementException();
            }
            ++this.index;
            return ReversedList.this.get(this.index - 1);
        }

        @Override
        public int nextIndex() {
            return this.index;
        }

        @Override
        public boolean hasPrevious() {
            return this.index > 0;
        }

        @Override
        public T previous() {
            if (this.index <= 0) {
                throw new NoSuchElementException();
            }
            --this.index;
            return ReversedList.this.get(this.index);
        }

        @Override
        public int previousIndex() {
            return this.index - 1;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(T e) {
            throw new UnsupportedOperationException();
        }
    }
}

