/*
 * Decompiled with CFR 0.152.
 */
package com.machinezoo.sourceafis;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.cbor.CBORFactory;
import com.google.gson.Gson;
import com.machinezoo.noexception.Exceptions;
import com.machinezoo.sourceafis.FeatureExtractor;
import com.machinezoo.sourceafis.FingerprintCompatibility;
import com.machinezoo.sourceafis.FingerprintImage;
import com.machinezoo.sourceafis.FingerprintTransparency;
import com.machinezoo.sourceafis.ImmutableTemplate;
import com.machinezoo.sourceafis.PersistentTemplate;
import com.machinezoo.sourceafis.PlatformCheck;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FingerprintTemplate {
    volatile ImmutableTemplate immutable = ImmutableTemplate.EMPTY;
    private static final Logger logger;
    private static final ObjectMapper mapper;
    private static final FingerprintTemplate EMPTY;
    private double dpi = 500.0;

    public FingerprintTemplate(FingerprintImage image) {
        Objects.requireNonNull(image);
        Objects.requireNonNull(image.matrix);
        this.immutable = new ImmutableTemplate(FeatureExtractor.extract(image.matrix, image.dpi));
    }

    public FingerprintTemplate(byte[] serialized) {
        this(serialized, true);
    }

    FingerprintTemplate(byte[] serialized, boolean foreignToo) {
        try {
            Objects.requireNonNull(serialized);
            PersistentTemplate persistent = (PersistentTemplate)mapper.readValue(serialized, PersistentTemplate.class);
            persistent.validate();
            this.immutable = new ImmutableTemplate(persistent.mutable());
        }
        catch (Throwable ex) {
            if (!foreignToo) {
                throw new IllegalArgumentException("This is not a valid SourceAFIS template.", ex);
            }
            try {
                FingerprintTemplate converted = FingerprintCompatibility.convert(serialized);
                this.immutable = converted.immutable;
                logger.warn("Template in foreign format was passed to FingerprintTemplate constructor. It was accepted, but FingerprintCompatibility.convert() should be used instead.");
            }
            catch (Throwable ex2) {
                throw new IllegalArgumentException("This is neither a valid SourceAFIS template nor any supported foreign template format.", ex);
            }
        }
    }

    @Deprecated
    public FingerprintTemplate() {
    }

    public static FingerprintTemplate empty() {
        return EMPTY;
    }

    FingerprintTemplate(ImmutableTemplate immutable) {
        this.immutable = immutable;
    }

    @Deprecated
    public FingerprintTemplate transparency(FingerprintTransparency transparency) {
        return this;
    }

    @Deprecated
    public FingerprintTemplate dpi(double dpi) {
        this.dpi = dpi;
        return this;
    }

    @Deprecated
    public FingerprintTemplate create(byte[] image) {
        this.immutable = new ImmutableTemplate(FeatureExtractor.extract(new FingerprintImage().decode((byte[])image).matrix, this.dpi));
        return this;
    }

    @Deprecated
    public FingerprintTemplate deserialize(String json) {
        Objects.requireNonNull(json);
        PersistentTemplate persistent = (PersistentTemplate)new Gson().fromJson(json, PersistentTemplate.class);
        persistent.validate();
        this.immutable = new ImmutableTemplate(persistent.mutable());
        return this;
    }

    public byte[] toByteArray() {
        PersistentTemplate persistent = new PersistentTemplate(this.immutable.mutable());
        return (byte[])Exceptions.wrap().get(() -> mapper.writeValueAsBytes((Object)persistent));
    }

    @Deprecated
    public String serialize() {
        return new Gson().toJson((Object)new PersistentTemplate(this.immutable.mutable()));
    }

    @Deprecated
    public FingerprintTemplate convert(byte[] template) {
        this.immutable = FingerprintCompatibility.convert((byte[])template).immutable;
        return this;
    }

    static {
        PlatformCheck.run();
        logger = LoggerFactory.getLogger(FingerprintCompatibility.class);
        mapper = new ObjectMapper((JsonFactory)new CBORFactory()).setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
        EMPTY = new FingerprintTemplate(ImmutableTemplate.EMPTY);
    }
}

