/*
 * Decompiled with CFR 0.152.
 */
package com.machinezoo.sourceafis;

import com.machinezoo.sourceafis.DoubleAngle;
import com.machinezoo.sourceafis.EdgeShape;
import com.machinezoo.sourceafis.FingerprintTemplate;
import com.machinezoo.sourceafis.FingerprintTransparency;
import com.machinezoo.sourceafis.ImmutableMatcher;
import com.machinezoo.sourceafis.ImmutableTemplate;
import com.machinezoo.sourceafis.IndexedEdge;
import com.machinezoo.sourceafis.MatcherThread;
import com.machinezoo.sourceafis.Parameters;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class FingerprintMatcher {
    private volatile ImmutableMatcher immutable = ImmutableMatcher.NULL;

    @Deprecated
    public FingerprintMatcher transparency(FingerprintTransparency transparency) {
        return this;
    }

    public FingerprintMatcher index(FingerprintTemplate probe) {
        Objects.requireNonNull(probe);
        ImmutableTemplate template = probe.immutable;
        this.immutable = new ImmutableMatcher(template, this.buildEdgeHash(template));
        return this;
    }

    private Int2ObjectMap<List<IndexedEdge>> buildEdgeHash(ImmutableTemplate template) {
        Int2ObjectOpenHashMap map = new Int2ObjectOpenHashMap();
        for (int reference = 0; reference < template.minutiae.length; ++reference) {
            for (int neighbor = 0; neighbor < template.minutiae.length; ++neighbor) {
                if (reference == neighbor) continue;
                IndexedEdge edge = new IndexedEdge(template.minutiae, reference, neighbor);
                for (int hash : this.shapeCoverage(edge)) {
                    ArrayList<IndexedEdge> list = (ArrayList<IndexedEdge>)map.get(hash);
                    if (list == null) {
                        list = new ArrayList<IndexedEdge>();
                        map.put(hash, list);
                    }
                    list.add(edge);
                }
            }
        }
        FingerprintTransparency.current().logEdgeHash((Int2ObjectMap<List<IndexedEdge>>)map);
        return map;
    }

    private List<Integer> shapeCoverage(EdgeShape edge) {
        int minLengthBin = (edge.length - 13) / 13;
        int maxLengthBin = (edge.length + 13) / 13;
        int angleBins = (int)Math.ceil(Math.PI * 2 / Parameters.MAX_ANGLE_ERROR);
        int minReferenceBin = (int)(DoubleAngle.difference(edge.referenceAngle, Parameters.MAX_ANGLE_ERROR) / Parameters.MAX_ANGLE_ERROR);
        int maxReferenceBin = (int)(DoubleAngle.add(edge.referenceAngle, Parameters.MAX_ANGLE_ERROR) / Parameters.MAX_ANGLE_ERROR);
        int endReferenceBin = (maxReferenceBin + 1) % angleBins;
        int minNeighborBin = (int)(DoubleAngle.difference(edge.neighborAngle, Parameters.MAX_ANGLE_ERROR) / Parameters.MAX_ANGLE_ERROR);
        int maxNeighborBin = (int)(DoubleAngle.add(edge.neighborAngle, Parameters.MAX_ANGLE_ERROR) / Parameters.MAX_ANGLE_ERROR);
        int endNeighborBin = (maxNeighborBin + 1) % angleBins;
        ArrayList<Integer> coverage = new ArrayList<Integer>();
        for (int lengthBin = minLengthBin; lengthBin <= maxLengthBin; ++lengthBin) {
            int referenceBin = minReferenceBin;
            while (referenceBin != endReferenceBin) {
                int neighborBin = minNeighborBin;
                while (neighborBin != endNeighborBin) {
                    coverage.add((referenceBin << 24) + (neighborBin << 16) + lengthBin);
                    neighborBin = (neighborBin + 1) % angleBins;
                }
                referenceBin = (referenceBin + 1) % angleBins;
            }
        }
        return coverage;
    }

    public double match(FingerprintTemplate candidate) {
        Objects.requireNonNull(candidate);
        MatcherThread thread = MatcherThread.current();
        thread.selectMatcher(this.immutable);
        thread.selectCandidate(candidate.immutable);
        return thread.match();
    }
}

