/*
 * Decompiled with CFR 0.152.
 */
package com.machinezoo.sourceafis;

import com.machinezoo.fingerprintio.TemplateFormat;
import com.machinezoo.sourceafis.FingerprintTemplate;
import com.machinezoo.sourceafis.ImmutableTemplate;
import com.machinezoo.sourceafis.MutableTemplate;
import com.machinezoo.sourceafis.PlatformCheck;
import com.machinezoo.sourceafis.TemplateCodec;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FingerprintCompatibility {
    private static final Logger logger;
    private static String version;

    public static String version() {
        return version;
    }

    private FingerprintCompatibility() {
    }

    public static FingerprintTemplate convert(byte[] template) {
        Objects.requireNonNull(template);
        return (FingerprintTemplate)FingerprintCompatibility.convertAll(template).stream().findFirst().orElseThrow(() -> new IllegalArgumentException("No fingerprints found in the template"));
    }

    public static List<FingerprintTemplate> convertAll(byte[] template) {
        Objects.requireNonNull(template);
        try {
            TemplateFormat format = TemplateFormat.detect((byte[])template);
            if (format == null || !TemplateCodec.ALL.containsKey(format)) {
                throw new IllegalArgumentException("Unsupported template format.");
            }
            return TemplateCodec.ALL.get(format).decode(template).stream().map(fp -> new FingerprintTemplate(new ImmutableTemplate((MutableTemplate)fp))).collect(Collectors.toList());
        }
        catch (Throwable ex) {
            try {
                List<FingerprintTemplate> deserialized = Arrays.asList(new FingerprintTemplate(template, false));
                logger.warn("Native SourceAFIS template was passed to convert() or convertAll() in FingerprintCompatibility. It was accepted, but FingerprintTemplate constructor should be used instead.");
                return deserialized;
            }
            catch (Throwable ex2) {
                throw ex;
            }
        }
    }

    private static byte[] encode(TemplateFormat format, FingerprintTemplate[] templates) {
        return TemplateCodec.ALL.get(format).encode(Arrays.stream(templates).map(t -> t.immutable.mutable()).collect(Collectors.toList()));
    }

    public static byte[] toAnsiIncits378v2004(FingerprintTemplate ... templates) {
        return FingerprintCompatibility.encode(TemplateFormat.ANSI_378, templates);
    }

    public static byte[] toAnsiIncits378v2009(FingerprintTemplate ... templates) {
        return FingerprintCompatibility.encode(TemplateFormat.ANSI_378_2009, templates);
    }

    public static byte[] toAnsiIncits378v2009AM1(FingerprintTemplate ... templates) {
        return FingerprintCompatibility.encode(TemplateFormat.ANSI_378_2009_AM1, templates);
    }

    static {
        PlatformCheck.run();
        logger = LoggerFactory.getLogger(FingerprintCompatibility.class);
        version = new String(PlatformCheck.resource("version.txt"), StandardCharsets.UTF_8).trim();
    }
}

