/*
 * Decompiled with CFR 0.152.
 */
package com.machinezoo.sourceafis;

import com.machinezoo.sourceafis.DoublePoint;
import com.machinezoo.sourceafis.IntPoint;

class DoublePointMatrix {
    final int width;
    final int height;
    private final double[] vectors;

    DoublePointMatrix(int width, int height) {
        this.width = width;
        this.height = height;
        this.vectors = new double[2 * width * height];
    }

    DoublePointMatrix(IntPoint size) {
        this(size.x, size.y);
    }

    IntPoint size() {
        return new IntPoint(this.width, this.height);
    }

    DoublePoint get(int x, int y) {
        int i = this.offset(x, y);
        return new DoublePoint(this.vectors[i], this.vectors[i + 1]);
    }

    DoublePoint get(IntPoint at) {
        return this.get(at.x, at.y);
    }

    void set(int x, int y, double px, double py) {
        int i = this.offset(x, y);
        this.vectors[i] = px;
        this.vectors[i + 1] = py;
    }

    void set(int x, int y, DoublePoint point) {
        this.set(x, y, point.x, point.y);
    }

    void set(IntPoint at, DoublePoint point) {
        this.set(at.x, at.y, point);
    }

    void add(int x, int y, double px, double py) {
        int i;
        int n = i = this.offset(x, y);
        this.vectors[n] = this.vectors[n] + px;
        int n2 = i + 1;
        this.vectors[n2] = this.vectors[n2] + py;
    }

    void add(int x, int y, DoublePoint point) {
        this.add(x, y, point.x, point.y);
    }

    void add(IntPoint at, DoublePoint point) {
        this.add(at.x, at.y, point);
    }

    private int offset(int x, int y) {
        return 2 * (y * this.width + x);
    }
}

