/*
 * Decompiled with CFR 0.152.
 */
package com.machinezoo.sourceafis;

class CircularArray {
    Object[] array;
    int head;
    int size;

    CircularArray(int capacity) {
        this.array = new Object[capacity];
    }

    void validateItemIndex(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException();
        }
    }

    void validateCursorIndex(int index) {
        if (index < 0 || index > this.size) {
            throw new IndexOutOfBoundsException();
        }
    }

    int location(int index) {
        return this.head + index < this.array.length ? this.head + index : this.head + index - this.array.length;
    }

    void enlarge() {
        Object[] enlarged = new Object[2 * this.array.length];
        for (int i = 0; i < this.size; ++i) {
            enlarged[i] = this.array[this.location(i)];
        }
        this.array = enlarged;
        this.head = 0;
    }

    Object get(int index) {
        this.validateItemIndex(index);
        return this.array[this.location(index)];
    }

    void set(int index, Object item) {
        this.validateItemIndex(index);
        this.array[this.location((int)index)] = item;
    }

    void move(int from, int to, int length) {
        block3: {
            block2: {
                if (from >= to) break block2;
                for (int i = length - 1; i >= 0; --i) {
                    this.set(to + i, this.get(from + i));
                }
                break block3;
            }
            if (from <= to) break block3;
            for (int i = 0; i < length; ++i) {
                this.set(to + i, this.get(from + i));
            }
        }
    }

    void insert(int index, int amount) {
        this.validateCursorIndex(index);
        if (amount < 0) {
            throw new IllegalArgumentException();
        }
        while (this.size + amount > this.array.length) {
            this.enlarge();
        }
        if (2 * index >= this.size) {
            this.size += amount;
            this.move(index, index + amount, this.size - amount - index);
        } else {
            this.head -= amount;
            this.size += amount;
            if (this.head < 0) {
                this.head += this.array.length;
            }
            this.move(amount, 0, index);
        }
        for (int i = 0; i < amount; ++i) {
            this.set(index + i, null);
        }
    }

    void remove(int index, int amount) {
        this.validateCursorIndex(index);
        if (amount < 0) {
            throw new IllegalArgumentException();
        }
        this.validateCursorIndex(index + amount);
        if (2 * index >= this.size - amount) {
            this.move(index + amount, index, this.size - amount - index);
            for (int i = 0; i < amount; ++i) {
                this.set(this.size - i - 1, null);
            }
            this.size -= amount;
        } else {
            this.move(0, amount, index);
            for (int i = 0; i < amount; ++i) {
                this.set(i, null);
            }
            this.head += amount;
            this.size -= amount;
            if (this.head >= this.array.length) {
                this.head -= this.array.length;
            }
        }
    }
}

