/*
 * Decompiled with CFR 0.152.
 */
package com.machinezoo.sourceafis;

import com.machinezoo.sourceafis.BlockGrid;
import com.machinezoo.sourceafis.IntPoint;
import com.machinezoo.sourceafis.Integers;

class BlockMap {
    final IntPoint pixels;
    final BlockGrid primary;
    final BlockGrid secondary;

    BlockMap(int width, int height, int maxBlockSize) {
        int x;
        int y;
        this.pixels = new IntPoint(width, height);
        this.primary = new BlockGrid(new IntPoint(Integers.roundUpDiv(this.pixels.x, maxBlockSize), Integers.roundUpDiv(this.pixels.y, maxBlockSize)));
        for (y = 0; y <= this.primary.blocks.y; ++y) {
            this.primary.y[y] = y * this.pixels.y / this.primary.blocks.y;
        }
        for (x = 0; x <= this.primary.blocks.x; ++x) {
            this.primary.x[x] = x * this.pixels.x / this.primary.blocks.x;
        }
        this.secondary = new BlockGrid(this.primary.corners);
        this.secondary.y[0] = 0;
        for (y = 0; y < this.primary.blocks.y; ++y) {
            this.secondary.y[y + 1] = this.primary.block((int)0, (int)y).center().y;
        }
        this.secondary.y[this.secondary.blocks.y] = this.pixels.y;
        this.secondary.x[0] = 0;
        for (x = 0; x < this.primary.blocks.x; ++x) {
            this.secondary.x[x + 1] = this.primary.block((int)x, (int)0).center().x;
        }
        this.secondary.x[this.secondary.blocks.x] = this.pixels.x;
    }
}

