/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.objects;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectArrays;
import it.unimi.dsi.fastutil.objects.ObjectBidirectionalIterator;
import it.unimi.dsi.fastutil.objects.ObjectCollection;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectIterators;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Objects;
import java.util.function.Predicate;

public final class ObjectIterators {
    public static final EmptyIterator EMPTY_ITERATOR = new EmptyIterator();

    private ObjectIterators() {
    }

    public static <K> ObjectIterator<K> emptyIterator() {
        return EMPTY_ITERATOR;
    }

    public static <K> ObjectListIterator<K> singleton(K element) {
        return new SingletonIterator(element);
    }

    public static <K> ObjectListIterator<K> wrap(K[] array, int offset, int length) {
        ObjectArrays.ensureOffsetLength(array, offset, length);
        return new ArrayIterator((Object[])array, offset, length);
    }

    public static <K> ObjectListIterator<K> wrap(K[] array) {
        return new ArrayIterator((Object[])array, 0, array.length);
    }

    public static <K> int unwrap(Iterator<? extends K> i, K[] array, int offset, int max) {
        if (max < 0) {
            throw new IllegalArgumentException("The maximum number of elements (" + max + ") is negative");
        }
        if (offset < 0 || offset + max > array.length) {
            throw new IllegalArgumentException();
        }
        int j = max;
        while (j-- != 0 && i.hasNext()) {
            array[offset++] = i.next();
        }
        return max - j - 1;
    }

    public static <K> int unwrap(Iterator<? extends K> i, K[] array) {
        return ObjectIterators.unwrap(i, array, 0, array.length);
    }

    public static <K> K[] unwrap(Iterator<? extends K> i, int max) {
        if (max < 0) {
            throw new IllegalArgumentException("The maximum number of elements (" + max + ") is negative");
        }
        Object[] array = new Object[16];
        int j = 0;
        while (max-- != 0 && i.hasNext()) {
            if (j == array.length) {
                array = ObjectArrays.grow(array, j + 1);
            }
            array[j++] = i.next();
        }
        return ObjectArrays.trim(array, j);
    }

    public static <K> K[] unwrap(Iterator<? extends K> i) {
        return ObjectIterators.unwrap(i, Integer.MAX_VALUE);
    }

    public static <K> int unwrap(Iterator<K> i, ObjectCollection<? super K> c, int max) {
        if (max < 0) {
            throw new IllegalArgumentException("The maximum number of elements (" + max + ") is negative");
        }
        int j = max;
        while (j-- != 0 && i.hasNext()) {
            c.add(i.next());
        }
        return max - j - 1;
    }

    public static <K> long unwrap(Iterator<K> i, ObjectCollection<? super K> c) {
        long n = 0L;
        while (i.hasNext()) {
            c.add(i.next());
            ++n;
        }
        return n;
    }

    public static <K> int pour(Iterator<K> i, ObjectCollection<? super K> s, int max) {
        if (max < 0) {
            throw new IllegalArgumentException("The maximum number of elements (" + max + ") is negative");
        }
        int j = max;
        while (j-- != 0 && i.hasNext()) {
            s.add(i.next());
        }
        return max - j - 1;
    }

    public static <K> int pour(Iterator<K> i, ObjectCollection<? super K> s) {
        return ObjectIterators.pour(i, s, Integer.MAX_VALUE);
    }

    public static <K> ObjectList<K> pour(Iterator<K> i, int max) {
        ObjectArrayList l = new ObjectArrayList();
        ObjectIterators.pour(i, l, max);
        l.trim();
        return l;
    }

    public static <K> ObjectList<K> pour(Iterator<K> i) {
        return ObjectIterators.pour(i, Integer.MAX_VALUE);
    }

    public static <K> ObjectIterator<K> asObjectIterator(Iterator<K> i) {
        if (i instanceof ObjectIterator) {
            return (ObjectIterator)i;
        }
        return new IteratorWrapper(i);
    }

    public static <K> ObjectListIterator<K> asObjectIterator(ListIterator<K> i) {
        if (i instanceof ObjectListIterator) {
            return (ObjectListIterator)i;
        }
        return new ListIteratorWrapper(i);
    }

    public static <K> boolean any(ObjectIterator<K> iterator, Predicate<? super K> predicate) {
        return ObjectIterators.indexOf(iterator, predicate) != -1;
    }

    public static <K> boolean all(ObjectIterator<K> iterator, Predicate<? super K> predicate) {
        Objects.requireNonNull(predicate);
        do {
            if (iterator.hasNext()) continue;
            return true;
        } while (predicate.test(iterator.next()));
        return false;
    }

    public static <K> int indexOf(ObjectIterator<K> iterator, Predicate<? super K> predicate) {
        Objects.requireNonNull(predicate);
        int i = 0;
        while (iterator.hasNext()) {
            if (predicate.test(iterator.next())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static <K> ObjectIterator<K> concat(ObjectIterator<? extends K>[] a) {
        return ObjectIterators.concat(a, 0, a.length);
    }

    public static <K> ObjectIterator<K> concat(ObjectIterator<? extends K>[] a, int offset, int length) {
        return new IteratorConcatenator((ObjectIterator[])a, offset, length);
    }

    public static <K> ObjectIterator<K> unmodifiable(ObjectIterator<K> i) {
        return new UnmodifiableIterator(i);
    }

    public static <K> ObjectBidirectionalIterator<K> unmodifiable(ObjectBidirectionalIterator<K> i) {
        return new UnmodifiableBidirectionalIterator(i);
    }

    public static <K> ObjectListIterator<K> unmodifiable(ObjectListIterator<K> i) {
        return new UnmodifiableListIterator(i);
    }
}

