/*
 * Decompiled with CFR 0.152.
 */
package com.github.akurilov.commons.io.util;

import com.github.akurilov.commons.io.util.BufferedByteChannelBase;
import com.github.akurilov.commons.io.util.BufferedReadableByteChannel;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public class InputStreamWrapperChannel
extends BufferedByteChannelBase
implements BufferedReadableByteChannel {
    private InputStream in = null;
    private static final ThreadLocal<InputStreamWrapperChannel[]> REUSABLE_INPUT_CHANNELS = ThreadLocal.withInitial(() -> {
        int count = (int)(Math.log(1.6777216E7) / Math.log(2.0) + 1.0);
        return new InputStreamWrapperChannel[count];
    });

    public InputStreamWrapperChannel(int buffSize) {
        super(buffSize);
    }

    @Override
    public final int read(ByteBuffer dst) throws IOException {
        int n = this.in.read(this.bb, 0, Math.min(this.bb.length, dst.remaining()));
        dst.put(this.bb, 0, n);
        return n;
    }

    public static BufferedReadableByteChannel getThreadLocalInstance(InputStream in, long remainingSize) throws IllegalStateException {
        if (remainingSize < 0L) {
            throw new IllegalArgumentException("Requested negative size: " + remainingSize);
        }
        InputStreamWrapperChannel[] threadLocalReusableChannels = REUSABLE_INPUT_CHANNELS.get();
        long currBuffSize = Long.highestOneBit(remainingSize);
        if (currBuffSize > 0x1000000L) {
            currBuffSize = 0x1000000L;
        } else if (currBuffSize < 0x1000000L) {
            if (currBuffSize < 1L) {
                currBuffSize = 1L;
            } else if (currBuffSize < remainingSize) {
                currBuffSize <<= 1;
            }
        }
        int i = Long.numberOfTrailingZeros(currBuffSize);
        InputStreamWrapperChannel chan = threadLocalReusableChannels[i];
        if (chan == null) {
            threadLocalReusableChannels[i] = chan = new InputStreamWrapperChannel((int)currBuffSize);
        }
        chan.in = in;
        return chan;
    }

    @Override
    public void close() throws IOException {
        this.in = null;
    }
}

