/*
 * Decompiled with CFR 0.152.
 */
package com.github.akurilov.commons.io.collection;

import com.github.akurilov.commons.io.Output;
import com.github.akurilov.commons.io.collection.ArrayInput;
import java.io.IOException;
import java.util.List;

public class ArrayOutput<T>
implements Output<T> {
    protected final T[] items;
    protected int i = 0;

    public ArrayOutput(T[] items) {
        this.items = items;
    }

    @Override
    public boolean put(T item) throws IOException {
        if (this.i < this.items.length) {
            this.items[this.i++] = item;
            return true;
        }
        return false;
    }

    @Override
    public int put(List<T> buffer, int from, int to) throws IOException {
        int n = Math.min(this.items.length - this.i, to - from);
        for (int j = 0; j < n; ++j) {
            this.items[this.i + j] = buffer.get(from + j);
        }
        return n;
    }

    @Override
    public final int put(List<T> items) throws IOException {
        return this.put(items, 0, items.size());
    }

    @Override
    public ArrayInput<T> getInput() throws IOException {
        return new ArrayInput<T>(this.items);
    }

    @Override
    public void close() throws IOException {
    }

    public String toString() {
        return "arrayOutput<" + this.items.hashCode() + ">";
    }
}

