/*
 * Decompiled with CFR 0.152.
 */
package com.github.akurilov.commons.io.collection;

import com.github.akurilov.commons.io.Input;
import java.io.EOFException;
import java.io.IOException;
import java.util.List;

public class ArrayInput<T>
implements Input<T> {
    protected final T[] items;
    protected int size;
    protected int i = 0;

    public ArrayInput(T[] items) {
        this.items = items;
        this.size = items.length;
    }

    @Override
    public T get() throws EOFException, IOException {
        if (this.i < this.size) {
            return this.items[this.i++];
        }
        throw new EOFException();
    }

    @Override
    public int get(List<T> buffer, int maxCount) throws EOFException, IOException {
        int n = this.size - this.i;
        if (n > 0) {
            n = Math.min(n, maxCount);
            for (int j = this.i; j < this.i + n; ++j) {
                buffer.add(this.items[j]);
            }
        } else {
            throw new EOFException();
        }
        this.i += n;
        return n;
    }

    @Override
    public long skip(long itemsCount) throws IOException {
        int remainingCount = this.size - this.i;
        if (itemsCount > (long)remainingCount) {
            this.i = 0;
            return remainingCount;
        }
        this.i += (int)itemsCount;
        return itemsCount;
    }

    @Override
    public void reset() throws IOException {
        this.i = 0;
    }

    @Override
    public void close() throws IOException {
    }

    public String toString() {
        return "arrayInput<" + this.items.hashCode() + ">";
    }
}

