/*
 * Decompiled with CFR 0.152.
 */
package com.github.akurilov.commons.collection;

import com.github.akurilov.commons.collection.CircularBuffer;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.RandomAccess;

public class CircularArrayBuffer<E>
extends AbstractList<E>
implements CircularBuffer<E>,
Cloneable,
RandomAccess,
Serializable {
    private volatile int offset = 0;
    private volatile int end = -1;
    protected final E[] array;
    protected final int capacity;

    public CircularArrayBuffer(int capacity) {
        this.array = new Object[capacity];
        this.capacity = capacity;
    }

    @Override
    public final int capacity() {
        return this.capacity;
    }

    @Override
    public final int offset() {
        return this.offset;
    }

    @Override
    public final int end() {
        return this.end;
    }

    @Override
    public final int size() {
        if (this.isEmpty()) {
            return 0;
        }
        if (this.offset < this.end) {
            return this.end - this.offset;
        }
        return this.capacity + this.end - this.offset;
    }

    @Override
    public final boolean isEmpty() {
        return this.end < 0;
    }

    @Override
    public final void clear() {
        this.offset = 0;
        this.end = -1;
    }

    @Override
    public final boolean add(E e) {
        if (this.isEmpty()) {
            this.array[this.offset] = e;
            this.end = this.increaseIndex(this.offset, 1);
            return true;
        }
        if (this.size() < this.capacity) {
            this.array[this.end] = e;
            this.end = this.increaseIndex(this.end, 1);
            return true;
        }
        return false;
    }

    @Override
    public final boolean addAll(Collection<? extends E> elements) {
        int elementsCount = elements.size();
        if (this.capacity - this.size() < elementsCount) {
            return false;
        }
        for (E e : elements) {
            if (this.isEmpty()) {
                this.array[this.offset] = e;
                this.end = this.increaseIndex(this.offset, 1);
                continue;
            }
            if (this.size() >= this.capacity) continue;
            this.array[this.end] = e;
            this.end = this.increaseIndex(this.end, 1);
        }
        return true;
    }

    @Override
    public E get(int i) {
        if (this.isEmpty()) {
            throw new IndexOutOfBoundsException();
        }
        return this.array[this.translateIndex(i)];
    }

    @Override
    public E set(int i, E e) {
        if (this.isEmpty()) {
            throw new IndexOutOfBoundsException(Integer.toString(i));
        }
        int j = this.translateIndex(i);
        E prev = this.array[j];
        this.array[j] = e;
        return prev;
    }

    @Override
    public final E remove(int i) {
        E e;
        if (this.isEmpty()) {
            throw new IndexOutOfBoundsException(Integer.toString(i));
        }
        if (this.size() == 1) {
            e = this.array[this.offset];
            this.clear();
        } else {
            int j = this.translateIndex(i);
            e = this.array[j];
            if (j == this.offset) {
                this.offset = this.increaseIndex(this.offset, 1);
            } else if (this.end > 0 && j == this.end - 1) {
                --this.end;
            } else if (this.end == 0 && j == this.capacity - 1) {
                this.end = this.capacity - 1;
            } else {
                throw new UnsupportedOperationException("Able to remove only from the beginning either end");
            }
        }
        return e;
    }

    @Override
    public final CircularArrayBuffer<E> removeFirst(int n) {
        if (this.size() < n) {
            throw new IndexOutOfBoundsException();
        }
        if (this.size() == n) {
            this.clear();
        } else {
            this.offset = this.increaseIndex(this.offset, n);
        }
        return this;
    }

    @Override
    public final CircularArrayBuffer<E> removeLast(int n) {
        if (this.size() < n) {
            throw new IndexOutOfBoundsException();
        }
        if (this.size() == n) {
            this.clear();
        } else {
            this.end = n > this.end ? this.capacity + this.end - n : (this.end -= n);
        }
        return this;
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<E> iterator() {
        return new ListIteratorImpl(this, 0);
    }

    @Override
    public ListIterator<E> listIterator() {
        return new ListIteratorImpl(this, 0);
    }

    @Override
    public ListIterator<E> listIterator(int i) {
        return new ListIteratorImpl(this, i);
    }

    private int translateIndex(int i) throws IndexOutOfBoundsException {
        if (i < this.size()) {
            return (this.offset + i) % this.capacity;
        }
        throw new IndexOutOfBoundsException(Integer.toString(i));
    }

    private int increaseIndex(int i, int n) {
        return (i + n) % this.capacity;
    }

    protected static class ListIteratorImpl<E>
    implements ListIterator<E> {
        protected final CircularBuffer<E> buff;
        protected final int size;
        protected final int startIndex;
        private int i;

        protected ListIteratorImpl(CircularBuffer<E> buff, int startIndex) {
            this.buff = buff;
            this.size = buff.size();
            this.startIndex = startIndex;
            this.i = startIndex;
        }

        @Override
        public boolean hasNext() {
            return this.i < this.size;
        }

        @Override
        public final E next() {
            try {
                return this.buff.get(this.i++);
            }
            catch (IndexOutOfBoundsException e) {
                throw new NoSuchElementException();
            }
        }

        @Override
        public final void remove() {
            throw new UnsupportedOperationException("Removing an element is not supported");
        }

        @Override
        public boolean hasPrevious() {
            return this.i > this.startIndex;
        }

        @Override
        public final E previous() {
            if (this.hasPrevious()) {
                return this.buff.get(--this.i);
            }
            throw new NoSuchElementException();
        }

        @Override
        public int nextIndex() {
            return this.i;
        }

        @Override
        public int previousIndex() {
            return this.i - 1;
        }

        @Override
        public void set(E e) throws IndexOutOfBoundsException {
            this.buff.set(this.i, e);
        }

        @Override
        public final void add(E e) throws UnsupportedOperationException {
            throw new UnsupportedOperationException("Inserting an element is not supported");
        }
    }
}

