/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.shorts;

import it.unimi.dsi.fastutil.ints.AbstractIntCollection;
import it.unimi.dsi.fastutil.ints.AbstractIntIterator;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.shorts.AbstractShortIterator;
import it.unimi.dsi.fastutil.shorts.AbstractShortSet;
import it.unimi.dsi.fastutil.shorts.Short2IntMap;
import it.unimi.dsi.fastutil.shorts.ShortIterator;
import it.unimi.dsi.fastutil.shorts.ShortSet;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractShort2IntMap
implements Short2IntMap,
Serializable {
    protected int defRetValue;

    protected AbstractShort2IntMap() {
    }

    @Override
    public void defaultReturnValue(int rv) {
        this.defRetValue = rv;
    }

    @Override
    public int defaultReturnValue() {
        return this.defRetValue;
    }

    @Override
    public int put(short key, int value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int remove(short key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Integer get(Object ok) {
        short k = (Short)ok;
        return this.containsKey(k) ? Integer.valueOf(this.get(k)) : null;
    }

    @Override
    public Integer put(Short ok, Integer ov) {
        short k = ok;
        int v = this.put(k, (int)ov);
        return this.containsKey(k) ? Integer.valueOf(v) : null;
    }

    @Override
    public Integer remove(Object ok) {
        short k = (Short)ok;
        int v = this.remove(k);
        return this.containsKey(k) ? Integer.valueOf(v) : null;
    }

    @Override
    public boolean containsValue(Object ov) {
        return this.containsValue((Integer)ov);
    }

    @Override
    public boolean containsKey(Object ok) {
        return this.containsKey((Short)ok);
    }

    @Override
    public boolean containsValue(int v) {
        return this.values().contains(v);
    }

    @Override
    public boolean containsKey(short k) {
        return this.keySet().contains(k);
    }

    @Override
    public void putAll(Map<? extends Short, ? extends Integer> m) {
        int n = m.size();
        Iterator<Map.Entry<? extends Short, ? extends Integer>> i = m.entrySet().iterator();
        if (m instanceof Short2IntMap) {
            while (n-- != 0) {
                Short2IntMap.Entry e = (Short2IntMap.Entry)i.next();
                this.put(e.getShortKey(), e.getIntValue());
            }
        } else {
            while (n-- != 0) {
                Map.Entry<? extends Short, ? extends Integer> e = i.next();
                this.put(e.getKey(), e.getValue());
            }
        }
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public ShortSet keySet() {
        return new AbstractShortSet(){

            public boolean contains(short k) {
                return AbstractShort2IntMap.this.containsKey(k);
            }

            public int size() {
                return AbstractShort2IntMap.this.size();
            }

            public void clear() {
                AbstractShort2IntMap.this.clear();
            }

            public ShortIterator iterator() {
                return new AbstractShortIterator(){
                    final ObjectIterator<Map.Entry<Short, Integer>> i;
                    {
                        this.i = AbstractShort2IntMap.this.entrySet().iterator();
                    }

                    public short nextShort() {
                        return ((Short2IntMap.Entry)this.i.next()).getShortKey();
                    }

                    public boolean hasNext() {
                        return this.i.hasNext();
                    }
                };
            }
        };
    }

    @Override
    public IntCollection values() {
        return new AbstractIntCollection(){

            public boolean contains(int k) {
                return AbstractShort2IntMap.this.containsValue(k);
            }

            public int size() {
                return AbstractShort2IntMap.this.size();
            }

            public void clear() {
                AbstractShort2IntMap.this.clear();
            }

            public IntIterator iterator() {
                return new AbstractIntIterator(){
                    final ObjectIterator<Map.Entry<Short, Integer>> i;
                    {
                        this.i = AbstractShort2IntMap.this.entrySet().iterator();
                    }

                    public int nextInt() {
                        return ((Short2IntMap.Entry)this.i.next()).getIntValue();
                    }

                    public boolean hasNext() {
                        return this.i.hasNext();
                    }
                };
            }
        };
    }

    @Override
    public int hashCode() {
        int h = 0;
        int n = this.size();
        ObjectIterator<Map.Entry<Short, Integer>> i = this.entrySet().iterator();
        while (n-- != 0) {
            h += ((Object)((Map.Entry)i.next())).hashCode();
        }
        return h;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map m = (Map)o;
        if (m.size() != this.size()) {
            return false;
        }
        return this.entrySet().containsAll(m.entrySet());
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        ObjectIterator<Map.Entry<Short, Integer>> i = this.entrySet().iterator();
        int n = this.size();
        boolean first = true;
        s.append("{");
        while (n-- != 0) {
            if (first) {
                first = false;
            } else {
                s.append(", ");
            }
            Short2IntMap.Entry e = (Short2IntMap.Entry)i.next();
            s.append(String.valueOf(e.getShortKey()));
            s.append("=>");
            s.append(String.valueOf(e.getIntValue()));
        }
        s.append("}");
        return s.toString();
    }

    public static class BasicEntry
    implements Short2IntMap.Entry {
        protected short key;
        protected int value;

        public BasicEntry(Short key, Integer value) {
            this.key = key;
            this.value = value;
        }

        public BasicEntry(short key, int value) {
            this.key = key;
            this.value = value;
        }

        public Short getKey() {
            return this.key;
        }

        public short getShortKey() {
            return this.key;
        }

        public Integer getValue() {
            return this.value;
        }

        public int getIntValue() {
            return this.value;
        }

        public int setValue(int value) {
            throw new UnsupportedOperationException();
        }

        public Integer setValue(Integer value) {
            return this.setValue((int)value);
        }

        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return this.key == (Short)e.getKey() && this.value == (Integer)e.getValue();
        }

        public int hashCode() {
            return this.key ^ this.value;
        }

        public String toString() {
            return this.key + "->" + this.value;
        }
    }
}

