/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.objects;

import it.unimi.dsi.fastutil.IndirectDoublePriorityQueue;
import it.unimi.dsi.fastutil.objects.ObjectArrayIndirectPriorityQueue;
import it.unimi.dsi.fastutil.objects.ObjectComparators;
import java.util.Comparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectArrayIndirectDoublePriorityQueue<K>
extends ObjectArrayIndirectPriorityQueue<K>
implements IndirectDoublePriorityQueue<K> {
    protected Comparator<? super K> secondaryComparator;

    public ObjectArrayIndirectDoublePriorityQueue(K[] refArray, int capacity, Comparator<? super K> c, Comparator<? super K> d) {
        super(refArray, capacity, c);
        this.secondaryComparator = d;
    }

    public ObjectArrayIndirectDoublePriorityQueue(K[] refArray, int capacity, Comparator<? super K> c) {
        super(refArray, capacity, c == null ? ObjectComparators.OPPOSITE_COMPARATOR : ObjectComparators.oppositeComparator(c));
    }

    public ObjectArrayIndirectDoublePriorityQueue(K[] refArray, int capacity) {
        this(refArray, capacity, null);
    }

    public ObjectArrayIndirectDoublePriorityQueue(K[] refArray, Comparator<? super K> c, Comparator<? super K> d) {
        this(refArray, refArray.length, c, d);
    }

    public ObjectArrayIndirectDoublePriorityQueue(K[] refArray, Comparator<? super K> c) {
        this(refArray, refArray.length, c);
    }

    public ObjectArrayIndirectDoublePriorityQueue(K[] refArray) {
        this(refArray, refArray.length, null);
    }

    public ObjectArrayIndirectDoublePriorityQueue(K[] refArray, int[] a, int size, Comparator<? super K> c, Comparator<? super K> d) {
        this(refArray, 0, c, d);
        this.array = a;
        this.size = size;
    }

    public ObjectArrayIndirectDoublePriorityQueue(K[] refArray, int[] a, Comparator<? super K> c, Comparator<? super K> d) {
        this(refArray, a, a.length, c, d);
    }

    public ObjectArrayIndirectDoublePriorityQueue(K[] refArray, int[] a, int size, Comparator<? super K> c) {
        this(refArray, 0, c);
        this.array = a;
        this.size = size;
    }

    public ObjectArrayIndirectDoublePriorityQueue(K[] refArray, int[] a, Comparator<? super K> c) {
        this(refArray, a, a.length, c);
    }

    public ObjectArrayIndirectDoublePriorityQueue(K[] refArray, int[] a, int size) {
        this(refArray, a, size, null);
    }

    public ObjectArrayIndirectDoublePriorityQueue(K[] refArray, int[] a) {
        this(refArray, a, a.length);
    }

    private int findSecondaryFirst() {
        int i = this.size;
        int firstIndex = --i;
        Object first = this.refArray[this.array[firstIndex]];
        if (this.secondaryComparator == null) {
            while (i-- != 0) {
                if (((Comparable)this.refArray[this.array[i]]).compareTo(first) >= 0) continue;
                firstIndex = i;
                first = this.refArray[this.array[firstIndex]];
            }
        } else {
            while (i-- != 0) {
                if (this.secondaryComparator.compare(this.refArray[this.array[i]], first) >= 0) continue;
                firstIndex = i;
                first = this.refArray[this.array[firstIndex]];
            }
        }
        return firstIndex;
    }

    private int findSecondaryLast() {
        int i = this.size;
        int lastIndex = --i;
        Object last = this.refArray[this.array[lastIndex]];
        if (this.secondaryComparator == null) {
            while (i-- != 0) {
                if (((Comparable)last).compareTo(this.refArray[this.array[i]]) >= 0) continue;
                lastIndex = i;
                last = this.refArray[this.array[lastIndex]];
            }
        } else {
            while (i-- != 0) {
                if (this.secondaryComparator.compare(last, this.refArray[this.array[i]]) >= 0) continue;
                lastIndex = i;
                last = this.refArray[this.array[lastIndex]];
            }
        }
        return lastIndex;
    }

    @Override
    public int secondaryFirst() {
        return this.array[this.findSecondaryFirst()];
    }

    @Override
    public int secondaryLast() {
        return this.array[this.findSecondaryLast()];
    }

    @Override
    public int secondaryFront(int[] a) {
        Object secondaryTop = this.refArray[this.array[this.findSecondaryFirst()]];
        int i = this.size;
        int c = 0;
        while (i-- != 0) {
            if (!secondaryTop.equals(this.refArray[this.array[i]])) continue;
            a[c++] = this.array[i];
        }
        return c;
    }

    @Override
    public void changed(int i) {
    }

    @Override
    public Comparator<? super K> secondaryComparator() {
        return this.secondaryComparator;
    }
}

