/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.ints;

import it.unimi.dsi.fastutil.ints.IntArrayIndirectPriorityQueue;
import it.unimi.dsi.fastutil.ints.IntComparator;
import it.unimi.dsi.fastutil.ints.IntComparators;
import it.unimi.dsi.fastutil.ints.IntIndirectDoublePriorityQueue;

public class IntArrayIndirectDoublePriorityQueue
extends IntArrayIndirectPriorityQueue
implements IntIndirectDoublePriorityQueue {
    protected IntComparator secondaryComparator;

    public IntArrayIndirectDoublePriorityQueue(int[] refArray, int capacity, IntComparator c, IntComparator d) {
        super(refArray, capacity, c);
        this.secondaryComparator = d;
    }

    public IntArrayIndirectDoublePriorityQueue(int[] refArray, int capacity, IntComparator c) {
        super(refArray, capacity, c == null ? IntComparators.OPPOSITE_COMPARATOR : IntComparators.oppositeComparator(c));
    }

    public IntArrayIndirectDoublePriorityQueue(int[] refArray, int capacity) {
        this(refArray, capacity, null);
    }

    public IntArrayIndirectDoublePriorityQueue(int[] refArray, IntComparator c, IntComparator d) {
        this(refArray, refArray.length, c, d);
    }

    public IntArrayIndirectDoublePriorityQueue(int[] refArray, IntComparator c) {
        this(refArray, refArray.length, c);
    }

    public IntArrayIndirectDoublePriorityQueue(int[] refArray) {
        this(refArray, refArray.length, null);
    }

    public IntArrayIndirectDoublePriorityQueue(int[] refArray, int[] a, int size, IntComparator c, IntComparator d) {
        this(refArray, 0, c, d);
        this.array = a;
        this.size = size;
    }

    public IntArrayIndirectDoublePriorityQueue(int[] refArray, int[] a, IntComparator c, IntComparator d) {
        this(refArray, a, a.length, c, d);
    }

    public IntArrayIndirectDoublePriorityQueue(int[] refArray, int[] a, int size, IntComparator c) {
        this(refArray, 0, c);
        this.array = a;
        this.size = size;
    }

    public IntArrayIndirectDoublePriorityQueue(int[] refArray, int[] a, IntComparator c) {
        this(refArray, a, a.length, c);
    }

    public IntArrayIndirectDoublePriorityQueue(int[] refArray, int[] a, int size) {
        this(refArray, a, size, null);
    }

    public IntArrayIndirectDoublePriorityQueue(int[] refArray, int[] a) {
        this(refArray, a, a.length);
    }

    private int findSecondaryFirst() {
        int i = this.size;
        int firstIndex = --i;
        int first = this.refArray[this.array[firstIndex]];
        if (this.secondaryComparator == null) {
            while (i-- != 0) {
                if (this.refArray[this.array[i]] >= first) continue;
                firstIndex = i;
                first = this.refArray[this.array[firstIndex]];
            }
        } else {
            while (i-- != 0) {
                if (this.secondaryComparator.compare(this.refArray[this.array[i]], first) >= 0) continue;
                firstIndex = i;
                first = this.refArray[this.array[firstIndex]];
            }
        }
        return firstIndex;
    }

    private int findSecondaryLast() {
        int i = this.size;
        int lastIndex = --i;
        int last = this.refArray[this.array[lastIndex]];
        if (this.secondaryComparator == null) {
            while (i-- != 0) {
                if (last >= this.refArray[this.array[i]]) continue;
                lastIndex = i;
                last = this.refArray[this.array[lastIndex]];
            }
        } else {
            while (i-- != 0) {
                if (this.secondaryComparator.compare(last, this.refArray[this.array[i]]) >= 0) continue;
                lastIndex = i;
                last = this.refArray[this.array[lastIndex]];
            }
        }
        return lastIndex;
    }

    public int secondaryFirst() {
        return this.array[this.findSecondaryFirst()];
    }

    public int secondaryLast() {
        return this.array[this.findSecondaryLast()];
    }

    public int secondaryFront(int[] a) {
        int secondaryTop = this.refArray[this.array[this.findSecondaryFirst()]];
        int i = this.size;
        int c = 0;
        while (i-- != 0) {
            if (secondaryTop != this.refArray[this.array[i]]) continue;
            a[c++] = this.array[i];
        }
        return c;
    }

    public void changed(int i) {
    }

    public IntComparator secondaryComparator() {
        return this.secondaryComparator;
    }
}

