/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.floats;

import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.chars.AbstractCharCollection;
import it.unimi.dsi.fastutil.chars.AbstractCharIterator;
import it.unimi.dsi.fastutil.chars.CharCollection;
import it.unimi.dsi.fastutil.chars.CharIterator;
import it.unimi.dsi.fastutil.floats.AbstractFloatIterator;
import it.unimi.dsi.fastutil.floats.AbstractFloatSet;
import it.unimi.dsi.fastutil.floats.Float2CharMap;
import it.unimi.dsi.fastutil.floats.FloatIterator;
import it.unimi.dsi.fastutil.floats.FloatSet;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFloat2CharMap
implements Float2CharMap,
Serializable {
    protected char defRetValue;

    protected AbstractFloat2CharMap() {
    }

    @Override
    public void defaultReturnValue(char rv) {
        this.defRetValue = rv;
    }

    @Override
    public char defaultReturnValue() {
        return this.defRetValue;
    }

    @Override
    public char put(float key, char value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public char remove(float key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Character get(Object ok) {
        float k = ((Float)ok).floatValue();
        return this.containsKey(k) ? Character.valueOf(this.get(k)) : null;
    }

    @Override
    public Character put(Float ok, Character ov) {
        float k = ok.floatValue();
        char v = this.put(k, ov.charValue());
        return this.containsKey(k) ? Character.valueOf(v) : null;
    }

    @Override
    public Character remove(Object ok) {
        float k = ((Float)ok).floatValue();
        char v = this.remove(k);
        return this.containsKey(k) ? Character.valueOf(v) : null;
    }

    @Override
    public boolean containsValue(Object ov) {
        return this.containsValue(((Character)ov).charValue());
    }

    @Override
    public boolean containsKey(Object ok) {
        return this.containsKey(((Float)ok).floatValue());
    }

    @Override
    public boolean containsValue(char v) {
        return this.values().contains(v);
    }

    @Override
    public boolean containsKey(float k) {
        return this.keySet().contains(k);
    }

    @Override
    public void putAll(Map<? extends Float, ? extends Character> m) {
        int n = m.size();
        Iterator<Map.Entry<? extends Float, ? extends Character>> i = m.entrySet().iterator();
        if (m instanceof Float2CharMap) {
            while (n-- != 0) {
                Float2CharMap.Entry e = (Float2CharMap.Entry)i.next();
                this.put(e.getFloatKey(), e.getCharValue());
            }
        } else {
            while (n-- != 0) {
                Map.Entry<? extends Float, ? extends Character> e = i.next();
                this.put(e.getKey(), e.getValue());
            }
        }
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public FloatSet keySet() {
        return new AbstractFloatSet(){

            public boolean contains(float k) {
                return AbstractFloat2CharMap.this.containsKey(k);
            }

            public int size() {
                return AbstractFloat2CharMap.this.size();
            }

            public void clear() {
                AbstractFloat2CharMap.this.clear();
            }

            public FloatIterator iterator() {
                return new AbstractFloatIterator(){
                    final ObjectIterator<Map.Entry<Float, Character>> i;
                    {
                        this.i = AbstractFloat2CharMap.this.entrySet().iterator();
                    }

                    public float nextFloat() {
                        return ((Float2CharMap.Entry)this.i.next()).getFloatKey();
                    }

                    public boolean hasNext() {
                        return this.i.hasNext();
                    }
                };
            }
        };
    }

    @Override
    public CharCollection values() {
        return new AbstractCharCollection(){

            public boolean contains(char k) {
                return AbstractFloat2CharMap.this.containsValue(k);
            }

            public int size() {
                return AbstractFloat2CharMap.this.size();
            }

            public void clear() {
                AbstractFloat2CharMap.this.clear();
            }

            public CharIterator iterator() {
                return new AbstractCharIterator(){
                    final ObjectIterator<Map.Entry<Float, Character>> i;
                    {
                        this.i = AbstractFloat2CharMap.this.entrySet().iterator();
                    }

                    public char nextChar() {
                        return ((Float2CharMap.Entry)this.i.next()).getCharValue();
                    }

                    public boolean hasNext() {
                        return this.i.hasNext();
                    }
                };
            }
        };
    }

    @Override
    public int hashCode() {
        int h = 0;
        int n = this.size();
        ObjectIterator<Map.Entry<Float, Character>> i = this.entrySet().iterator();
        while (n-- != 0) {
            h += ((Object)((Map.Entry)i.next())).hashCode();
        }
        return h;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map m = (Map)o;
        if (m.size() != this.size()) {
            return false;
        }
        return this.entrySet().containsAll(m.entrySet());
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        ObjectIterator<Map.Entry<Float, Character>> i = this.entrySet().iterator();
        int n = this.size();
        boolean first = true;
        s.append("{");
        while (n-- != 0) {
            if (first) {
                first = false;
            } else {
                s.append(", ");
            }
            Float2CharMap.Entry e = (Float2CharMap.Entry)i.next();
            s.append(String.valueOf(e.getFloatKey()));
            s.append("=>");
            s.append(String.valueOf(e.getCharValue()));
        }
        s.append("}");
        return s.toString();
    }

    public static class BasicEntry
    implements Float2CharMap.Entry {
        protected float key;
        protected char value;

        public BasicEntry(Float key, Character value) {
            this.key = key.floatValue();
            this.value = value.charValue();
        }

        public BasicEntry(float key, char value) {
            this.key = key;
            this.value = value;
        }

        public Float getKey() {
            return Float.valueOf(this.key);
        }

        public float getFloatKey() {
            return this.key;
        }

        public Character getValue() {
            return Character.valueOf(this.value);
        }

        public char getCharValue() {
            return this.value;
        }

        public char setValue(char value) {
            throw new UnsupportedOperationException();
        }

        public Character setValue(Character value) {
            return Character.valueOf(this.setValue(value.charValue()));
        }

        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return this.key == ((Float)e.getKey()).floatValue() && this.value == ((Character)e.getValue()).charValue();
        }

        public int hashCode() {
            return HashCommon.float2int(this.key) ^ this.value;
        }

        public String toString() {
            return this.key + "->" + this.value;
        }
    }
}

