/*
 * Decompiled with CFR 0.152.
 */
package com.henry;

import com.henry.Cache;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;

public class TcpClient {
    private Socket socket;
    private String host;
    private int port;
    private int timeout;
    private DataOutputStream os;
    private DataInputStream is;
    private Cache cache;
    private boolean receive;
    private boolean connected;

    public TcpClient() {
    }

    public TcpClient(String host, int port) {
        this.host = host;
        this.port = port;
        this.timeout = 3000;
    }

    public TcpClient(String host, int port, int timeout) {
        this.host = host;
        this.port = port;
        this.timeout = timeout;
    }

    public boolean connect() {
        return this.connect(this.host, this.port, this.timeout);
    }

    public boolean connect(String host, int port, int timeout) {
        try {
            this.host = host;
            this.port = port;
            InetSocketAddress socketAddr = new InetSocketAddress(host, port);
            this.socket = new Socket();
            this.socket.connect(socketAddr, timeout);
            this.cache = new Cache();
            this.os = new DataOutputStream(this.socket.getOutputStream());
            this.is = new DataInputStream(this.socket.getInputStream());
            this.receive = true;
            this.startRead();
            this.connected = true;
            return true;
        }
        catch (SocketTimeoutException e) {
            System.err.println(e);
        }
        catch (IOException e) {
            System.err.println(e);
        }
        return false;
    }

    public boolean disconnect() {
        try {
            this.receive = false;
            this.is.close();
            this.socket.close();
            this.connected = false;
            return true;
        }
        catch (Exception e) {
            System.err.println(e);
            return false;
        }
    }

    public boolean sendData(byte[] data) {
        try {
            if (this.os != null) {
                this.os.write(data);
                this.os.flush();
                return true;
            }
        }
        catch (Exception e) {
            System.err.println(e);
        }
        return false;
    }

    private void startRead() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    while (TcpClient.this.receive) {
                        int i;
                        if (TcpClient.this.is != null && (i = TcpClient.this.is.available()) > 0) {
                            byte[] temp = new byte[i];
                            for (int j = 0; j < i; ++j) {
                                temp[j] = TcpClient.this.is.readByte();
                            }
                            TcpClient.this.cache.writeCache(temp);
                        }
                        Thread.sleep(5L);
                    }
                }
                catch (Exception e) {
                    System.err.println(e);
                }
            }
        }, "startRead").start();
    }

    public int availableData() {
        try {
            return this.cache != null ? this.cache.availableData() : 0;
        }
        catch (Exception e) {
            System.err.println(e);
            return 0;
        }
    }

    public byte[] receiveData(int size) {
        try {
            if (this.cache == null) {
                return null;
            }
            byte[] resp = this.cache.readCache(size);
            return resp;
        }
        catch (Exception e) {
            System.err.println(e);
            return null;
        }
    }

    public boolean isConnected() {
        return this.connected;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }
}

