CREATE TABLE nivel (
	id INTEGER PRIMARY KEY AUTOINCREMENT,
	dtupdated TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
	nome TEXT NOT NULL DEFAULT '' UNIQUE,
	descricao TEXT NOT NULL DEFAULT ''
);

CREATE TABLE equipamento_nivel (
	id INTEGER PRIMARY KEY AUTOINCREMENT,
	dtupdated TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
	nivel_id INTEGER NOT NULL,
	equipamento_id INTEGER NOT NULL,
	UNIQUE(nivel_id, equipamento_id)
);

CREATE TABLE pessoa_nivel (
	id INTEGER PRIMARY KEY AUTOINCREMENT,
	dtupdated TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
	pessoa_id INTEGER NOT NULL,
	nivel_id INTEGER NOT NULL,
	dtinicio TIMESTAMP NULL,
	dtfim TIMESTAMP NULL,
	UNIQUE(nivel_id, pessoa_id)
);

CREATE TABLE intervalo (
	id INTEGER PRIMARY KEY AUTOINCREMENT,
	dtupdated TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
	nome TEXT NOT NULL DEFAULT '' UNIQUE,
	inicio TIME NOT NULL,
	fim TIME NOT NULL,
	-- 1   - Todo dia
	-- 2   - Domingo
	-- 4   - Segunda
	-- 8   - Terça
	-- 16  - Quarta
	-- 32  - Quinta
	-- 64  - Sexta
	-- 128 - Sabado
	-- 256 - Feriado
	dia INTEGER NOT NULL DEFAULT 1,
	UNIQUE(inicio, fim, dia)
);

CREATE TABLE intervalo_equipamento_nivel (
	id INTEGER PRIMARY KEY AUTOINCREMENT,
	dtupdated TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP, 
	intervalo_id integer NOT NULL,
	equipamento_nivel_id integer NOT NULL,
	sentido char(1) DEFAULT 'A' NOT NULL,
	UNIQUE(intervalo_id, equipamento_nivel_id)
);