/*
 * Decompiled with CFR 0.152.
 */
package com.ifractal.whatsapp;

import com.ifractal.utils.Producer;
import com.ifractal.utils.TunnelListener;
import com.ifractal.utils.TunnelPeer;
import com.ifractal.utils.TunnelServer;
import com.ifractal.utils.Util;
import com.ifractal.utils.Verbosity;
import com.ifractal.whatsapp.Attendant;
import com.ifractal.whatsapp.Chat;
import com.ifractal.whatsapp.ChatBot;
import com.ifractal.whatsapp.Form;
import com.ifractal.whatsapp.FormBot;
import com.ifractal.whatsapp.FormBotListener;
import com.ifractal.whatsapp.FormField;
import com.ifractal.whatsapp.Person;
import com.ifractal.whatsapp.WhatsappBot;
import java.net.URL;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function6;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.simple.JSONObject;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0016\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u00022\u00020\u0004B\u001d\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\b\u00a2\u0006\u0002\u0010\tJ\u001c\u0010!\u001a\u00020\"2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00030$2\u0006\u0010%\u001a\u00020&J\u0012\u0010'\u001a\u00020(2\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003H\u0016J\"\u0010)\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0005\u001a\u00020\u00032\u000e\u0010#\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010$H\u0016J \u0010*\u001a\u00020\"2\b\u0010\u0005\u001a\u0004\u0018\u00010\u00032\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00030$H\u0016J\u001a\u0010+\u001a\u00020\"2\b\u0010\u0005\u001a\u0004\u0018\u00010\u00032\u0006\u0010,\u001a\u00020\u0003H\u0016J \u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020\u00142\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u00020&H\u0016J \u00103\u001a\u00020\"2\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u00020.2\u0006\u0010,\u001a\u00020\u0003H\u0016J(\u00103\u001a\u00020\"2\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u00020.2\u0006\u0010,\u001a\u00020\u00032\u0006\u00107\u001a\u00020.H\u0016J?\u00103\u001a\u00020\"2\u0006\u0010\u0005\u001a\u00020\u00032\f\u00108\u001a\b\u0012\u0004\u0012\u00020\u0003092\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00030$2\f\u0010:\u001a\b\u0012\u0004\u0012\u00020\u00030\bH\u0016\u00a2\u0006\u0002\u0010;R\u0014\u0010\n\u001a\u00020\u0003X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0016R \u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00030\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u0011\u0010\u001f\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u0016\u00a8\u0006<"}, d2={"Lcom/ifractal/whatsapp/WhatsappServer;", "Lcom/ifractal/whatsapp/WhatsappBot;", "Lcom/ifractal/utils/TunnelListener;", "", "Lcom/ifractal/whatsapp/FormBotListener;", "ctx", "", "args", "", "([J[Ljava/lang/String;)V", "PIPEURL", "getPIPEURL", "()Ljava/lang/String;", "SIINURL", "Ljava/net/URL;", "getSIINURL", "()Ljava/net/URL;", "setSIINURL", "(Ljava/net/URL;)V", "initialForm", "Lcom/ifractal/whatsapp/Form;", "getInitialForm", "()Lcom/ifractal/whatsapp/Form;", "prospectForm", "getProspectForm", "servers", "", "getServers", "()Ljava/util/List;", "setServers", "(Ljava/util/List;)V", "supportForm", "getSupportForm", "handler", "", "peer", "Lcom/ifractal/utils/TunnelPeer;", "jpack", "Lorg/json/simple/JSONObject;", "idle", "", "onAccept", "onClose", "onFail", "msg", "onFormFinished", "", "form", "client", "Lcom/ifractal/whatsapp/Person;", "resp", "onMessage", "prod", "Lcom/ifractal/utils/Producer;", "level", "code", "ts", "Lcom/ifractal/utils/TunnelServer;", "pack", "(Ljava/lang/String;Lcom/ifractal/utils/TunnelServer;Lcom/ifractal/utils/TunnelPeer;[Ljava/lang/String;)V", "ifractal"})
public final class WhatsappServer
extends WhatsappBot
implements TunnelListener<String>,
FormBotListener {
    @NotNull
    private final String PIPEURL;
    @NotNull
    private URL SIINURL;
    @NotNull
    private List<String> servers;
    @NotNull
    private final Form initialForm;
    @NotNull
    private final Form prospectForm;
    @NotNull
    private final Form supportForm;

    public WhatsappServer(@Nullable long[] ctx, @NotNull String[] args) {
        String[] stringArray;
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        super(ctx, args);
        this.PIPEURL = "https://stou.ifractal.com.br/whats_pipe.php";
        this.SIINURL = new URL("https://ifractal.com.br/");
        this.servers = CollectionsKt.emptyList();
        String srvs = Util.getValueFromArgs(args, "servers");
        if (srvs == null) {
            this.servers = CollectionsKt.listOf((Object)"127.0.0.1");
        } else {
            stringArray = new String[]{","};
            this.servers = StringsKt.split$default((CharSequence)srvs, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        }
        stringArray = new String[]{"SIINURL"};
        if (Util.checkKeysInArgs(args, stringArray)) {
            this.SIINURL = new URL(Util.getValueFromArgs(args, "SIINURL"));
        }
        this.initialForm = new Form(new FormField("inicial", null, "inicial"), null, null, 6, null);
        FormField ff = new FormField("nome", "Qual \u00e9 o seu nome ?", null);
        this.prospectForm = new Form(ff, "prospect", this.PIPEURL);
        this.prospectForm.add(new FormField("empresa", "Qual \u00e9 a sua empresa ?", null));
        this.prospectForm.add(new FormField("cnpj", "Qual \u00e9 o CNPJ da empresa ?", null));
        ff = new FormField("qtd_funcionarios", "Qual \u00e9 a quantidade de funcion\u00e1rios ?", null);
        this.prospectForm.add(ff);
        this.prospectForm.add(new FormField("email", "Qual \u00e9 a seu email ?", null));
        ff = new FormField("como_conheceu", null, "form_como_conheceu");
        String[] stringArray2 = new String[]{"Google", "47"};
        ff.addFromTo(stringArray2);
        stringArray2 = new String[]{"Indica\u00e7\u00e3o", "48"};
        ff.addFromTo(stringArray2);
        stringArray2 = new String[]{"LinkedIn", "49"};
        ff.addFromTo(stringArray2);
        this.prospectForm.add(ff);
        this.prospectForm.add(new FormField("fim", null, "form_prospect_end"));
        this.supportForm = new Form(new FormField("wait", "Aguarde um instante...  Um de nossos operadores j\u00e1 ir\u00e1 atende-lo.", null), null, null, 6, null);
    }

    @NotNull
    public final String getPIPEURL() {
        return this.PIPEURL;
    }

    @NotNull
    public final URL getSIINURL() {
        return this.SIINURL;
    }

    public final void setSIINURL(@NotNull URL uRL) {
        Intrinsics.checkNotNullParameter((Object)uRL, (String)"<set-?>");
        this.SIINURL = uRL;
    }

    @NotNull
    public final List<String> getServers() {
        return this.servers;
    }

    public final void setServers(@NotNull List<String> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.servers = list;
    }

    @NotNull
    public final Form getInitialForm() {
        return this.initialForm;
    }

    @NotNull
    public final Form getProspectForm() {
        return this.prospectForm;
    }

    @NotNull
    public final Form getSupportForm() {
        return this.supportForm;
    }

    @Override
    public int onFormFinished(@NotNull Form form, @NotNull Person client, @NotNull JSONObject resp) {
        Intrinsics.checkNotNullParameter((Object)form, (String)"form");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)resp, (String)"resp");
        if (form.getUrl().equals("")) {
            return 0;
        }
        this.sendMessage(5, "Form (" + form.getName() + "): -->" + resp.toJSONString() + "<--");
        Set set = resp.keySet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"resp.keys");
        Set keys = set;
        int n = 0;
        int n2 = 2 * keys.size() + 4;
        String[] stringArray = new String[n2];
        while (n < n2) {
            int n3 = n++;
            stringArray[n3] = "";
        }
        String[] args = stringArray;
        int i = 0;
        for (Object e : keys) {
            String k = String.valueOf(e);
            args[i++] = k;
            args[i++] = String.valueOf(resp.get((Object)k));
        }
        args[i++] = "dados";
        int n4 = i++;
        String string = resp.toJSONString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"resp.toJSONString()");
        args[n4] = string;
        args[i++] = "form_name";
        args[i++] = form.getName();
        String res = Util.sendFORM(this, new URL(form.getUrl()), args);
        if (res == null) {
            return -1;
        }
        this.sendMessage(5, res);
        return 0;
    }

    public final void handler(@NotNull TunnelPeer<String> peer, @NotNull JSONObject jpack) {
        Intrinsics.checkNotNullParameter(peer, (String)"peer");
        Intrinsics.checkNotNullParameter((Object)jpack, (String)"jpack");
        String[] ret2 = this.process(jpack, (Function6<? super String, ? super String, ? super String, ? super String, ? super String, ? super String, Boolean>)((Function6)new Function6<String, String, String, String, String, String, Boolean>(this){
            final /* synthetic */ WhatsappServer this$0;
            {
                this.this$0 = $receiver;
                super(6);
            }

            @NotNull
            public final Boolean invoke(@NotNull String wamid, @NotNull String name, @NotNull String wa_id, @NotNull String type, @NotNull String media_id, @NotNull String text) {
                Intrinsics.checkNotNullParameter((Object)wamid, (String)"wamid");
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                Intrinsics.checkNotNullParameter((Object)wa_id, (String)"wa_id");
                Intrinsics.checkNotNullParameter((Object)type, (String)"type");
                Intrinsics.checkNotNullParameter((Object)media_id, (String)"media_id");
                Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                Person to = null;
                Chat chat = this.this$0.getClientChat(wa_id);
                Attendant att = this.this$0.getAttendant(wa_id);
                if (chat == null && att == null) {
                    FormBot fb = this.this$0.addFormBot(wamid, new Person(name, wa_id, false, null, 0L, null, 60, null), this.this$0.getInitialForm(), this.this$0);
                    FormBot.sendNext$default(fb, this.this$0, null, null, 6, null);
                } else if (att != null) {
                    chat = this.this$0.getAttendantChat(wa_id);
                    if (chat != null) {
                        to = ((ChatBot)chat).getClient();
                        this.this$0.forward(to, type, media_id, text);
                    }
                } else if (chat != null) {
                    if (chat instanceof FormBot) {
                        FormBot fb = (FormBot)chat;
                        if (fb.getCurrent() == null) {
                            if (StringsKt.equals((String)text, (String)"Conhecer o software", (boolean)true)) {
                                FormBot fb2 = this.this$0.addFormBot(wamid, new Person(name, wa_id, false, null, 0L, null, 60, null), this.this$0.getProspectForm(), this.this$0);
                                FormBot.sendNext$default(fb2, this.this$0, null, null, 6, null);
                            } else if (StringsKt.equals((String)text, (String)"Precisa de suporte", (boolean)true)) {
                                FormBot fb3 = this.this$0.addFormBot(wamid, new Person(name, wa_id, false, null, 0L, null, 60, null), this.this$0.getSupportForm(), this.this$0);
                                FormBot.sendNext$default(fb3, this.this$0, null, null, 6, null);
                            } else {
                                this.this$0.addChat(wamid, new Person(name, wa_id, false, null, 0L, null, 60, null));
                            }
                        } else {
                            FormBot.sendNext$default(fb, this.this$0, text, null, 4, null);
                        }
                    } else if (!(chat instanceof ChatBot)) {
                        int qtd_att = this.this$0.getAttendants().size();
                        this.this$0.sendText(wa_id, "Temos " + qtd_att + " em atendimento. Por favor, aguarde.");
                    }
                }
                return true;
            }
        }));
        peer.send(ret2);
    }

    @Override
    @Nullable
    public String onAccept(@NotNull String ctx, @Nullable TunnelPeer<String> peer) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        if (peer == null) {
            return null;
        }
        String string = peer.getIP();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"peer.getIP()");
        String ip = string;
        this.sendMessage(5, "new peer: " + ip);
        String id = ip + " - " + System.currentTimeMillis();
        return id;
    }

    @Override
    public void onMessage(@NotNull String ctx, @NotNull TunnelServer<String> ts, @NotNull TunnelPeer<String> peer, @NotNull String[] pack) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter(ts, (String)"ts");
        Intrinsics.checkNotNullParameter(peer, (String)"peer");
        Intrinsics.checkNotNullParameter((Object)pack, (String)"pack");
        this.sendMessage(5, "##########################################");
        this.sendMessage(5, "## From: '" + peer.getIP() + "'");
        int n = pack.length;
        for (int i = 0; i < n; ++i) {
            String e = pack[i];
            this.sendMessage(5, "'" + e + "'");
        }
        this.sendMessage(5, "##########################################");
        if (pack.length < 2) {
            return;
        }
        Object obj = Util.getJSONFromArgs(pack, "json");
        if (obj != null) {
            JSONObject jpack = (JSONObject)obj;
            this.handler(peer, jpack);
        }
        peer.close();
    }

    @Override
    public void onFail(@Nullable String ctx, @NotNull String msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        this.sendMessage(2, msg);
    }

    @Override
    public boolean idle(@Nullable String ctx) {
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException ie) {
            return false;
        }
        return true;
    }

    @Override
    public void onClose(@Nullable String ctx, @NotNull TunnelPeer<String> peer) {
        Intrinsics.checkNotNullParameter(peer, (String)"peer");
    }

    @Override
    public void onMessage(@NotNull Producer prod, int level, @NotNull String msg, int code) {
        Intrinsics.checkNotNullParameter((Object)prod, (String)"prod");
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        Verbosity.println(msg);
    }

    @Override
    public void onMessage(@NotNull Producer prod, int level, @NotNull String msg) {
        Intrinsics.checkNotNullParameter((Object)prod, (String)"prod");
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        this.onMessage(prod, level, msg, 0);
    }
}

