/*
 * Decompiled with CFR 0.152.
 */
package com.ifractal.utils;

import com.ifractal.utils.Observer;
import com.ifractal.utils.Producer;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public abstract class Verbosity
extends Producer {
    public static final int NONE = 0;
    public static final int FATAL = 1;
    public static final int ERROR = 2;
    public static final int WARN = 3;
    public static final int INFO = 4;
    public static final int DEBUG = 5;
    private static ServerSocket ssock = null;
    public static HashMap<Socket, DataOutputStream> clients = null;
    private static boolean enableFileLog = false;
    private int verbosity = 0;
    private String id = "";

    public Verbosity() {
        this.verbosity = 4;
    }

    public Verbosity(long[] ctx, String[] args) {
        super(ctx, args);
    }

    public Verbosity(int level) {
        this.verbosity = level;
    }

    public Verbosity(Observer obs) {
        super(obs);
    }

    public static final int getLevel(String level) {
        if (level.equals("FATAL")) {
            return 1;
        }
        if (level.equals("ERROR")) {
            return 2;
        }
        if (level.equals("WARN")) {
            return 3;
        }
        if (level.equals("INFO")) {
            return 4;
        }
        if (level.equals("DEBUG")) {
            return 5;
        }
        return 0;
    }

    public static final String getLevel(int level) {
        switch (level) {
            case 0: {
                return "NONE";
            }
            case 1: {
                return "FATAL";
            }
            case 2: {
                return "ERROR";
            }
            case 3: {
                return "WARN";
            }
            case 4: {
                return "INFO";
            }
            case 5: {
                return "DEBUG";
            }
        }
        if (level > 5) {
            return "DEBUG";
        }
        return "---";
    }

    @Override
    public int sendMessage(int level, String msg) {
        int r = this.verbose_in(msg, level);
        return r;
    }

    public static void println(String msg) {
        Date now = new Date();
        try {
            Verbosity.verboseC(msg + "\n");
        }
        catch (UnsatisfiedLinkError ule) {
            System.out.print(now);
            System.out.println(msg);
        }
    }

    public static synchronized native void verboseC(String var0);

    private int verbose_in(String msg, int level) {
        super.sendMessage(level, msg);
        String classname = this.getClass().getName();
        String verb = Verbosity.getLevel(level);
        String txt = "|" + classname + "|" + this.id + "|" + verb + "| " + msg;
        int n = txt.length();
        if (this.verbosity >= level) {
            Verbosity.println(txt);
        }
        Verbosity.verboseAll(txt);
        return n;
    }

    public int verbose(String msg) {
        return this.verbose_in(msg, 0);
    }

    public int verboseFATAL(String msg) {
        return this.verbose_in(msg, 1);
    }

    public int verboseERROR(String msg) {
        return this.verbose_in(msg, 2);
    }

    public int verboseWARN(String msg) {
        return this.verbose_in(msg, 3);
    }

    public int verboseINFO(String msg) {
        return this.verbose_in(msg, 4);
    }

    public int verboseDEBUG(String msg) {
        return this.verbose_in(msg, 5);
    }

    public int verboseDEBUG(String msg, byte[] data) {
        int n = this.verbose_in(msg, 5);
        return n += this.verbose_in(Verbosity.hexlog(data), 5);
    }

    public int getLevel() {
        return this.verbosity;
    }

    public void setLevel(int level) {
        this.verbosity = level;
    }

    public void setId(String i) {
        this.id = i;
    }

    public static void enableFileOutput(String filename) {
        try {
            File file = new File(filename);
            if (!file.exists()) {
                file.createNewFile();
            }
            PrintStream p = new PrintStream(new FileOutputStream(filename, true));
            System.setOut(p);
            System.setErr(p);
            enableFileLog = true;
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static synchronized int verboseAll(String msg) {
        boolean closeIt = false;
        int i = 0;
        if (clients == null) {
            return 0;
        }
        Iterator<Map.Entry<Socket, DataOutputStream>> it = clients.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Socket, DataOutputStream> cli = it.next();
            Socket sock = cli.getKey();
            DataOutputStream dos = cli.getValue();
            try {
                dos.writeBytes(msg);
                dos.writeBytes("\r\n");
                dos.flush();
            }
            catch (IOException ioe) {
                closeIt = true;
            }
            if (closeIt) {
                try {
                    dos.close();
                    sock.close();
                    it.remove();
                    Verbosity.println("Client closed. Total: " + clients.size());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                closeIt = false;
            }
            ++i;
        }
        return i;
    }

    public static boolean serverRun(int port) {
        boolean alive = true;
        if (ssock != null) {
            return true;
        }
        if (Verbosity.checkPort(port)) {
            try {
                ssock = new ServerSocket(port);
            }
            catch (IOException iOException) {}
        } else {
            Verbosity.println("(Verbosity) Falha ao tentar abrir porta: " + port);
            return false;
        }
        clients = new HashMap();
        Verbosity.println("(Verbosity) Server running on port: " + port);
        while (alive) {
            try {
                Socket sock = ssock.accept();
                clients.put(sock, new DataOutputStream(sock.getOutputStream()));
                Verbosity.println("Client connected. Total: " + clients.size());
            }
            catch (IOException ioe) {
                Verbosity.println("(Verbosity) Falha socket.");
                alive = false;
            }
        }
        try {
            ssock.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    public static boolean checkPort(int port) {
        ServerSocket ssock = null;
        try {
            ssock = new ServerSocket(port);
            ssock.close();
        }
        catch (IOException ioe) {
            Verbosity.println("(Verbosity) Porta indisponivel: " + port);
            return false;
        }
        return true;
    }

    public static String hexlog(byte[] data) {
        int p;
        int k;
        int i;
        StringBuffer sb = new StringBuffer(data.length + " bytes\n");
        int n = data.length;
        int pad = 0;
        int llen = 16;
        char[] l = new char[llen];
        for (i = 0; i < n; ++i) {
            if (i > 0 && i % llen == 0) {
                for (k = 0; k < llen; ++k) {
                    p = i - llen + k;
                    l[k] = data[p] < 32 || data[p] > 126 ? 46 : (char)data[p];
                }
                sb.append("    " + new String(l) + "\n");
            }
            sb.append(String.format("%02X ", data[i]));
        }
        if (i % llen != 0) {
            pad = llen - i % llen;
            llen = i % llen;
        }
        for (k = 0; k < pad; ++k) {
            sb.append("   ");
        }
        for (k = 0; k < llen; ++k) {
            p = i - llen + k;
            l[k] = data[p] < 32 || data[p] > 126 ? 46 : (char)data[p];
        }
        sb.append("    " + new String(l, 0, llen) + "\n");
        return sb.toString();
    }
}

