/*
 * Decompiled with CFR 0.152.
 */
package com.ifractal.utils;

import com.ifractal.utils.Peer;
import com.ifractal.utils.TunnelListener;
import com.ifractal.utils.TunnelServer;
import com.ifractal.utils.Util;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Date;

public class Tunnel<T>
extends TunnelServer<T> {
    public static final String HOST = "74.50.60.155";
    public static final int PORT = 10999;
    public static final int HEADER_LEN = 12;
    public static final int PACK_MAX = 0x200000;
    protected final T context;
    protected Peer<T>[] peers = null;
    protected String siin_key = null;
    protected TunnelListener<T> listener;
    protected ServerSocket serversock = null;

    public Tunnel(T ctx, TunnelListener<T> tl) {
        super(null, tl);
        this.listener = tl;
        this.context = ctx;
    }

    @Override
    public boolean open(int port) {
        try {
            this.serversock = new ServerSocket(port);
        }
        catch (IOException ioe) {
            this.sendMessage(1, "Falha ao abrir porta: " + port + " - " + ioe.getMessage());
            return false;
        }
        return true;
    }

    @Override
    public void close() {
        for (Peer<T> p : this.peers) {
            if (p == null || !p.sock.isClosed()) continue;
            p.stop();
        }
        try {
            this.serversock.close();
        }
        catch (IOException e) {
            this.listener.onFail(this.context, "close fail");
        }
    }

    @Override
    public void run() {
        this.alive = true;
        try {
            while (this.alive) {
                Socket s = this.serversock.accept();
                Peer<T> peer = new Peer<T>(this.context, this, this.listener, s, TunnelServer.timeout);
                this.addPeer(peer);
                T id = this.listener.onAccept(this.context, peer);
                peer.resetContext(id);
                Thread th = new Thread(peer, "peer");
                th.start();
                this.alive = this.listener.idle(this.context);
            }
        }
        catch (SocketException se) {
            this.sendMessage(1, "Server closed - " + se.getMessage());
        }
        catch (IOException ioe) {
            this.sendMessage(1, "Falha accept - " + ioe.getMessage());
        }
        this.alive = false;
        this.listener.onFail(this.context, "Server closed");
    }

    private int findFreeSocket() {
        for (int i = 0; i < this.peers.length; ++i) {
            if (this.peers[i] == null) {
                return i;
            }
            if (!this.peers[i].sock.isClosed()) continue;
            return i;
        }
        return -1;
    }

    @Override
    protected synchronized int addPeer(Peer<T> peer) {
        int i;
        if (this.peers == null) {
            this.peers = new Peer[10];
        }
        if ((i = this.findFreeSocket()) >= 0) {
            this.peers[i] = peer;
            return i;
        }
        int len = 2 * this.peers.length;
        Peer[] tmp = new Peer[len];
        for (i = 0; i < this.peers.length; ++i) {
            tmp[i] = this.peers[i];
        }
        tmp[i] = peer;
        this.peers = tmp;
        return i;
    }

    @Override
    public synchronized int broadcast(String[] msg) {
        return this.broadcast(msg, null);
    }

    public synchronized int broadcast(String[] msg, Peer<T>[] except) {
        int n = 0;
        if (msg == null || this.peers == null) {
            return -1;
        }
        for (Peer<T> peer : this.peers) {
            if (except != null) {
                for (Peer<T> e : except) {
                    if (e != peer) continue;
                    peer = null;
                    break;
                }
            }
            if (peer == null || peer.sock.isClosed()) continue;
            peer.sendMessage(msg);
            ++n;
        }
        return n;
    }

    private static byte[] getKey() {
        long now = new Date().getTime();
        byte[] key = new byte[8];
        for (int i = 0; i < key.length; ++i) {
            key[i] = (byte)(now >> 8 * i & 0xFFL);
        }
        return key;
    }

    public static ByteBuffer encodePack(byte[] key, byte[] data) {
        byte[] cipher = Util.processRC4(1, key, data);
        int total = 4 + key.length + cipher.length;
        ByteBuffer buf = ByteBuffer.allocate(total);
        buf.order(ByteOrder.LITTLE_ENDIAN);
        buf.putInt(cipher.length);
        buf.put(key);
        buf.put(cipher);
        return buf;
    }

    public static ByteBuffer buildMessage(byte[][] args) {
        if (args == null) {
            return null;
        }
        int total = 5 + 5 * args.length;
        for (byte[] arg : args) {
            if (arg == null) continue;
            total += arg.length;
        }
        ByteBuffer buf = ByteBuffer.allocate(total);
        buf.order(ByteOrder.LITTLE_ENDIAN);
        buf.putInt(total - 4);
        buf.put((byte)args.length);
        for (byte[] arg : args) {
            if (arg != null) {
                buf.putInt(arg.length + 1);
                buf.put(arg);
            } else {
                buf.putInt(1);
            }
            buf.put((byte)0);
        }
        ((Buffer)buf).rewind();
        byte[] data = new byte[buf.remaining()];
        buf.get(data);
        byte[] key = Tunnel.getKey();
        buf = Tunnel.encodePack(key, data);
        return buf;
    }

    public static ByteBuffer buildMessage(String[] args) {
        byte[] data;
        if (args == null) {
            return null;
        }
        int total = 5 + 5 * args.length;
        for (String arg : args) {
            if (arg == null) continue;
            total += arg.getBytes().length;
        }
        ByteBuffer buf = ByteBuffer.allocate(total);
        buf.order(ByteOrder.LITTLE_ENDIAN);
        buf.putInt(total - 4);
        buf.put((byte)args.length);
        for (String arg : args) {
            if (arg != null) {
                data = arg.getBytes();
                buf.putInt(data.length + 1);
                buf.put(data);
            } else {
                buf.putInt(1);
            }
            buf.put((byte)0);
        }
        ((Buffer)buf).rewind();
        data = new byte[buf.remaining()];
        buf.get(data);
        byte[] key = Tunnel.getKey();
        buf = Tunnel.encodePack(key, data);
        return buf;
    }

    public static byte[][] decodeBytePack(byte[] pack, byte[] key) {
        byte[] data = Util.processRC4(2, key, pack);
        ByteBuffer tmp = ByteBuffer.allocate(data.length);
        tmp.order(ByteOrder.LITTLE_ENDIAN);
        ((Buffer)tmp).clear();
        tmp.put(data);
        ((Buffer)tmp).rewind();
        byte[] len = new byte[1];
        tmp.get(len);
        if (len[0] < 1) {
            return null;
        }
        byte[][] msg = new byte[len[0]][];
        byte[] term = new byte[1];
        for (int i = 0; i < len[0]; ++i) {
            int subtotal = tmp.getInt() - 1;
            msg[i] = new byte[subtotal];
            tmp.get(msg[i], 0, subtotal);
            tmp.get(term);
        }
        return msg;
    }

    public static String[] decodePack(byte[] pack, byte[] key) {
        byte[] data = Util.processRC4(2, key, pack);
        ByteBuffer tmp = ByteBuffer.allocate(data.length);
        tmp.order(ByteOrder.LITTLE_ENDIAN);
        ((Buffer)tmp).clear();
        tmp.put(data);
        ((Buffer)tmp).rewind();
        tmp.getInt();
        byte[] len = new byte[1];
        tmp.get(len);
        if (len[0] < 1) {
            return null;
        }
        String[] msg = new String[len[0]];
        try {
            for (int i = 0; i < len[0]; ++i) {
                int subtotal = tmp.getInt();
                byte[] content = new byte[subtotal];
                tmp.get(content, 0, subtotal);
                msg[i] = new String(content, 0, subtotal - 1);
            }
        }
        catch (RuntimeException re) {
            return null;
        }
        return msg;
    }
}

