/*
 * Decompiled with CFR 0.152.
 */
package com.ifractal.utils;

import com.ifractal.utils.Tunnel;
import com.ifractal.utils.TunnelClientListener;
import com.ifractal.utils.TunnelPeer;
import com.ifractal.utils.TunnelServer;
import com.ifractal.utils.Util;
import com.ifractal.utils.Verbosity;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.nio.Buffer;
import java.nio.ByteBuffer;

public class Peer<T>
extends TunnelPeer<T> {
    public static final int interval = 1000;
    protected final TunnelClientListener<T> listener;
    public final Socket sock;
    public final long timeout;
    public InputStream is;
    public OutputStream os;
    protected boolean alive = false;

    public Peer(T ctx, TunnelServer<T> srv, TunnelClientListener<T> tl, Socket s, long to) {
        super(ctx, srv, tl);
        this.listener = tl;
        this.sock = s;
        this.timeout = to;
    }

    @Override
    public String getIP() {
        return this.sock.getInetAddress().toString();
    }

    @Override
    public int send(String[] msg) {
        int r = this.sendMessage(msg);
        return r;
    }

    @Override
    public void close() {
        this.close(null);
    }

    protected void close(String msg) {
        try {
            if (this.is != null) {
                this.is.close();
            }
            if (this.os != null) {
                this.os.close();
            }
            this.sock.close();
            if (msg != null) {
                this.sendMessage(3, msg);
            }
        }
        catch (IOException e) {
            this.sendMessage(3, e.getMessage());
        }
    }

    protected void setReady(byte[] key, byte[] cipher) {
    }

    @Override
    public void run() {
        String err;
        block9: {
            err = null;
            byte[] header = new byte[12];
            byte[] key = new byte[8];
            long elapsed = 0L;
            try {
                this.is = this.sock.getInputStream();
                this.alive = true;
                do {
                    elapsed = 0L;
                    while (this.is.available() < header.length) {
                        Thread.sleep(1000L);
                        if (this.timeout <= 0L || ++elapsed <= this.timeout) continue;
                        err = "Timeout.";
                        this.stop();
                        break block9;
                    }
                    int n = this.is.read(header);
                    if (n < header.length) break;
                    System.arraycopy(header, 4, key, 0, 8);
                    int size = header[0] & 0xFF;
                    for (int i = 1; i < 4; ++i) {
                        size += (header[i] & 0xFF) * (256 * i);
                    }
                    if (size < 5 || size > 0x200000) {
                        err = "Mensagem inconsistente.";
                        break;
                    }
                    byte[] cipher = new byte[size];
                    while (this.is.available() < size) {
                        Thread.sleep(100L);
                    }
                    n = this.is.read(cipher);
                    if (n < cipher.length) break;
                    String[] msg = Tunnel.decodePack(cipher, key);
                    if (msg == null) {
                        err = "Falha ao tentar decodificar...";
                        break;
                    }
                    this.listener.onMessage(this.context, this.server, this, msg);
                } while (this.alive);
            }
            catch (InterruptedException ie) {
                err = ie.getMessage();
            }
            catch (IOException ioe) {
                err = ioe.getMessage();
            }
        }
        this.listener.onClose(this.context, this);
        this.alive = false;
        this.close(err);
    }

    public void stop() {
        this.alive = false;
    }

    public int sendMessage(String from, String[] in) {
        String to = Util.getValueFromArgs(in, "from");
        String[] msg = in;
        if (to != null) {
            msg = Util.setValueInArgs(msg, "to", to);
        }
        msg = from == null ? Util.setValueInArgs(msg, "from", "") : Util.setValueInArgs(msg, "from", from);
        return this.sendMessage(msg);
    }

    public int sendMessage(String[] msg) {
        ByteBuffer buf = Tunnel.buildMessage(msg);
        return this.sendMessage(buf);
    }

    public int sendMessage(ByteBuffer buf) {
        if (buf == null) {
            return -1;
        }
        ((Buffer)buf).flip();
        int len = buf.remaining();
        byte[] out = new byte[len];
        buf.get(out);
        try {
            if (this.os == null) {
                this.os = this.sock.getOutputStream();
            }
            this.os.write(out);
        }
        catch (IOException io) {
            this.close(io.getMessage());
            return -2;
        }
        return len;
    }

    public static <T> Socket connect(T ctx, TunnelClientListener<T> tl, String host, int port) {
        return Peer.connect(ctx, tl, host, port, 0L);
    }

    public static <T> Socket connect(T ctx, TunnelClientListener<T> tl, String host, int port, long to) {
        Socket sock = null;
        try {
            sock = new Socket(host, port);
            Peer<T> peer = new Peer<T>(ctx, null, tl, sock, to);
            tl.onConnect(ctx, peer);
            Thread th = new Thread(peer, "peer");
            th.start();
            return sock;
        }
        catch (IOException ioe) {
            Verbosity.println(ioe.getMessage());
            return null;
        }
    }

    public static final void main(String[] args) {
        if (args.length < 1) {
            System.err.println("\nUso:\n\tjava Tunnel <CHAVE> <IP> <PORT>\n");
            System.err.println("Exemplo:\n\tjava Tunnel xyz 74.50.6.155 50000\n");
            System.exit(1);
        }
    }
}

