/*
 * Decompiled with CFR 0.152.
 */
package com.ifractal.utils;

import com.ifractal.utils.Util;
import com.ifractal.utils.Verbosity;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class Getopts {
    public static void parseStringArray(HashMap<String, String> c, String[] args) {
        int i = 0;
        while (i + 1 < args.length) {
            if (args[i] != null) {
                c.put(args[i], args[i + 1]);
            }
            i += 2;
        }
    }

    public static void parseCommandLine(HashMap<String, String> c, String[] args) {
        int i = 0;
        while (i + 1 < args.length) {
            if (args[i].startsWith("--")) {
                String key = args[i].substring(2);
                c.put(key, args[i + 1]);
            }
            i += 2;
        }
    }

    public static void parseIniFile(HashMap<String, String> c, String filename) {
        try {
            String line;
            BufferedReader br = new BufferedReader(new FileReader(filename));
            while ((line = br.readLine()) != null) {
                int p = line.indexOf("=");
                if (p < 1) continue;
                String key = line.substring(0, p);
                String val = line.substring(p + 1);
                if (!c.containsKey(key)) continue;
                c.put(key, val);
            }
            br.close();
        }
        catch (FileNotFoundException fnfe) {
            System.err.println("Falha ao tentar abrir: '" + filename + "'.");
        }
        catch (IOException ioe) {
            System.err.println("Falha ao tentar ler: '" + filename + "'.");
        }
    }

    public static void saveIniFile(HashMap<String, String> c, String filename) throws IOException {
        SimpleDateFormat fmt = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
        BufferedWriter bw = new BufferedWriter(new FileWriter(filename));
        bw.write("# Gerado em ");
        bw.write(fmt.format(new Date()));
        bw.newLine();
        bw.newLine();
        Set<Map.Entry<String, String>> set = c.entrySet();
        for (Map.Entry<String, String> map : set) {
            bw.write(map.getKey().toString() + "=" + map.getValue().toString());
            bw.newLine();
        }
        bw.close();
    }

    public static int getIntValue(HashMap<String, String> c, String field) {
        int val = 0;
        if (!c.containsKey(field)) {
            return 0;
        }
        try {
            val = Integer.parseInt(c.get(field));
        }
        catch (NumberFormatException nfe) {
            return 0;
        }
        return val;
    }

    @Deprecated
    public static String httpPerform(Verbosity log, String ip, String port, String path, String query, String linefeed, String contentType, byte[] data) throws IOException {
        String proto = "http";
        if (port.equals("443")) {
            proto = "https";
        }
        return Getopts.httpPerform(log, proto, ip, port, path, query, linefeed, contentType, data);
    }

    @Deprecated
    public static String httpPerform(Verbosity log, String proto, String ip, String port, String path, String query, String linefeed, String contentType, byte[] data) throws IOException {
        String url = proto + "://" + ip + ":" + port + "/" + path + "?" + query;
        URL obj = new URL(url);
        return Getopts.httpPerform(log, obj, linefeed, contentType, data);
    }

    @Deprecated
    public static String httpPerform(Verbosity log, URL url, String linefeed, String contentType, byte[] data) throws IOException {
        return Getopts.httpPerform(log, url, linefeed, contentType, data, 0);
    }

    @Deprecated
    public static String httpPerform(Verbosity log, URL url, String linefeed, String contentType, byte[] data, int qtyLines) throws IOException {
        return Util.sendPOST(log, url, data, contentType);
    }

    @Deprecated
    public static String httpSendFile(Verbosity log, String ip, String port, String path, String query, String linefeed, byte[] data) throws IOException {
        String resp = Getopts.httpPerform(log, ip, port, path, query, linefeed, "multipart/form-data", data);
        return resp;
    }

    @Deprecated
    public static String httpSendFile(Verbosity log, URL url, String linefeed, byte[] data) throws IOException {
        String resp = Getopts.httpPerform(log, url, linefeed, "multipart/form-data", data);
        return resp;
    }

    @Deprecated
    public static String httpGetContent(Verbosity log, String ip, String port, String path, String query, String linefeed) throws IOException {
        String res = Getopts.httpPerform(log, ip, port, path, query, linefeed, "application/x-www-form-urlencoded", null);
        return res;
    }

    @Deprecated
    public static String httpGetContent(Verbosity log, URL url, String linefeed) throws IOException {
        String res = Getopts.httpPerform(log, url, linefeed, "application/x-www-form-urlencoded", null);
        return res;
    }

    @Deprecated
    public static JSONArray httpJsonPost(Verbosity log, String ip, String port, String path, String query, String jsondata) throws IOException {
        String proto = "http";
        if (port.equals("443")) {
            proto = "https";
        }
        String url = proto + "://" + ip + ":" + port + "/" + path + "?" + query;
        URL obj = new URL(url);
        return Getopts.httpJsonPost(log, obj, jsondata);
    }

    @Deprecated
    public static JSONArray httpJsonPost(Verbosity log, URL url, String jsondata) throws IOException {
        String content;
        JSONArray json = null;
        byte[] data = null;
        if (jsondata != null) {
            data = jsondata.getBytes();
        }
        if ((content = Getopts.httpPerform(log, url, null, "application/json", data)) == null) {
            return null;
        }
        String resp = content.replaceAll("'", " ");
        JSONParser parser = new JSONParser();
        try {
            Object jsonobj = parser.parse(resp);
            if (jsonobj instanceof JSONObject) {
                json = new JSONArray();
                json.add(jsonobj);
            } else {
                json = (JSONArray)jsonobj;
            }
        }
        catch (NumberFormatException nfe) {
            log.verboseFATAL("Falha: '" + nfe.getMessage() + "'\nResponse: '" + resp + "'");
        }
        catch (ParseException pe) {
            json = new JSONArray();
            json.add((Object)resp);
        }
        return json;
    }

    @Deprecated
    public static JSONArray httpGetJSON(Verbosity log, String ip, String port, String path, String query) throws IOException {
        JSONArray res = Getopts.httpJsonPost(log, ip, port, path, query, null);
        return res;
    }

    @Deprecated
    public static String getHTTPResponse(HttpURLConnection con, String linefeed, int qtyLines) throws IOException {
        String inputLine;
        BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));
        StringBuffer response = new StringBuffer();
        int count = 0;
        while ((inputLine = in.readLine()) != null) {
            response.append(inputLine);
            if (linefeed != null) {
                response.append(linefeed);
            }
            if (qtyLines <= 0 || ++count < qtyLines) continue;
        }
        in.close();
        return response.toString();
    }
}

