/*
 * Decompiled with CFR 0.152.
 */
package com.ifractal.utils;

import com.ifractal.utils.IfaceFilePerform;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;

public class FiledirIter {
    File dir;

    public FiledirIter(String path) {
        this.dir = new File(path);
    }

    public int perform(IfaceFilePerform cb, String prefix, String suffix, Object user_data) {
        File[] files = null;
        int n = 0;
        try {
            if (!this.dir.isDirectory()) {
                return 0;
            }
            files = this.dir.listFiles();
            Arrays.sort(files, new Comparator<File>(){

                @Override
                public int compare(File f2, File f1) {
                    return Long.valueOf(f2.lastModified()).compareTo(f1.lastModified());
                }
            });
            for (File file : files) {
                String filename = file.getName();
                if (!filename.startsWith(prefix) || !filename.endsWith(suffix)) continue;
                ++n;
                cb.filePerform(this.dir.getAbsolutePath() + File.separator + filename, user_data);
            }
        }
        catch (FileNotFoundException fnfe) {
            System.err.println(fnfe.getMessage());
        }
        catch (IOException ioe) {
            System.err.println(ioe.getMessage());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return n;
    }

    public static final void main(String[] args) throws IOException {
        if (args.length < 1) {
            System.err.println("\nUso:");
            System.err.println("\tshell$ java " + FiledirIter.class.getName() + " <DIR>\n");
            System.exit(1);
        }
        IfaceFilePerform fp = new IfaceFilePerform(){

            @Override
            public int filePerform(String filename, Object user_data) throws IOException {
                System.out.println(filename);
                return 0;
            }
        };
        FiledirIter fi = new FiledirIter(args[0]);
        fi.perform(fp, "", "", null);
    }
}

