/*
 * Decompiled with CFR 0.152.
 */
package com.ifractal.ifponto;

import com.ifractal.utils.IfaceJSONIter;
import com.ifractal.utils.Util;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.LinkedList;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class ZK_iFractal {
    public static String[] getLines(String filename) throws IOException {
        File file = new File(filename);
        FileReader fr = new FileReader(file);
        BufferedReader br = new BufferedReader(fr);
        String[] ret2 = ZK_iFractal.getLines(br);
        fr.close();
        return ret2;
    }

    public static String[] getLines(BufferedReader br) throws IOException {
        LinkedList<String> lines = new LinkedList<String>();
        String line = null;
        while ((line = br.readLine()) != null) {
            lines.add(line);
        }
        String[] arr = new String[lines.size()];
        for (int i = 0; i < lines.size(); ++i) {
            arr[i] = (String)lines.get(i);
        }
        return arr;
    }

    public static int process(JSONArray jusers) {
        IfaceJSONIter iter2 = new IfaceJSONIter(){

            @Override
            public int perform(JSONObject juser, Object[] pars, int[] c) {
                if (!juser.containsKey((Object)"nome")) {
                    return 0;
                }
                String codigo = juser.get((Object)"codigo").toString();
                String nome = juser.get((Object)"nome").toString();
                JSONArray temps = (JSONArray)juser.get((Object)"templates");
                int qty_bio = temps.size();
                System.out.println(codigo + ";" + nome + ";" + qty_bio);
                c[0] = c[0] + 1;
                return 0;
            }
        };
        int[] c = new int[]{0};
        Util.jsonIter(jusers, iter2, null, c);
        return c[0];
    }

    public static boolean checkCard(String ifponto, String zk) {
        String[] cards;
        boolean found = false;
        for (String card : cards = ifponto.split(" / ")) {
            while (((String)zk).length() < 5) {
                zk = "0" + (String)zk;
            }
            if (!card.endsWith((String)zk)) continue;
            found = true;
        }
        return found;
    }

    public static boolean checkName(String ifponto_name, String zk_name) {
        return ZK_iFractal.checkName(ifponto_name, zk_name, 1);
    }

    public static boolean checkName(String ifponto_name, String zk_name, int qty) {
        String ifponto = ifponto_name.trim();
        String zk = zk_name.trim();
        String a = ifponto;
        String b = zk;
        if (zk.length() > ifponto.length()) {
            a = zk;
            b = ifponto;
        }
        String[] as = a.split(" ");
        String[] bs = b.split(" ");
        if (!a.startsWith(b)) {
            int i = 0;
            for (i = 0; i < qty && i < as.length && i < bs.length && as[i].equalsIgnoreCase(bs[i]); ++i) {
            }
            return i >= qty;
        }
        return true;
    }

    public static void addDelete(JSONArray fixed, String codigo) {
        JSONObject del = new JSONObject();
        del.put((Object)"codigo", (Object)codigo);
        del.put((Object)"tipo", (Object)"excluir");
        fixed.add((Object)del);
    }

    public static void addUser(JSONObject juser, JSONArray fixed, String codigo, String nome, String card) {
        for (String k : new String[]{"uid", "disable", "verify", "starttime", "endtime", "privilege", "group"}) {
            juser.remove((Object)k);
        }
        juser.put((Object)"codigo", (Object)codigo);
        juser.put((Object)"nome", (Object)nome);
        juser.put((Object)"cracha", (Object)card);
        fixed.add((Object)juser);
    }

    public static int process(final String cmd, JSONArray jusers, String[] csv, String opt) {
        IfaceJSONIter iter2 = new IfaceJSONIter(){

            @Override
            public int perform(JSONObject juser, Object[] pars, int[] c) {
                String[] f = (String[])pars[0];
                JSONArray fixed = (JSONArray)pars[1];
                String card = juser.get((Object)"codigo").toString();
                String nome = juser.get((Object)"nome").toString();
                if (card.length() < 3) {
                    return 0;
                }
                if (nome.length() < 2) {
                    return 0;
                }
                if (cmd.equals("D")) {
                    if (!ZK_iFractal.checkCard(f[3], card)) {
                        return 0;
                    }
                    if (!ZK_iFractal.checkName(f[1], nome, 3)) {
                        return 0;
                    }
                    System.err.println(f[0] + " | " + f[1] + " | (" + f[3] + ") ; " + card + " | " + nome);
                    ZK_iFractal.addDelete(fixed, card);
                    return 1;
                }
                if (cmd.equals("N")) {
                    if (!ZK_iFractal.checkName(f[1], nome, 3)) {
                        return 0;
                    }
                    if (ZK_iFractal.checkCard(f[3], card)) {
                        return 0;
                    }
                    System.err.println(f[0] + " | " + f[1] + " | (" + f[3] + ") ; " + card + " | " + nome);
                    ZK_iFractal.addDelete(fixed, card);
                    ZK_iFractal.addUser(juser, fixed, f[0], f[1], card);
                    return 1;
                }
                if (cmd.equals("F")) {
                    if (!ZK_iFractal.checkCard(f[3], card)) {
                        return 0;
                    }
                    if (!ZK_iFractal.checkName(f[1], nome)) {
                        return 0;
                    }
                    System.err.println(f[0] + " | " + f[1] + " | (" + f[3] + ") ; " + card + " | " + nome);
                    ZK_iFractal.addDelete(fixed, card);
                    ZK_iFractal.addUser(juser, fixed, f[0], f[1], card);
                    return 1;
                }
                return 0;
            }
        };
        int[] i = new int[]{0};
        int qty_csv_fail = 0;
        String[] csv_fail = new String[csv.length];
        JSONArray fixed = new JSONArray();
        for (String ln : csv) {
            String[] fields = ln.split(";");
            if (fields.length < 5) continue;
            int indice = Util.jsonIter(jusers, iter2, new Object[]{fields, fixed}, i);
            if (indice < jusers.size()) {
                jusers.remove(indice);
                continue;
            }
            csv_fail[qty_csv_fail] = ln;
            ++qty_csv_fail;
        }
        if (opt.equals("RJSON")) {
            System.out.println(jusers);
            return 0;
        }
        if (opt.equals("RCSV")) {
            for (String ln : csv_fail) {
                if (ln == null) break;
                System.out.println(ln);
            }
            return 0;
        }
        if (opt.equals("C")) {
            System.out.println(fixed);
        }
        return 0;
    }

    public static int perform(String cmd, String jsonname, String csvname, String opt) {
        JSONParser parser = new JSONParser();
        FileReader fr = null;
        JSONArray jusers = null;
        int r = 0;
        try {
            if (jsonname == null) {
                return -1;
            }
            if (csvname == null) {
                r = ZK_iFractal.process(jusers);
                return r;
            }
            String[] csv = ZK_iFractal.getLines(csvname);
            fr = new FileReader(jsonname);
            jusers = (JSONArray)parser.parse((Reader)fr);
            fr.close();
            ZK_iFractal.process(cmd, jusers, csv, opt);
        }
        catch (ParseException pe) {
            System.err.println(jsonname + " - Erro em " + pe.getPosition());
            return 1;
        }
        catch (FileNotFoundException fnfe) {
            System.err.println(fnfe.getMessage());
            return 2;
        }
        catch (IOException ioe) {
            System.err.println(ioe.getMessage());
            return 3;
        }
        return 0;
    }

    public static final void main(String[] args) {
        if (args.length < 4) {
            System.err.println("\nUso:\n\tshell$ java -classpath ifractal.jar com.ifractal.ifponto.ZK <CMD> <CSV ativos|demitidos> <JSON> <OPT>");
            System.err.println("\nOnde <CMD>:");
            System.err.println("\tD - lista de demitidos");
            System.err.println("\tF - lista de ativos alinhados por cartao e nome");
            System.err.println("\tN - lista de ativos alinhados somente por nome");
            System.err.println("\nOnde <OPT>:");
            System.err.println("\tC - retorna o JSON com os encontrados (convergentes)");
            System.err.println("\tRJSON - retorna o JSON com os que n\u00e3o foram cruzados (restantes)");
            System.err.println("\tRCSV - retorna o csv com os que n\u00e3o foram cruzados (restantes)");
            System.err.println("\n");
            System.exit(1);
        }
        if (args[1].equals("-")) {
            ZK_iFractal.perform(args[0], args[2], null, args[3]);
        } else {
            ZK_iFractal.perform(args[0], args[2], args[1], args[3]);
        }
    }
}

