/*
 * Decompiled with CFR 0.152.
 */
package com.ifractal.ifponto;

import com.ifractal.ifponto.DeviceExtended;
import com.ifractal.ifponto.IFPONTO_config;
import com.ifractal.ifponto.ZK;
import com.ifractal.utils.IfaceJSONIter;
import com.ifractal.utils.Util;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class ZKRE
extends DeviceExtended<Object> {
    public static final int[] crcTbl = new int[]{0, 40961};
    public static final int UPDATE_USER = 100;
    public static final int DELETE_USER = 101;
    public static final byte START_BLOCK_1 = -86;
    public static final byte START_BLOCK_2 = 1;
    public static final byte CMD_LOG_REQUEST = 8;
    public static final byte CMD_RESPONSE = -56;
    public static final byte CMD_INIT = 118;
    public static final byte CMD_FINALIZE = 2;
    public static final byte CMD_SET_INFO = 3;
    public static final byte CMD_GET_INFO = 4;
    public static final byte CMD_GET_EVENTS = 8;
    public static final byte CMD_SEND_USER = 7;
    public static final byte CMD_REFRESH = 25;
    public static final byte SIZE_EVENTS_COLUMNS = 7;
    public static final byte COLUMN_EVENTS_CARD_NO = 1;
    public static final byte COLUMN_EVENTS_PIN = 2;
    public static final byte COLUMN_EVENTS_VERIFIED = 3;
    public static final byte COLUMN_EVENTS_DOOR_ID = 4;
    public static final byte COLUMN_EVENTS_EVENT_TYPE = 5;
    public static final byte COLUMN_EVENTS_IN_OUT_STATE = 6;
    public static final byte COLUMN_EVENTS_TIME_SECOND = 7;
    public static final byte SIZE_COLUMNS_USERS = 7;
    public static final byte COLUMN_USERS_CARD_NO = 1;
    public static final byte COLUMN_USERS_PIN = 2;
    public static final byte COLUMN_USERS_PASSWORD = 3;
    public static final byte COLUMN_USERS_GROUP = 4;
    public static final byte COLUMN_USERS_START_TIME = 5;
    public static final byte COLUMN_USERS_END_TIME = 6;
    public static final byte COLUMN_USERS_SUPER_AUTHORIZE = 7;
    public static final byte CARD_LEN = 2;
    public static final byte PIN_LEN = 2;
    public static final byte START_TIME_LEN = 4;
    public static final byte END_TIME_LEN = 4;
    public static final byte END_BYTE = 85;
    public static final int HEADER_START_1 = 0;
    public static final int HEADER_START_2 = 1;
    public static final int HEADER_CMD = 2;
    public static final int HEADER_LLEN = 3;
    public static final int HEADER_HLEN = 4;
    public static final int HEADER_LSESS = 5;
    public static final int HEADER_HSESS = 6;
    public static final int HEADER_SEQ = 7;
    public static final int HEADER_LEN = 8;
    public static final int CHECKSUM_LEN = 2;
    public static final int DATA_INIT_EVENTS = 19;
    protected Socket sock;
    protected BufferedInputStream is = null;
    protected BufferedOutputStream os = null;
    protected byte[] session = new byte[]{0, 0};
    protected int sequence = 1;

    public static void checksum(byte[] pack) {
        int crc = 0;
        if (pack == null) {
            return;
        }
        int i = 1;
        int sz = pack.length - 4;
        while (sz > 0) {
            crc ^= Byte.toUnsignedInt(pack[i]);
            for (int j = 0; j < 8; ++j) {
                crc = crc >> 1 ^ crcTbl[crc & 1];
            }
            --sz;
            ++i;
        }
        pack[pack.length - 2] = (byte)(crc >> 8);
        pack[pack.length - 2 - 1] = (byte)(crc & 0xFF);
        pack[pack.length - 1] = 85;
    }

    public ZKRE(JSONObject c) {
        super(c);
    }

    public int getDataLength(byte[] pack) {
        if (pack == null || pack.length < 8) {
            return 0;
        }
        int dataLen = Byte.toUnsignedInt(pack[3]) + (Byte.toUnsignedInt(pack[4]) << 8);
        return dataLen;
    }

    public byte[] recv() throws IOException {
        byte[] header = new byte[8];
        int dataLen = 0;
        this.is.read(header);
        dataLen = this.getDataLength(header);
        if (dataLen < 1) {
            return null;
        }
        byte[] resp = new byte[dataLen + 8];
        for (int i = 0; i < 8; ++i) {
            resp[i] = header[i];
        }
        this.is.read(resp, 8, dataLen);
        return resp;
    }

    public byte[] sendRecv(byte cmd, byte[] data) {
        int i;
        byte[] header = new byte[8];
        int packLen = 8 + data.length + 2 + 1;
        byte[] pack = new byte[packLen];
        int dataLen = data.length + 2 + 1;
        byte[] resp = null;
        header[0] = -86;
        header[1] = 1;
        header[2] = cmd;
        header[3] = (byte)(0xFF & dataLen);
        header[4] = (byte)(0xFF & dataLen >> 8);
        header[5] = this.session[0];
        header[6] = this.session[1];
        header[7] = (byte)(this.sequence & 0xFF);
        ++this.sequence;
        for (i = 0; i < 8; ++i) {
            pack[i] = header[i];
        }
        int j = 0;
        while (j < data.length) {
            pack[i] = data[j];
            ++j;
            ++i;
        }
        ZKRE.checksum(pack);
        try {
            this.os.write(pack);
            this.os.flush();
            resp = this.recv();
        }
        catch (IOException ioe) {
            this.verboseERROR("Falha comunicacao: " + ioe.getMessage());
            return null;
        }
        return resp;
    }

    public int connect() {
        try {
            this.sock = new Socket(this.ip, Integer.parseInt(this.port));
            this.is = new BufferedInputStream(this.sock.getInputStream());
            this.os = new BufferedOutputStream(this.sock.getOutputStream());
        }
        catch (IOException ioe) {
            this.verboseERROR("Falha ao tentar conectar " + this.ip + ":" + this.port + " - " + ioe.getMessage());
            return -1;
        }
        return 0;
    }

    public int disconnect() {
        if (this.sock == null) {
            return -1;
        }
        try {
            this.os.close();
            this.is.close();
            this.sock.close();
            this.sock = null;
            this.session[0] = 0;
            this.session[1] = 0;
            this.sequence = 0;
        }
        catch (IOException e) {
            this.verboseERROR("Falha comunicacao " + e.getMessage());
            return -2;
        }
        return 0;
    }

    public int enable() {
        if (this.sock == null || !this.sock.isConnected()) {
            return -1;
        }
        byte[] resp = this.sendRecv((byte)118, new byte[]{0});
        if (resp == null) {
            this.verboseERROR("Falha de comunica\u00e7\u00e3o");
            return -2;
        }
        this.session[0] = resp[5];
        this.session[1] = resp[6];
        return 0;
    }

    public int disable() {
        if (this.sock == null || !this.sock.isConnected()) {
            return -1;
        }
        this.sendRecv((byte)2, new byte[]{0});
        this.session[0] = 0;
        this.session[1] = 0;
        return 0;
    }

    @Override
    public Date getTime() {
        JSONObject jconf = new JSONObject();
        this.getInfo(jconf);
        if (!jconf.containsKey((Object)"DateTime")) {
            return null;
        }
        int zkt = Integer.parseInt(jconf.get((Object)"DateTime").toString());
        Date dt = ZK.decodeZKTime(zkt);
        return dt;
    }

    @Override
    public boolean setTime(int diff) {
        int r = this.connect();
        if (r == 0) {
            r = this.enable();
        }
        if (r != 0) {
            this.verboseERROR("Falha ao tentar conectar " + this.ip + ":" + this.port);
            return false;
        }
        Calendar dt = Calendar.getInstance();
        dt.add(11, diff);
        int zkt = ZK.encodeZKTime(dt);
        String content = "DateTime=" + zkt;
        byte[] bcontent = content.getBytes();
        byte[] data = new byte[bcontent.length + 1];
        int k = 0;
        data[k++] = 0;
        for (byte b : bcontent) {
            data[k++] = b;
        }
        this.sendRecv((byte)3, data);
        this.disable();
        this.disconnect();
        return true;
    }

    @Override
    public void getInfo(JSONObject jinfo) {
        String[] pars;
        String[] fields = new String[]{"DateTime", "~Platform", "~SerialNumber", "~DeviceName", "MAC", "FirmVer"};
        int r = this.connect();
        if (r == 0) {
            r = this.enable();
        }
        if (r != 0) {
            this.verboseERROR("Falha ao tentar conectar " + this.ip + ":" + this.port);
            return;
        }
        int i = 0;
        Object content = fields[i++];
        while (i < fields.length) {
            content = (String)content + "," + fields[i];
            ++i;
        }
        byte[] bcontent = ((String)content).getBytes();
        byte[] data = new byte[bcontent.length + 1];
        int k = 0;
        data[k++] = 0;
        for (byte b : bcontent) {
            data[k++] = b;
        }
        byte[] resp = this.sendRecv((byte)4, data);
        int dataLen = this.getDataLength(resp);
        String info = new String(resp, 9, dataLen - 4);
        for (String par : pars = info.split(",")) {
            String[] kv = par.split("=");
            jinfo.put((Object)kv[0], (Object)kv[1]);
        }
        this.disable();
        this.disconnect();
    }

    @Override
    public JSONArray getUsers() {
        return null;
    }

    @Override
    public int getEvents(JSONArray offs) {
        int r = this.connect();
        if (r != 0) {
            return -1;
        }
        r = this.enable();
        if (r != 0) {
            return -2;
        }
        SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        byte[] dataGetEvents = new byte[]{0, 5, 7, 1, 2, 3, 4, 5, 6, 7, 1, 1, 0};
        byte[] resp = this.sendRecv((byte)8, dataGetEvents);
        int i = 18;
        String[] name = new String[]{"cracha", "codigo", null, null, "auth", null, "datahora"};
        while (i < resp.length - 7) {
            JSONObject reg = new JSONObject();
            for (int j = 0; j < 7; ++j) {
                int qtdBytes = resp[i];
                ++i;
                int val = 0;
                String strVal = "";
                for (int k = 0; k < qtdBytes; ++k) {
                    val += Byte.toUnsignedInt(resp[i + k]) << 8 * k;
                }
                strVal = Integer.toString(val);
                i += qtdBytes;
                if (name[j] == null || name[j].equals("codigo")) continue;
                if (name[j].equals("auth")) {
                    strVal = val >= 0 && val <= 19 || val >= 200 && val <= 253 ? "L" : "B";
                } else if (name[j].equals("datahora")) {
                    int ts = val;
                    Date dt = ZK.decodeZKTime(ts);
                    strVal = fmt.format(dt);
                }
                reg.put((Object)name[j], (Object)strVal);
            }
            if (reg.get((Object)"cracha").equals("0")) continue;
            offs.add((Object)reg);
        }
        byte[] dataRefresh = new byte[]{0, 5};
        resp = this.sendRecv((byte)25, dataRefresh);
        this.disable();
        this.disconnect();
        return 0;
    }

    public List<byte[]> buildSendUserData(JSONObject juser, final int type) {
        IfaceJSONIter iter2 = new IfaceJSONIter(){

            @Override
            public int perform(JSONObject jcard, Object[] pars, int[] c) {
                if (type == 100 && jcard.containsKey((Object)"ativo") && jcard.get((Object)"ativo").toString().equals("0")) {
                    return 0;
                }
                if (!jcard.containsKey((Object)"nro") || jcard.get((Object)"nro") == null) {
                    return 0;
                }
                List dataList = (List)pars[0];
                String card = jcard.get((Object)"nro").toString();
                if (card.equals("")) {
                    return 0;
                }
                if (card.length() > 5) {
                    card = card.substring(card.length() - 5);
                }
                byte[] dataHeader = new byte[]{0, 1, 7, 1, 2, 3, 4, 5, 6, 7};
                int iCard = Integer.parseInt(card);
                int iPin = iCard & 0x1FF;
                int startTime = 0;
                int endTime = Integer.MAX_VALUE;
                if (type == 101) {
                    endTime = ZK.encodeZKTime(new Date());
                }
                int dataSendUserLen = dataHeader.length + 7 + 2 + 2 + 4 + 4;
                byte[] dataSendUser = new byte[dataSendUserLen];
                for (int i = 0; i < dataHeader.length; ++i) {
                    dataSendUser[i] = dataHeader[i];
                }
                dataSendUser[i++] = 2;
                dataSendUser[i++] = (byte)(iCard & 0xFF);
                dataSendUser[i++] = (byte)(iCard >> 8);
                dataSendUser[i++] = 2;
                dataSendUser[i++] = (byte)(iPin & 0xFF);
                dataSendUser[i++] = (byte)(iPin >> 8);
                dataSendUser[i++] = 0;
                dataSendUser[i++] = 0;
                dataSendUser[i++] = 4;
                dataSendUser[i++] = (byte)(startTime & 0xFF);
                dataSendUser[i++] = (byte)(startTime >> 8);
                dataSendUser[i++] = (byte)(startTime >> 16);
                dataSendUser[i++] = (byte)(startTime >> 24);
                dataSendUser[i++] = 4;
                dataSendUser[i++] = (byte)(endTime & 0xFF);
                dataSendUser[i++] = (byte)(endTime >> 8);
                dataSendUser[i++] = (byte)(endTime >> 16);
                dataSendUser[i++] = (byte)(endTime >> 24);
                dataSendUser[i] = 0;
                dataList.add(dataSendUser);
                c[0] = c[0] + 1;
                return 0;
            }
        };
        if (!juser.containsKey((Object)"nro_cartao") || juser.get((Object)"nro_cartao") == null) {
            return null;
        }
        int[] count = new int[]{0};
        JSONArray nros = (JSONArray)juser.get((Object)"nro_cartao");
        ArrayList<byte[]> dataList = new ArrayList<byte[]>();
        Util.jsonIter(nros, iter2, new Object[]{dataList}, count);
        if (count[0] < 1) {
            return null;
        }
        return dataList;
    }

    @Override
    public Object openContext() {
        int r = this.connect();
        if (r != 0) {
            return null;
        }
        r = this.enable();
        if (r != 0) {
            return null;
        }
        return this.sock;
    }

    @Override
    public void closeContext(Object ctx) {
        this.disable();
        this.disconnect();
    }

    @Override
    public int updateUser(Object ctx, JSONObject user) {
        List<byte[]> listDataSendUser = this.buildSendUserData(user, 100);
        if (listDataSendUser == null || listDataSendUser.isEmpty()) {
            return IFPONTO_config.valueOf((String)"FALTA_PARAMETRO").codigo;
        }
        for (byte[] dataSendUser : listDataSendUser) {
            this.sendRecv((byte)7, dataSendUser);
        }
        return 0;
    }

    @Override
    public int deleteUser(Object ctx, JSONObject user) {
        List<byte[]> listDataSendUser = this.buildSendUserData(user, 101);
        if (listDataSendUser == null || listDataSendUser.isEmpty()) {
            return IFPONTO_config.valueOf((String)"FALTA_PARAMETRO").codigo;
        }
        for (byte[] dataSendUser : listDataSendUser) {
            this.sendRecv((byte)7, dataSendUser);
        }
        return 0;
    }

    @Override
    public int sendUserBio(Object ctx, JSONObject juser) {
        return 0;
    }

    @Override
    public int deleteUserBio(Object ctx, JSONObject user) {
        return 0;
    }

    @Override
    public int getUserBio(Object ctx, JSONObject user) {
        return 0;
    }
}

