/*
 * Decompiled with CFR 0.152.
 */
package com.ifractal.ifponto;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;

class VetronicContext {
    String ip;
    int port;
    Socket sock = null;
    InputStream is = null;
    OutputStream os = null;

    public VetronicContext(String ip, String port) {
        this.ip = ip;
        this.port = Integer.parseInt(port);
    }

    public void open() throws IOException, InterruptedException {
        this.sock = new Socket(this.ip, this.port);
        this.is = this.sock.getInputStream();
        this.os = this.sock.getOutputStream();
        this.sendRecv("1");
    }

    public void close() throws IOException {
        this.send("50");
        this.is.close();
        this.os.close();
        this.sock.close();
    }

    public String recv() throws IOException, InterruptedException {
        Object res = "";
        while (true) {
            if (this.is.available() < 1) {
                Thread.sleep(100L);
                continue;
            }
            byte[] b = new byte[1];
            this.is.read(b);
            if (b[0] == 13) {
                return res;
            }
            res = (String)res + new String(b);
            if (!this.sock.isConnected()) break;
        }
        return res;
    }

    public void send(String msg) throws IOException {
        String pack = String.format("%s;%d;%s;\r", "99", 1, msg);
        byte[] out = pack.getBytes();
        this.os.write(out);
    }

    public String sendRecv(String msg) throws IOException, InterruptedException {
        this.send(msg);
        return this.recv();
    }
}

