/*
 * Decompiled with CFR 0.152.
 */
package com.ifractal.ifponto;

import com.ifractal.ifponto.BatchRequest;
import com.ifractal.utils.Verbosity;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URL;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.imageio.ImageIO;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class UserWebRequest
extends Verbosity {
    public static HashMap<Socket, UserWebRequest> onlineRequest = null;
    private static ServerSocket ssock = null;
    public static String IF_HTTP_200 = "HTTP/1.1 200 OK\r\nServer: SIIN\r\nConnection: Keep-Alive\r\nKeep-Alive: timeout=15, max=99\r\nAccept-Ranges: bytes\r\n";
    public static String HTTP_STREAM_HEADER = "Connection: close\r\nContent-Type: multipart/x-mixed-replace;boundary=BoundaryString\r\n\r\n";
    public static String HTTP_JSON_HEADER = "Connection: close\r\nContent-Type: text/json\r\n";
    public static String IF_HTTP_500 = "HTTP/1.1 500 Internal Error\r\nServer: UserWebRequest\r\nContent-Type: text/plain\r\n\r\nErro interno.";
    private Socket sock;
    private BufferedReader br;
    private DataOutputStream dos;
    private String[] headers;
    private String query;
    private String path;
    private HashMap<String, String> GET = null;
    public long start;
    public String nro;
    private State state = State.WAIT;
    private int state_ref = 0;
    private static Object[][] state_image;
    private static final int state_image_width = 250;
    private static final int state_image_height = 250;
    private static final int AnimationPeriod = 250;

    private static synchronized int initImages(UserWebRequest uwr) throws IOException {
        int len = State.values().length;
        int h = 250;
        if (state_image != null) {
            return state_image.length;
        }
        URL url = uwr.getClass().getResource("/com/ifractal/utils/sprites.png");
        BufferedImage img = ImageIO.read(url);
        state_image = new Object[][]{{img, new Point(0, 0 * h)}, {img, new Point(0, 1 * h)}, {img, new Point(0, 2 * h)}, {img, new Point(0, 3 * h)}, {img, new Point(0, 4 * h)}, {img, new Point(0, 0 * h)}};
        if (state_image.length < len) {
            uwr.verboseERROR("State sem imagem correspondente.");
        } else if (state_image.length > len) {
            uwr.verboseWARN("Imagem sem correspondencia.");
        }
        return state_image.length;
    }

    public UserWebRequest(Socket s, BufferedReader b) {
        try {
            this.sock = s;
            this.br = b;
            this.dos = new DataOutputStream(this.sock.getOutputStream());
            this.nro = "";
        }
        catch (IOException ioe) {
            this.dos = null;
            this.state = State.FAIL;
            return;
        }
        this.start = System.currentTimeMillis();
        this.headers = new String[20];
        this.processHeaders(this.headers);
        this.processGET();
        this.showParams();
        try {
            if (this.GET == null) {
                this.sendQueue();
                this.state = State.CLOSED;
                return;
            }
            this.state = !this.GET.containsKey("users") || !this.GET.containsKey("nro") ? State.ONLINE : State.WAIT;
            UserWebRequest.initImages(this);
        }
        catch (IOException ioe) {
            this.verboseERROR("Falha ao enviar response: " + ioe.getMessage());
            this.state = State.CLOSED;
        }
    }

    private int processHeaders(String[] headers) {
        int k = 0;
        try {
            k = 0;
            while (k + 1 < headers.length) {
                String line;
                headers[k] = line = this.br.readLine();
                if (line.length() >= 5) {
                    ++k;
                    continue;
                }
                break;
            }
        }
        catch (IOException ioe) {
            this.state = State.FAIL;
            return -1;
        }
        return k;
    }

    private void processGET() {
        String line = this.headers[0];
        int start = line.indexOf("/");
        int end = line.indexOf("?");
        if (end < 0) {
            end = line.indexOf(" ", start);
            this.path = line.substring(start, end);
            this.query = "";
            return;
        }
        this.path = line.substring(start, end);
        start = end + 1;
        end = line.indexOf(" ", start);
        this.query = line.substring(start, end);
        this.GET = new HashMap();
        String[] elem = this.query.split("&");
        int qty = elem.length;
        String[] pair = new String[]{"", ""};
        for (int i = 0; i < qty; ++i) {
            try {
                pair = elem[i].split("=");
                String key = URLDecoder.decode(pair[0], "UTF-8");
                String val = "";
                if (pair.length > 1) {
                    val = URLDecoder.decode(pair[1], "UTF-8");
                }
                this.GET.put(key, val);
                continue;
            }
            catch (UnsupportedEncodingException uee) {
                this.state = State.FAIL;
                this.verboseERROR("Falha ao tentar converter: " + pair[0] + " = " + pair[1]);
                this.verboseERROR(uee.getMessage());
            }
        }
        if (this.GET.containsKey("nro")) {
            this.nro = this.GET.get("nro");
        }
    }

    public void showParams() {
        int i = 0;
        while (this.headers[i] != null) {
            this.verboseDEBUG(this.headers[i]);
            ++i;
        }
        this.verboseDEBUG("path: " + this.path);
        this.verboseDEBUG("query: " + this.query);
        if (this.GET == null) {
            return;
        }
        for (Map.Entry<String, String> pair : this.GET.entrySet()) {
            this.verboseDEBUG(pair.getKey() + " = " + pair.getValue());
        }
    }

    public State getState() {
        return this.state;
    }

    public void setState(State s) {
        if (this.state == State.CLOSED) {
            return;
        }
        this.state = s;
    }

    public JSONArray getUsers() {
        if (!this.GET.containsKey("users")) {
            this.state = State.ONLINE;
            return null;
        }
        String val = this.GET.get("users");
        JSONParser parser = new JSONParser();
        try {
            JSONArray users;
            Object obj = parser.parse(val);
            if (obj instanceof JSONObject) {
                users = new JSONArray();
                users.add(obj);
            } else {
                users = (JSONArray)obj;
            }
            BatchRequest.cleanASCII(users);
            this.verboseDEBUG(users.toString());
            return users;
        }
        catch (ParseException pe) {
            this.verboseERROR("Erro ao tentar abrir JSON Users: " + pe.getMessage());
            this.state = State.FAIL;
        }
        catch (ClassCastException cce) {
            this.verboseERROR("Erro ao tentar abrir JSON Users: " + cce.getMessage());
            this.verboseERROR(val);
            this.state = State.FAIL;
        }
        return null;
    }

    public void close() {
        try {
            this.dos.writeBytes("--BoundaryString--\r\n\r\n");
            this.br.close();
            this.dos.close();
            this.sock.close();
        }
        catch (IOException ioe) {
            this.state = State.CLOSED;
            this.verboseERROR(ioe.getMessage());
        }
    }

    protected int sendQueue() throws IOException {
        UserWebRequest uwr = null;
        JSONArray queue = new JSONArray();
        int n = 0;
        Iterator<Map.Entry<Socket, UserWebRequest>> it = onlineRequest.entrySet().iterator();
        n = 0;
        while (it.hasNext()) {
            Map.Entry<Socket, UserWebRequest> cli = it.next();
            uwr = cli.getValue();
            JSONArray usrs = uwr.getUsers();
            if (usrs == null) continue;
            JSONObject elem = new JSONObject();
            elem.put((Object)"nro", (Object)uwr.nro);
            elem.put((Object)"users", (Object)usrs);
            queue.add((Object)elem);
            ++n;
        }
        String json = queue.toJSONString();
        this.dos.writeBytes(IF_HTTP_200);
        this.dos.writeBytes(HTTP_JSON_HEADER);
        this.dos.writeBytes("Content-Length: " + json.length());
        this.dos.writeBytes("\r\n\r\n" + json);
        this.dos.flush();
        this.br.close();
        this.dos.close();
        this.sock.close();
        return n;
    }

    public void sendImage() {
        int state_pos = this.state.ordinal();
        if (this.state == State.CLOSED) {
            return;
        }
        if (state_pos > 0 && state_pos < State.DONE.ordinal()) {
            return;
        }
        try {
            if (this.state == State.FAIL) {
                this.dos.writeBytes(IF_HTTP_500);
                this.dos.flush();
                this.state = State.CLOSED;
                return;
            }
            BufferedImage sprite = (BufferedImage)state_image[state_pos][0];
            Point pt = (Point)state_image[state_pos][1];
            int mod = sprite.getWidth(null) / 250;
            int m = this.state_ref++ % mod;
            int x = pt.x + m * 250;
            int w = 250;
            int h = 250;
            if (m != mod - 1 && this.state != State.ONLINE) {
                return;
            }
            this.dos.writeBytes(IF_HTTP_200);
            this.dos.writeBytes(HTTP_STREAM_HEADER);
            this.dos.flush();
            this.dos.writeBytes("--BoundaryString\r\n");
            this.dos.writeBytes("Content-type: image/png\r\n");
            this.dos.writeBytes("\r\n");
            BufferedImage img = sprite.getSubimage(x, pt.y, w, h);
            ImageIO.write((RenderedImage)img, "png", this.dos);
            this.dos.writeBytes("\r\n\r\n");
            this.state = State.CLOSED;
        }
        catch (IOException ioe) {
            this.state = State.CLOSED;
            this.verboseERROR(ioe.getMessage());
        }
    }

    private static synchronized int onlineRequestClean() {
        int i = 0;
        int k = 0;
        int q = onlineRequest.size();
        long now = System.currentTimeMillis();
        Socket[] keys = new Socket[q];
        if (onlineRequest == null) {
            return 0;
        }
        for (Map.Entry<Socket, UserWebRequest> cli : onlineRequest.entrySet()) {
            Socket sock = cli.getKey();
            UserWebRequest uwr = cli.getValue();
            if (uwr.getState().ordinal() >= State.DONE.ordinal()) {
                if (uwr.getState() != State.CLOSED) continue;
                uwr.close();
                keys[k++] = sock;
                continue;
            }
            if (uwr.getState().ordinal() == State.ONLINE.ordinal() || now - uwr.start <= 300000L) continue;
            uwr.setState(State.FAIL);
        }
        for (i = 0; i < k; ++i) {
            onlineRequest.remove(keys[i]);
        }
        if (k > 0) {
            Verbosity.println("Requests Alive: " + onlineRequest.size());
        }
        return onlineRequest.size();
    }

    private static synchronized int onlineRequestPut(Socket sock, UserWebRequest uwr) {
        if (onlineRequest == null) {
            return 0;
        }
        onlineRequest.put(sock, uwr);
        return onlineRequest.size();
    }

    public static synchronized UserWebRequest onlineRequestGetByNro(String nro) {
        UserWebRequest uwr = null;
        if (onlineRequest == null) {
            return null;
        }
        for (Map.Entry<Socket, UserWebRequest> cli : onlineRequest.entrySet()) {
            uwr = cli.getValue();
            cli.getKey();
            if (!uwr.nro.equals(nro) || uwr.getState() != State.WAIT) continue;
            uwr.setState(State.SENDING);
            return uwr;
        }
        return null;
    }

    private static synchronized int onlineRequestSendImage() {
        UserWebRequest uwr = null;
        int n = 0;
        if (onlineRequest == null) {
            return 0;
        }
        Iterator<Map.Entry<Socket, UserWebRequest>> it = onlineRequest.entrySet().iterator();
        n = 0;
        while (it.hasNext()) {
            Map.Entry<Socket, UserWebRequest> cli = it.next();
            uwr = cli.getValue();
            uwr.sendImage();
            ++n;
        }
        return n;
    }

    private static boolean webRequestHandler(Socket sock) {
        try {
            Thread.sleep(1000L);
            BufferedReader br = new BufferedReader(new InputStreamReader(sock.getInputStream()));
            if (!br.ready()) {
                return false;
            }
            UserWebRequest uwr = new UserWebRequest(sock, br);
            UserWebRequest.onlineRequestPut(sock, uwr);
        }
        catch (IOException ioe) {
            Verbosity.println("Falha ao tentar processar requisicao Web.");
        }
        catch (InterruptedException ie) {
            Verbosity.println("Thread error: requisicao Web.");
        }
        return true;
    }

    public static void webServerRun(Verbosity verb, int port) {
        boolean alive = true;
        if (ssock != null) {
            return;
        }
        if (Verbosity.checkPort(port)) {
            try {
                ssock = new ServerSocket(port);
            }
            catch (IOException iOException) {}
        } else {
            return;
        }
        if (Verbosity.clients == null) {
            Verbosity.clients = new HashMap();
        }
        if (onlineRequest == null) {
            onlineRequest = new HashMap();
        }
        verb.verboseINFO("(UserWebRequest) Server running on port: " + port);
        Runnable r = new Runnable(){

            @Override
            public void run() {
                try {
                    while (true) {
                        long start = System.currentTimeMillis();
                        UserWebRequest.onlineRequestSendImage();
                        long elapsed = System.currentTimeMillis() - start;
                        if (elapsed < 250L) {
                            Thread.sleep(250L - elapsed);
                        }
                        UserWebRequest.onlineRequestClean();
                    }
                }
                catch (InterruptedException ie) {
                    Verbosity.println("Error: " + ie.getMessage());
                    return;
                }
            }
        };
        new Thread(r).start();
        while (alive) {
            try {
                Socket sock = ssock.accept();
                if (UserWebRequest.webRequestHandler(sock)) continue;
                Verbosity.clients.put(sock, new DataOutputStream(sock.getOutputStream()));
            }
            catch (IOException ioe) {
                Verbosity.println("(UserWebRequest) Falha socket.");
                alive = false;
            }
        }
        try {
            ssock.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static enum State {
        ONLINE,
        WAIT,
        SENDING,
        DONE,
        FAIL,
        CLOSED;

    }
}

