/*
 * Decompiled with CFR 0.152.
 */
package com.ifractal.ifponto;

import com.ifractal.ifponto.IfpontoDB;
import com.ifractal.utils.IfaceJSONIter;
import com.ifractal.utils.Observer;
import com.ifractal.utils.Util;
import java.util.Calendar;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class IfpontoDBAcesso
extends IfpontoDB {
    public static final int ANYDAY = 1;
    public static final int SUNDAY = 2;
    public static final int MONDAY = 4;
    public static final int TUESDAY = 8;
    public static final int WEDNESDAY = 16;
    public static final int THURSDAY = 32;
    public static final int FRIDAY = 64;
    public static final int SATURDAY = 128;
    public static final int HOLIDAY = 256;

    public IfpontoDBAcesso(String[] args, Observer obs) {
        super(args, obs);
    }

    public boolean checkIntervalo(String dev_numero, String codigo_ifponto) {
        IfaceJSONIter iter2 = new IfaceJSONIter(){

            @Override
            public int perform(JSONObject jintervalo, Object[] pars, int[] count) {
                int dia = Integer.parseInt(jintervalo.get((Object)"dia").toString());
                int inicio = Integer.parseInt(jintervalo.get((Object)"inicio").toString());
                int fim = Integer.parseInt(jintervalo.get((Object)"fim").toString());
                Calendar calendar = Calendar.getInstance();
                int dow = calendar.get(7);
                if ((dia & 1) == 0 && (dia & 1 << dow) == 0) {
                    IfpontoDBAcesso.this.sendMessage(5, "Negado: dia nao autorizado.");
                    return 0;
                }
                int now = 3600 * calendar.get(11) + 60 * calendar.get(12) + calendar.get(13);
                if (now < inicio || now > fim) {
                    IfpontoDBAcesso.this.sendMessage(5, "Negado: horario nao autorizado.");
                    return 0;
                }
                count[0] = count[0] + 1;
                return 0;
            }
        };
        String[] vals = new String[]{dev_numero, codigo_ifponto};
        JSONArray jintervalos = this.sess.execute("Select_intervalo", vals, null, null);
        int[] count = new int[]{0};
        Util.jsonIter(jintervalos, iter2, null, count);
        return count[0] != 0;
    }

    public int countDuplaPassagem(String dev_numero, String codigo_ifponto) {
        IfaceJSONIter iter2 = new IfaceJSONIter(){

            @Override
            public int perform(JSONObject jintervalo, Object[] pars, int[] count) {
                count[0] = count[0] + 1;
                return 0;
            }
        };
        String[] vals = new String[]{dev_numero, codigo_ifponto};
        JSONArray jintervalos = this.sess.execute("Select_dupla_passagem", vals, null, null);
        int[] count = new int[]{0};
        Util.jsonIter(jintervalos, iter2, null, count);
        return count[0];
    }

    public boolean insertEventoOnline(String dev_numero, String codigo_ifponto) {
        String[] values = new String[]{codigo_ifponto, dev_numero, codigo_ifponto};
        JSONArray ret2 = this.sess.execute("Insert_evento_online", values, null, null);
        if (ret2 == null) {
            return false;
        }
        this.sendMessage(5, "Insert Online: -->" + ret2.toString() + "<--");
        return true;
    }
}

