/*
 * Decompiled with CFR 0.152.
 */
package com.ifractal.ifponto;

import com.ifractal.ifponto.ControlID;
import com.ifractal.ifponto.Device;
import com.ifractal.ifponto.IFPONTO_config;
import com.ifractal.utils.IfaceJSONIter;
import com.ifractal.utils.Util;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class IDClass
extends ControlID {
    public IDClass(JSONObject config) {
        super(config);
    }

    protected String getCPF(JSONObject juser) {
        if (!juser.containsKey((Object)"cpf")) {
            return "";
        }
        try {
            return juser.get((Object)"cpf").toString();
        }
        catch (NumberFormatException nfe) {
            return "";
        }
    }

    protected long getPIS(JSONObject juser) {
        if (!juser.containsKey((Object)"pis")) {
            return 0L;
        }
        try {
            return Long.parseLong(juser.get((Object)"pis").toString());
        }
        catch (NumberFormatException nfe) {
            return 0L;
        }
    }

    protected JSONObject checkList(JSONObject juser) {
        JSONParser parser = new JSONParser();
        String default_user = "{\"code\":0,\"admin\":false,\"bars\":\"\"}";
        JSONObject ciduser = null;
        String[][] ft = new String[][]{{"nome", "name"}, {"senha", "password"}};
        long pis = 0L;
        long cpf = 0L;
        for (String string : new String[]{"cracha", "nome"}) {
            if (juser.containsKey((Object)string)) continue;
            return null;
        }
        if (juser.containsKey((Object)"pis")) {
            pis = this.getPIS(juser);
        }
        if (juser.containsKey((Object)"cpf") && this.modelo.indexOf("671") > 0) {
            cpf = Util.formatCpf(this.getCPF(juser));
        }
        if (pis == 0L && cpf == 0L) {
            this.sendMessage(3, "Falta PIS e CPF.");
            return null;
        }
        try {
            ciduser = (JSONObject)parser.parse(default_user);
            for (String string : ft) {
                if (!juser.containsKey((Object)string[0])) continue;
                ciduser.put((Object)string[1], juser.get((Object)string[0]));
            }
            ciduser.put((Object)"pis", (Object)pis);
            if (this.modelo.indexOf("671") > 0) {
                ciduser.put((Object)"cpf", (Object)cpf);
            }
        }
        catch (ParseException ioe) {
            this.verboseWARN("Erro ao tentar processar user default JSON.");
            return null;
        }
        return ciduser;
    }

    private int insertUpdateUser(JSONObject juser, JSONObject ciduser) throws InterruptedException {
        JSONObject req = new JSONObject();
        JSONArray batch = new JSONArray();
        for (String cmd : new String[]{"add", "update"}) {
            JSONObject ret2;
            Thread.sleep(1000L);
            this.session = null;
            JSONArray list_ciduser = new JSONArray();
            list_ciduser.add((Object)ciduser);
            req.put((Object)"users", (Object)list_ciduser);
            batch = this.exec(cmd + "_users.fcgi", req.toJSONString());
            if (batch == null || (ret2 = (JSONObject)batch.get(0)).containsKey((Object)"error")) continue;
            return 0;
        }
        if (this.modelo.indexOf("671") > 0) {
            return IFPONTO_config.valueOf((String)"ERRO_INSERT_CPF").codigo;
        }
        return IFPONTO_config.valueOf((String)"ERRO_INSERT_PIS").codigo;
    }

    @Override
    public int updateUser(Object ctx, JSONObject juser) {
        IfaceJSONIter iter2 = new IfaceJSONIter(){

            @Override
            public int perform(JSONObject cart, Object[] pars, int[] c) {
                if (cart.containsKey((Object)"ativo") && cart.get((Object)"ativo").toString().equals("0")) {
                    return 0;
                }
                String[] rs = (String[])pars[0];
                rs[0] = cart.get((Object)"nro").toString();
                return 1;
            }
        };
        String[] refs = new String[]{""};
        if (juser.containsKey((Object)"nro_cartao")) {
            int[] count = new int[]{0};
            JSONArray nros = (JSONArray)juser.get((Object)"nro_cartao");
            Util.jsonIter(nros, iter2, new Object[]{refs}, count);
        } else if (juser.containsKey((Object)"cracha")) {
            refs[0] = juser.get((Object)"cracha").toString();
        }
        if (refs[0].isEmpty()) {
            return IFPONTO_config.valueOf((String)"FALTA_PARAMETRO_CRACHA").codigo;
        }
        juser.put((Object)"cracha", (Object)refs[0]);
        JSONObject ciduser = this.checkList(juser);
        if (ciduser == null) {
            if (this.modelo.indexOf("671") > 0) {
                return IFPONTO_config.valueOf((String)"ERRO_INSERT_PIS").codigo;
            }
            return IFPONTO_config.valueOf((String)"ERRO_INSERT_CPF").codigo;
        }
        try {
            long rfid = Device.convertRFID_nominal2code(juser.get((Object)"cracha").toString());
            ciduser.put((Object)"rfid", (Object)rfid);
            this.insertUpdateUser(juser, ciduser);
        }
        catch (InterruptedException ie) {
            this.verboseERROR("Sleep Fail.");
        }
        return 0;
    }

    @Override
    public int deleteUser(Object ctx, JSONObject juser) {
        JSONObject req = new JSONObject();
        JSONArray batch = new JSONArray();
        long pis = this.getPIS(juser);
        long cpf = Util.formatCpf(this.getCPF(juser));
        if (pis == 0L) {
            return IFPONTO_config.valueOf((String)"FALTA_PARAMETRO_PIS").codigo;
        }
        if (cpf == 0L && this.modelo.indexOf("671") > 0) {
            return IFPONTO_config.valueOf((String)"FALTA_PARAMETRO_CPF").codigo;
        }
        this.session = null;
        ArrayList<Long> list_pis = new ArrayList<Long>();
        list_pis.add(pis);
        ArrayList<Long> list_cpf = new ArrayList<Long>();
        list_cpf.add(cpf);
        req.put((Object)"users", list_pis);
        if (this.modelo.indexOf("671") > 0) {
            req.put((Object)"users", list_cpf);
        }
        if ((batch = this.exec("remove_users.fcgi", req.toJSONString())) == null) {
            return IFPONTO_config.valueOf((String)"ERRO_COMUNICACAO").codigo;
        }
        JSONObject ret2 = (JSONObject)batch.get(0);
        if (ret2.containsKey((Object)"error")) {
            return IFPONTO_config.valueOf((String)"ERRO_DELETE").codigo;
        }
        return 0;
    }

    @Override
    public int sendUserBio(Object ctx, JSONObject juser) {
        IfaceJSONIter templatesIter = new IfaceJSONIter(){

            @Override
            public int perform(JSONObject jtemplate, Object[] pars, int[] c) {
                JSONArray templates = (JSONArray)pars[1];
                if (!jtemplate.containsKey((Object)"template")) {
                    return 0;
                }
                if (jtemplate.containsKey((Object)"vendor") && (jtemplate.get((Object)"vendor").toString().equals("idclass") || jtemplate.get((Object)"vendor").toString().equals("idbio"))) {
                    templates.add((Object)jtemplate.get((Object)"template").toString());
                }
                return 0;
            }
        };
        String[][] from2string = new String[][]{{"nome", "name", null}, {null, "bars", ""}, {"senha", "password", ""}};
        String[][] from2long = new String[][]{{null, "code", "0"}, {"cracha", "rfid", null}, {"pis", "pis", null}, {"cpf", "cpf", null}};
        JSONObject jciduser = new JSONObject();
        long pis = 0L;
        long cpf = 0L;
        if (!juser.containsKey((Object)"templates")) {
            return IFPONTO_config.valueOf((String)"BIO_NAO_ENCONTRADA").codigo;
        }
        for (String[] e : from2string) {
            if (e[0] == null) {
                jciduser.put((Object)e[1], (Object)e[2]);
                continue;
            }
            if (juser.containsKey((Object)e[0])) {
                jciduser.put((Object)e[1], (Object)juser.get((Object)e[0]).toString());
                continue;
            }
            if (e[2] != null) {
                jciduser.put((Object)e[1], (Object)e[2]);
                continue;
            }
            return IFPONTO_config.valueOf((String)"FALTA_PARAMETRO").codigo;
        }
        for (String[] e : from2long) {
            long default_val;
            try {
                default_val = Long.parseLong(e[2]);
            }
            catch (NumberFormatException nfe) {
                default_val = 0L;
            }
            if (e[0] == null) {
                jciduser.put((Object)e[1], (Object)default_val);
                continue;
            }
            if (juser.containsKey((Object)e[0])) {
                Object val = juser.get((Object)e[0]).toString();
                if (e[0].equals("cpf")) {
                    val = "" + Util.formatCpf(this.getCPF(juser));
                }
                if (e[0].equals("cracha")) {
                    default_val = Device.convertRFID_nominal2code((String)val);
                } else {
                    try {
                        default_val = Long.parseLong((String)val);
                    }
                    catch (NumberFormatException nfe) {
                        this.verboseERROR("Campo '" + e[0] + "' valor invalido: " + (String)val);
                        return IFPONTO_config.valueOf((String)"PARAMETRO_INVALIDO").codigo;
                    }
                }
                jciduser.put((Object)e[1], (Object)default_val);
                if (e[0].equals("pis")) {
                    pis = default_val;
                }
                if (!e[0].equals("cpf") || this.modelo.indexOf("671") <= 0) continue;
                cpf = default_val;
                continue;
            }
            if (e[2] != null) {
                jciduser.put((Object)e[1], (Object)default_val);
                continue;
            }
            return IFPONTO_config.valueOf((String)"FALTA_PARAMETRO").codigo;
        }
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException ie) {
            return IFPONTO_config.valueOf((String)"ERRO_INTERNO").codigo;
        }
        JSONObject req = new JSONObject();
        this.session = null;
        JSONArray templates = new JSONArray();
        jciduser.put((Object)"templates", (Object)templates);
        Util.jsonIter((JSONArray)juser.get((Object)"templates"), templatesIter, new Object[]{req, templates}, null);
        if (templates.size() < 1) {
            return IFPONTO_config.valueOf((String)"BIO_NAO_ENCONTRADA").codigo;
        }
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException ie) {
            return IFPONTO_config.valueOf((String)"ERRO_INTERNO").codigo;
        }
        this.deleteUserBio(ctx, juser);
        JSONArray list_ciduser = new JSONArray();
        list_ciduser.add((Object)jciduser);
        req.put((Object)"users", (Object)list_ciduser);
        JSONArray batch = null;
        batch = this.exec("update_users.fcgi", req.toJSONString());
        if (batch == null) {
            return IFPONTO_config.valueOf((String)"ERRO_COMUNICACAO").codigo;
        }
        JSONObject ret2 = (JSONObject)batch.get(0);
        if (ret2.containsKey((Object)"error")) {
            this.verboseERROR("Falha ao enviar biometria - PIS: " + pis + " (" + String.valueOf(ret2.get((Object)"error")) + ")");
            if (this.modelo.indexOf("671") > 0) {
                this.verboseERROR("Falha ao enviar biometria - CPF: " + cpf + " (" + String.valueOf(ret2.get((Object)"error")) + ")");
            }
            return IFPONTO_config.valueOf((String)"ERRO_INSERT_BIO").codigo;
        }
        return 0;
    }

    @Override
    public int deleteUserBio(Object ctx, JSONObject juser) {
        JSONObject reg = new JSONObject();
        long pis = this.getPIS(juser);
        long cpf = Util.formatCpf(this.getCPF(juser));
        if (pis == 0L) {
            return IFPONTO_config.valueOf((String)"FALTA_PARAMETRO_PIS").codigo;
        }
        if (cpf == 0L && this.modelo.indexOf("671") > 0) {
            return IFPONTO_config.valueOf((String)"FALTA_PARAMETRO_CPF").codigo;
        }
        reg.put((Object)"remove_templates", (Object)true);
        reg.put((Object)"pis", (Object)pis);
        if (this.modelo.indexOf("671") > 0) {
            reg.put((Object)"cpf", (Object)cpf);
        }
        this.session = null;
        JSONArray list_req = new JSONArray();
        list_req.add((Object)reg);
        JSONObject req = new JSONObject();
        req.put((Object)"users", (Object)list_req);
        this.exec("update_users.fcgi", req.toJSONString());
        return 0;
    }

    @Override
    public int getUserBio(Object ctx, JSONObject juser) {
        JSONObject jload;
        if (!juser.containsKey((Object)"pis")) {
            return IFPONTO_config.valueOf((String)"FALTA_PARAMETRO_PIS").codigo;
        }
        if (!juser.containsKey((Object)"cpf") && this.modelo.indexOf("671") > 0) {
            return IFPONTO_config.valueOf((String)"FALTA_PARAMETRO_CPF").codigo;
        }
        try {
            long pis = Long.parseLong(juser.get((Object)"pis").toString());
            long cpf = Util.formatCpf(juser.get((Object)"cpf").toString());
            Thread.sleep(500L);
            JSONObject req = new JSONObject();
            ArrayList<Long> list_pis = new ArrayList<Long>();
            list_pis.add(pis);
            ArrayList<Long> list_cpf = new ArrayList<Long>();
            list_cpf.add(cpf);
            req.put((Object)"users_pis", list_pis);
            if (this.modelo.indexOf("671") > 0) {
                req.put((Object)"users_cpf", list_cpf);
            }
            req.put((Object)"templates", (Object)true);
            this.session = null;
            JSONArray batch = this.execList("load_users.fcgi", req.toJSONString());
            if (batch == null) {
                return IFPONTO_config.valueOf((String)"ERRO_GET_USERS").codigo;
            }
            JSONObject obj = (JSONObject)batch.get(0);
            if (!obj.containsKey((Object)"users")) {
                return IFPONTO_config.valueOf((String)"ERRO_GET_USERS").codigo;
            }
            JSONArray aux = (JSONArray)obj.get((Object)"users");
            if (aux.size() < 1) {
                return IFPONTO_config.valueOf((String)"ERRO_GET_USERS").codigo;
            }
            jload = (JSONObject)aux.get(0);
        }
        catch (NumberFormatException nfe) {
            if (this.modelo.indexOf("671") > 0) {
                return IFPONTO_config.valueOf((String)"CPF_INVALIDO").codigo;
            }
            return IFPONTO_config.valueOf((String)"PIS_INVALIDO").codigo;
        }
        catch (InterruptedException ie) {
            this.verboseERROR(ie.getMessage());
            return IFPONTO_config.valueOf((String)"ERRO_INTERNO").codigo;
        }
        JSONArray tmps = (JSONArray)jload.get((Object)"templates");
        if (tmps.size() < 1) {
            return IFPONTO_config.valueOf((String)"ERRO_GET_USERS").codigo;
        }
        JSONArray ntmps = new JSONArray();
        for (int i = 0; i < tmps.size(); ++i) {
            JSONObject tmp = new JSONObject();
            tmp.put((Object)"template", tmps.get(i));
            tmp.put((Object)"vendor", (Object)"idclass");
            ntmps.add((Object)tmp);
        }
        juser.put((Object)"templates", (Object)ntmps);
        return IFPONTO_config.valueOf((String)"OK").codigo;
    }

    @Override
    public int getEvents(JSONArray offs) {
        String afd;
        JSONObject req = new JSONObject();
        req.put((Object)"initial_nsr", (Object)this.getNsr());
        String query = "session=" + this.session;
        try {
            this.login();
            query = "session=" + this.session;
            if (this.modelo.indexOf("671") > 0) {
                query = "session=" + this.session + "&mode=671";
            }
            byte[] data = req.toJSONString().getBytes();
            URL url = this.getURL(this.ip, this.port, "get_afd.fcgi", query);
            afd = Util.sendPOST(this, url, data, "application/json");
        }
        catch (IOException ioe) {
            this.verboseFATAL(ioe.getMessage());
            return -1;
        }
        if (afd == null) {
            return -2;
        }
        String[] lines = afd.split("\\r?\\n");
        int nsr = 0;
        if (lines.length < 1) {
            this.verboseWARN("AFD rejeitado: '" + afd + "'");
        }
        for (int i = 0; i < lines.length; ++i) {
            if (lines[i].length() < 20) {
                this.verboseWARN("Linha invalida: '" + lines[i] + "'");
                continue;
            }
            try {
                JSONObject reg = new JSONObject();
                reg.put((Object)"afd", (Object)lines[i]);
                String aux = lines[i].substring(0, 9);
                nsr = Integer.parseInt(aux);
                reg.put((Object)"nsr", (Object)nsr);
                String tr = lines[i].substring(9, 10);
                reg.put((Object)"tipo_registro", (Object)tr);
                if (tr.equals("3") && this.modelo.indexOf("671") < 0) {
                    reg.put((Object)"pis", (Object)lines[i].substring(23, 34));
                } else if (tr.equals("3") && this.modelo.indexOf("671") > 0) {
                    reg.put((Object)"cpf", (Object)lines[i].substring(35, 46));
                }
                offs.add((Object)reg);
                continue;
            }
            catch (NumberFormatException nfe) {
                this.verboseWARN("Linha invalida: '" + lines[i] + "'");
            }
        }
        return nsr + 1;
    }

    @Override
    public JSONArray getUsers() {
        JSONObject req = new JSONObject();
        int limit = 100;
        String[][] ft = new String[][]{{"name", "nome"}, {"password", "senha"}};
        JSONArray usrs = new JSONArray();
        int offset = 0;
        while (true) {
            JSONArray aux;
            JSONObject obj;
            req.put((Object)"limit", (Object)limit);
            req.put((Object)"offset", (Object)offset);
            JSONArray batch = this.execList("load_users.fcgi", req.toJSONString());
            if (batch == null || !(obj = (JSONObject)batch.get(0)).containsKey((Object)"users") || (aux = (JSONArray)obj.get((Object)"users")).size() < 1) break;
            for (JSONObject reg : aux) {
                for (String[] pair : ft) {
                    if (!reg.containsKey((Object)pair[0])) continue;
                    reg.put((Object)pair[1], reg.get((Object)pair[0]));
                    reg.remove((Object)pair[0]);
                }
                reg.put((Object)"bio_qty", reg.get((Object)"templates_count"));
                reg.put((Object)"cracha", (Object)IDClass.convertRFID_code2nominal((Long)reg.get((Object)"rfid")));
                reg.put((Object)"cod", (Object)0);
                reg.put((Object)"codigo", (Object)0);
                usrs.add((Object)reg);
            }
            offset += limit;
        }
        return usrs;
    }

    @Override
    public byte[] handler(String[] headers, String type, String path, String[] GET, JSONObject jdata) {
        return null;
    }

    @Override
    public byte[] handler(String[] headers, String type, String path, String[] GET, String data) {
        return null;
    }

    @Override
    public boolean checkDevice(String ip, String[] dataIn) {
        return false;
    }
}

