/*
 * Decompiled with CFR 0.152.
 */
package com.ifractal.ifponto;

import com.ifractal.ifponto.DeviceListener;
import com.ifractal.utils.Observer;
import com.ifractal.utils.Verbosity;
import java.util.Date;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public abstract class DeviceProducer
extends Verbosity {
    public String notify = "";
    public int progressPos = 0;
    public int progressTotal = 0;
    private DeviceListener[] listeners = null;

    public DeviceProducer(Observer obs, DeviceListener dl) {
        super(obs);
        this.addListener(dl);
    }

    public DeviceProducer(long[] ctx, String[] args) {
        super(ctx, args);
    }

    public DeviceProducer() {
    }

    public int addListener(DeviceListener dl) {
        if (dl == null) {
            return 0;
        }
        if (this.listeners == null) {
            this.listeners = new DeviceListener[]{dl};
            return 1;
        }
        int len = this.listeners.length;
        for (DeviceListener e : this.listeners) {
            if (e != dl) continue;
            return len;
        }
        DeviceListener[] list = new DeviceListener[len + 1];
        for (int i = 0; i < len; ++i) {
            list[i] = this.listeners[i];
        }
        list[len] = dl;
        this.listeners = list;
        return len + 1;
    }

    protected void notifyLoop(JSONObject dev, boolean alive) {
        if (this.listeners == null) {
            return;
        }
        for (int i = 0; i < this.listeners.length; ++i) {
            if (alive) {
                this.listeners[i].onStart(dev);
                continue;
            }
            this.listeners[i].onStop(dev);
        }
    }

    protected void notifyGetTime(JSONObject dev, Date dt) {
        this.progressPos = 1;
        this.progressTotal = 6;
        this.notify = "Get Time";
        if (this.listeners == null) {
            return;
        }
        for (int i = 0; i < this.listeners.length; ++i) {
            this.listeners[i].onGetTime(dev, dt);
        }
    }

    protected void notifySetTime(JSONObject dev, int timediff) {
        this.progressPos = 2;
        this.progressTotal = 6;
        this.notify = "Set Time";
        if (this.listeners == null) {
            return;
        }
        for (int i = 0; i < this.listeners.length; ++i) {
            this.listeners[i].onSetTime(dev, timediff);
        }
    }

    protected void notifyEvents(JSONObject dev, JSONArray offs) {
        this.progressPos = 3;
        this.progressTotal = 6;
        this.notify = "Events";
        if (this.listeners == null) {
            return;
        }
        for (int i = 0; i < this.listeners.length; ++i) {
            this.listeners[i].onEvents(dev, offs);
        }
    }

    protected void notifySendUser(JSONObject dev, JSONObject user, JSONObject res, int pos, int total) {
        this.progressPos = pos;
        this.progressTotal = total;
        this.notify = "Send User";
        if (this.listeners == null) {
            return;
        }
        for (int i = 0; i < this.listeners.length; ++i) {
            this.listeners[i].onSendUser(dev, user, res, pos, total);
        }
    }

    protected void notifyGetBio(JSONObject dev, JSONObject userBios, int pos, int total) {
        this.progressPos = pos;
        this.progressTotal = total;
        this.notify = "Get Bio";
        if (this.listeners == null) {
            return;
        }
        for (int i = 0; i < this.listeners.length; ++i) {
            this.listeners[i].onGetBio(dev, userBios, pos, total);
        }
    }

    protected void notifyFinalize(JSONObject dev, boolean online, JSONArray users, JSONArray res) {
        this.progressPos = 6;
        this.progressTotal = 6;
        this.notify = "finalize";
        if (this.listeners == null) {
            return;
        }
        for (int i = 0; i < this.listeners.length; ++i) {
            this.listeners[i].onFinalize(dev, online, users, res);
        }
    }
}

