/*
 * Decompiled with CFR 0.152.
 */
package com.ifractal.ifponto;

import com.ifractal.ifponto.IDAccess;
import com.ifractal.utils.Observer;
import com.ifractal.utils.Producer;
import com.ifractal.utils.Util;
import org.json.simple.JSONObject;

public class CIDConfig {
    public static final void main(String[] args) {
        int i;
        JSONObject jconfig = new JSONObject();
        String[] config = new String[]{"verbosity", "5", "user", "admin", "pass", "admin", "nro", "1", "ip", "192.168.1.100", "porta", "80", "cloud_ip", "74.50.60.155", "cloud_port", "8088", "monitor_ip", "192.168.1.10", "monitor_port", "0", "server_id", "1", "server_ip", "192.168.1.20", "server_port", "0", "server_path", "online", "server_name", "test", "timeout", "5000", "path", "online", "monitor_path", "online", "modo", "0", "local_identification", "0", "password_only", "0", "user_name", "ifractal"};
        if (args.length < 2) {
            System.err.println("\nConfigurador HTTP Push (Cloud) para ControlID\n");
            System.err.println("Uso:\n\tshell$ java -classpath jars/ifractal.jar:jars/json-simple-1.1.jar com.ifractal.ifponto.CIDConfig <KEY> <VALUE> ... <KEY N> <VALUE N>\n");
            System.err.println("Onde <KEY> <VALUE>:");
            i = 0;
            while (i + 1 < config.length) {
                System.err.println("\t" + config[i] + " => " + config[i + 1]);
                i += 2;
            }
            System.err.println("\nExemplo:\n\t(Define Servidor Nuvem)\n\tshell$ java -classpath jars/ifractal.jar:jars/json-simple-1.1.jar com.ifractal.ifponto.CIDConfig ip 192.168.1.200 porta 80\n");
            System.err.println("\t(Define monitor)\n\tshell$ java -classpath jars/ifractal.jar:jars/json-simple-1.1.jar com.ifractal.ifponto.CIDConfig ip 192.168.1.200 porta 80 monitor_ip 192.168.1.200 monitor_port 80 monitor_path 'online/acesso' timeout 5000\n\n");
            System.err.println("\t(Cria configuracao do servidor)\n\tshell$ java -classpath jars/ifractal.jar:jars/json-simple-1.1.jar com.ifractal.ifponto.CIDConfig ip 192.168.1.200 porta 80 server_ip '192.168.1.200' server_port 8000 server_name 'ifractal' server_path 'online/acesso'\n\n");
            System.err.println("\t(Atualiza a configuracao do servidor)\n\tshell$ java -classpath jars/ifractal.jar:jars/json-simple-1.1.jar com.ifractal.ifponto.CIDConfig ip 192.168.1.200 porta 80 server_ip '192.168.1.200' server_port 8000 server_id 4408801109223850 server_path 'online/acesso'\n\n");
            System.err.println("\t(Define modo online pro)\n\tshell$ java -classpath jars/ifractal.jar:jars/json-simple-1.1.jar com.ifractal.ifponto.CIDConfig ip 192.168.1.200 porta 80 modo 1 local_identification 1 password_only '1234'\n\n");
            System.err.println("\t(Exclui configuracao do servidor)\n\tshell$ java -classpath jars/ifractal.jar:jars/json-simple-1.1.jar com.ifractal.ifponto.CIDConfig ip 192.168.1.200 porta 80 server_name 'ifractal'\n\n");
            System.exit(1);
        }
        i = 0;
        while (i + 1 < args.length) {
            config = Util.setValueInArgs(config, args[i], args[i + 1]);
            i += 2;
        }
        i = 0;
        while (i + 1 < config.length) {
            jconfig.put((Object)config[i], (Object)config[i + 1]);
            i += 2;
        }
        Observer obs = new Observer(){

            @Override
            public void onMessage(Producer prod, int level, String msg, int code) {
            }

            @Override
            public void onMessage(Producer prod, int level, String msg) {
            }
        };
        IDAccess dev = new IDAccess(jconfig);
        String ip = Util.getValueFromArgs(config, "cloud_ip");
        int port = Util.getIntFromArgs(config, "cloud_port");
        String monitor_ip = Util.getValueFromArgs(config, "monitor_ip");
        int monitor_port = Util.getIntFromArgs(config, "monitor_port");
        String server_ip = Util.getValueFromArgs(config, "server_ip");
        String server_name = Util.getValueFromArgs(config, "server_name");
        int server_port = Util.getIntFromArgs(config, "server_port");
        String server_path = Util.getValueFromArgs(config, "server_path");
        long server_id = Util.getLongFromArgs(config, "server_id");
        String sn = Util.getValueFromArgs(config, "SN");
        int to = Util.getIntFromArgs(config, "timeout");
        String path = Util.getValueFromArgs(config, "path");
        String monitor_path = Util.getValueFromArgs(config, "monitor_path");
        int modo = Util.getIntFromArgs(config, "modo");
        String password_only = Util.getValueFromArgs(config, "password_only");
        int local_identification = Util.getIntFromArgs(config, "local_identification");
        int r = 0;
        dev.addObserver(obs);
        if (sn == null) {
            if (path == null) {
                r = dev.setPushConfiguration(ip, port);
                dev.loadServerConfiguration();
                if (r != 0) {
                    System.err.println("Falha ao tentar configurar HTTP Push...");
                } else {
                    System.out.println("HTTP Push configurado em: " + ip + ":" + port);
                }
            } else if (monitor_port != 0) {
                r = dev.setMonitorConfiguration(monitor_ip, monitor_port, monitor_path, to);
                dev.loadServerConfiguration();
                if (r != 0) {
                    System.err.println("Falha ao tentar configurar Monitor (Verificacao ONLINE)...");
                } else {
                    System.out.println("Monitor Online configurado em: " + ip + ":" + port + "/" + path + "  (" + to + ")");
                }
            } else if (server_port != 0) {
                r = dev.createServerConfiguration(server_ip, server_port, server_name, server_path);
                dev.loadServerConfiguration();
                if (r != 0) {
                    System.err.println("Falha ao tentar configurar Server (Verificacao ONLINE)...");
                } else {
                    System.out.println("Server Online configurado em: " + server_ip + ":" + server_port);
                }
            } else if (server_id > 1L) {
                r = dev.updateServerConfiguration(server_ip, server_port, server_id, server_path);
                dev.loadServerConfiguration();
                if (r != 0) {
                    System.err.println("Falha ao tentar atualizar Server (Verificacao ONLINE)...");
                } else {
                    System.out.println("Erro ao atualizar server: " + server_ip);
                }
            } else if (modo != 0) {
                r = dev.setOnlineModoPro(modo, local_identification, password_only);
                dev.loadServerConfiguration();
                if (r != 0) {
                    System.err.println("Falha ao tentar configurar modo ONLINE");
                } else {
                    System.out.println("Erro ao atualizar server");
                }
            } else if (!server_name.equals("test")) {
                r = dev.destroyServerConfiguration(server_name);
                dev.loadServerConfiguration();
                if (r != 0) {
                    System.err.println("Falha ao tentar remover Server (Verificacao ONLINE)...");
                } else {
                    System.out.println("Erro ao atualizar server: " + server_id);
                }
            }
            return;
        }
        JSONObject jconf = new JSONObject();
        dev.getInfo(jconf);
        System.out.println("{\"SN\":\"" + String.valueOf(jconf.get((Object)"deviceId")) + "\"}");
    }
}

