/*
 * Decompiled with CFR 0.152.
 */
package com.ifractal.desktop;

import com.ifractal.desktop.Scanner;
import com.ifractal.desktop.ScannerListener;

public class ScannerNative<T>
extends Scanner<T> {
    protected long ptr = 0L;
    Thread thScanner = null;
    int lastReturn = 0;

    protected static native String[] getVendorsC();

    protected native String[] enumerateC(String var1);

    protected native long initC(String var1);

    protected native int terminateC(long var1);

    protected native int openC(long var1, int var3);

    protected native int closeC(long var1);

    protected native String[] getInfoC(long var1);

    protected native int captureImageC(long var1, ScannerListener<T> var3, int var4, T var5);

    protected native int enrollC(long var1, ScannerListener<T> var3, int var4, String var5, byte[] var6, T var7);

    protected native int verifyC(long var1, ScannerListener<T> var3, byte[] var4, T var5);

    protected native int deleteAllC(long var1);

    protected native int deleteBioC(long var1, String var3);

    public static final String[] getVendors() {
        String[] scans = new String[]{};
        try {
            System.loadLibrary("scanner");
            scans = ScannerNative.getVendorsC();
        }
        catch (UnsatisfiedLinkError e) {
            System.err.println(e.getMessage());
        }
        return scans;
    }

    public ScannerNative(long[] ctx, String[] args) {
        super(ctx, args);
        ScannerNative.getVendors();
    }

    public ScannerNative(long[] ctx, String[] args, ScannerListener<T> sl) {
        super(ctx, args, sl);
    }

    @Override
    public boolean isAlive() {
        return this.thScanner.isAlive();
    }

    @Override
    public int getLastReturn() {
        return this.lastReturn;
    }

    @Override
    public int init(int index) {
        String v = this.vendor;
        if (v == null) {
            v = "";
        }
        this.ptr = this.initC(this.vendor);
        if (this.ptr == 0L) {
            return -2;
        }
        int r = this.openC(this.ptr, index);
        return r;
    }

    @Override
    public int terminate() {
        int r = 0;
        if (this.ptr != 0L) {
            r = this.terminateC(this.ptr);
        }
        return r;
    }

    @Override
    public String[] enumerate(String vendor) {
        super.enumerate(vendor);
        String[] devs = this.enumerateC(vendor);
        return devs;
    }

    @Override
    public String[] getInfo() {
        String[] r = this.getInfoC(this.ptr);
        return r;
    }

    @Override
    public int captureImage(final int qty_samples, final T user_data) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                ScannerNative.this.lastReturn = ScannerNative.this.captureImageC(ScannerNative.this.ptr, ScannerNative.this.listener, qty_samples, user_data);
            }
        };
        if (this.thScanner != null && this.thScanner.isAlive()) {
            return 0;
        }
        this.thScanner = new Thread(runnable);
        this.thScanner.start();
        return 0;
    }

    @Override
    public int enroll(final int qty_frames, final String id, final byte[] quality, final T user_data) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                ScannerNative.this.lastReturn = ScannerNative.this.enrollC(ScannerNative.this.ptr, ScannerNative.this.listener, qty_frames, id, quality, user_data);
            }
        };
        if (this.thScanner != null && this.thScanner.isAlive()) {
            return 0;
        }
        this.thScanner = new Thread(runnable);
        this.thScanner.start();
        return 0;
    }

    @Override
    public String identify(int[] finger, int[] score, T user_data) {
        return "";
    }

    @Override
    public int verify(final byte[] template, final T user_data) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                ScannerNative.this.lastReturn = ScannerNative.this.verifyC(ScannerNative.this.ptr, ScannerNative.this.listener, template, user_data);
            }
        };
        if (this.thScanner != null && this.thScanner.isAlive()) {
            return 0;
        }
        this.thScanner = new Thread(runnable);
        this.thScanner.start();
        return 0;
    }

    @Override
    public int deleteBio(String id) {
        int r = this.deleteBioC(this.ptr, id);
        return r;
    }

    @Override
    public int deleteAll() {
        int r = this.deleteAllC(this.ptr);
        return r;
    }
}

